// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the configuration of an access source.
func (c *Client) UpdateAccessSource(ctx context.Context, params *UpdateAccessSourceInput, optFns ...func(*Options)) (*UpdateAccessSourceOutput, error) {
	if params == nil {
		params = &UpdateAccessSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAccessSource", params, optFns, c.addOperationUpdateAccessSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAccessSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAccessSourceInput struct {

	// The unique identifier of the access source to update.
	//
	// This member is required.
	AccessSourceId *string

	// The CIDR block for the access source.
	Cidr *string

	// The IP address type for the access source.
	IpAddressType types.IpAddressType

	// The name of the access source.
	Name *string

	// The protocol for the access source.
	Protocol types.DnsProtocol

	noSmithyDocumentSerde
}

type UpdateAccessSourceOutput struct {

	// The Amazon Resource Name (ARN) of the updated access source.
	//
	// This member is required.
	Arn *string

	// The CIDR block of the updated access source.
	//
	// This member is required.
	Cidr *string

	// The date and time when the access source was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view associated with the updated access source.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier of the updated access source.
	//
	// This member is required.
	Id *string

	// The IP address type of the updated access source.
	//
	// This member is required.
	IpAddressType types.IpAddressType

	// The protocol of the updated access source.
	//
	// This member is required.
	Protocol types.DnsProtocol

	// The current status of the updated access source.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the access source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The name of the updated access source.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAccessSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAccessSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAccessSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAccessSource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAccessSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAccessSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAccessSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAccessSource",
	}
}
