// Code generated by smithy-go-codegen DO NOT EDIT.

package route53resolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53resolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a single DNS Firewall rule in the specified rule group, using the
// specified domain list.
func (c *Client) CreateFirewallRule(ctx context.Context, params *CreateFirewallRuleInput, optFns ...func(*Options)) (*CreateFirewallRuleOutput, error) {
	if params == nil {
		params = &CreateFirewallRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFirewallRule", params, optFns, c.addOperationCreateFirewallRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFirewallRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFirewallRuleInput struct {

	// The action that DNS Firewall should take on a DNS query when it matches one of
	// the domains in the rule's domain list, or a threat in a DNS Firewall Advanced
	// rule:
	//
	//   - ALLOW - Permit the request to go through. Not available for DNS Firewall
	//   Advanced rules.
	//
	//   - ALERT - Permit the request and send metrics and logs to Cloud Watch.
	//
	//   - BLOCK - Disallow the request. This option requires additional details in the
	//   rule's BlockResponse .
	//
	// This member is required.
	Action types.Action

	// A unique string that identifies the request and that allows you to retry failed
	// requests without the risk of running the operation twice. CreatorRequestId can
	// be any unique string, for example, a date/time stamp.
	//
	// This member is required.
	CreatorRequestId *string

	// The unique identifier of the firewall rule group where you want to create the
	// rule.
	//
	// This member is required.
	FirewallRuleGroupId *string

	// A name that lets you identify the rule in the rule group.
	//
	// This member is required.
	Name *string

	// The setting that determines the processing order of the rule in the rule group.
	// DNS Firewall processes the rules in a rule group by order of priority, starting
	// from the lowest setting.
	//
	// You must specify a unique priority for each rule in a rule group. To make it
	// easier to insert rules later, leave space between the numbers, for example, use
	// 100, 200, and so on. You can change the priority setting for the rules in a rule
	// group at any time.
	//
	// This member is required.
	Priority *int32

	// The DNS record's type. This determines the format of the record value that you
	// provided in BlockOverrideDomain . Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	//
	// This setting is required if the BlockResponse setting is OVERRIDE .
	BlockOverrideDnsType types.BlockOverrideDnsType

	// The custom DNS record to send back in response to the query. Used for the rule
	// action BLOCK with a BlockResponse setting of OVERRIDE .
	//
	// This setting is required if the BlockResponse setting is OVERRIDE .
	BlockOverrideDomain *string

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	//
	// This setting is required if the BlockResponse setting is OVERRIDE .
	BlockOverrideTtl *int32

	// The way that you want DNS Firewall to block the request, used with the rule
	// action setting BLOCK .
	//
	//   - NODATA - Respond indicating that the query was successful, but no response
	//   is available for it.
	//
	//   - NXDOMAIN - Respond indicating that the domain name that's in the query
	//   doesn't exist.
	//
	//   - OVERRIDE - Provide a custom override in the response. This option requires
	//   custom handling details in the rule's BlockOverride* settings.
	//
	// This setting is required if the rule action setting is BLOCK .
	BlockResponse types.BlockResponse

	//  The confidence threshold for DNS Firewall Advanced. You must provide this
	// value when you create a DNS Firewall Advanced rule. The confidence level values
	// mean:
	//
	//   - LOW : Provides the highest detection rate for threats, but also increases
	//   false positives.
	//
	//   - MEDIUM : Provides a balance between detecting threats and false positives.
	//
	//   - HIGH : Detects only the most well corroborated threats with a low rate of
	//   false positives.
	ConfidenceThreshold types.ConfidenceThreshold

	//  Use to create a DNS Firewall Advanced rule.
	DnsThreatProtection types.DnsThreatProtection

	// The ID of the domain list that you want to use in the rule. Can't be used
	// together with DnsThreatProtecton .
	FirewallDomainListId *string

	//  How you want the the rule to evaluate DNS redirection in the DNS redirection
	// chain, such as CNAME or DNAME.
	//
	// INSPECT_REDIRECTION_DOMAIN : (Default) inspects all domains in the redirection
	// chain. The individual domains in the redirection chain must be added to the
	// domain list.
	//
	// TRUST_REDIRECTION_DOMAIN : Inspects only the first domain in the redirection
	// chain. You don't need to add the subsequent domains in the domain in the
	// redirection list to the domain list.
	FirewallDomainRedirectionAction types.FirewallDomainRedirectionAction

	//  The DNS query type you want the rule to evaluate. Allowed values are;
	//
	//   - A: Returns an IPv4 address.
	//
	//   - AAAA: Returns an Ipv6 address.
	//
	//   - CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
	//
	//   - CNAME: Returns another domain name.
	//
	//   - DS: Record that identifies the DNSSEC signing key of a delegated zone.
	//
	//   - MX: Specifies mail servers.
	//
	//   - NAPTR: Regular-expression-based rewriting of domain names.
	//
	//   - NS: Authoritative name servers.
	//
	//   - PTR: Maps an IP address to a domain name.
	//
	//   - SOA: Start of authority record for the zone.
	//
	//   - SPF: Lists the servers authorized to send emails from a domain.
	//
	//   - SRV: Application specific values that identify servers.
	//
	//   - TXT: Verifies email senders and application-specific values.
	//
	//   - A query type you define by using the DNS type ID, for example 28 for AAAA.
	//   The values must be defined as TYPENUMBER, where the NUMBER can be 1-65334, for
	//   example, TYPE28. For more information, see [List of DNS record types].
	//
	// [List of DNS record types]: https://en.wikipedia.org/wiki/List_of_DNS_record_types
	Qtype *string

	noSmithyDocumentSerde
}

type CreateFirewallRuleOutput struct {

	// The firewall rule that you just created.
	FirewallRule *types.FirewallRule

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFirewallRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFirewallRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateFirewallRuleMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFirewallRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFirewallRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateFirewallRule struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateFirewallRule) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateFirewallRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateFirewallRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateFirewallRuleInput ")
	}

	if input.CreatorRequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.CreatorRequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateFirewallRuleMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateFirewallRule{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateFirewallRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFirewallRule",
	}
}
