// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
)

// Returns a list of the access points that are owned by the Amazon Web Services
// account and that are associated with the specified directory bucket.
//
// To list access points for general purpose buckets, see [ListAccesspoints].
//
// To use this operation, you must have the permission to perform the
// s3express:ListAccessPointsForDirectoryBuckets action.
//
// For information about REST API errors, see [REST error responses].
//
// [REST error responses]: https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#RESTErrorResponses
// [ListAccesspoints]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html
func (c *Client) ListAccessPointsForDirectoryBuckets(ctx context.Context, params *ListAccessPointsForDirectoryBucketsInput, optFns ...func(*Options)) (*ListAccessPointsForDirectoryBucketsOutput, error) {
	if params == nil {
		params = &ListAccessPointsForDirectoryBucketsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccessPointsForDirectoryBuckets", params, optFns, c.addOperationListAccessPointsForDirectoryBucketsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccessPointsForDirectoryBucketsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccessPointsForDirectoryBucketsInput struct {

	// The Amazon Web Services account ID that owns the access points.
	//
	// This member is required.
	AccountId *string

	// The name of the directory bucket associated with the access points you want to
	// list.
	DirectoryBucket *string

	// The maximum number of access points that you would like returned in the
	// ListAccessPointsForDirectoryBuckets response. If the directory bucket is
	// associated with more than this number of access points, the results include the
	// pagination token NextToken . Make another call using the NextToken to retrieve
	// more results.
	MaxResults int32

	//  If NextToken is returned, there are more access points available than
	// requested in the maxResults value. The value of NextToken is a unique
	// pagination token for each page. Make the call again using the returned token to
	// retrieve the next page. Keep all other arguments unchanged. Each pagination
	// token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

func (in *ListAccessPointsForDirectoryBucketsInput) bindEndpointParams(p *EndpointParameters) {

	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
	p.UseS3ExpressControlEndpoint = ptr.Bool(true)
}

type ListAccessPointsForDirectoryBucketsOutput struct {

	// Contains identification and configuration information for one or more access
	// points associated with the directory bucket.
	AccessPointList []types.AccessPoint

	//  If NextToken is returned, there are more access points available than
	// requested in the maxResults value. The value of NextToken is a unique
	// pagination token for each page. Make the call again using the returned token to
	// retrieve the next page. Keep all other arguments unchanged. Each pagination
	// token expires after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccessPointsForDirectoryBucketsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListAccessPointsForDirectoryBuckets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListAccessPointsForDirectoryBuckets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccessPointsForDirectoryBuckets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccessPointsForDirectoryBucketsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccessPointsForDirectoryBuckets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addListAccessPointsForDirectoryBucketsUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAccessPointsForDirectoryBucketsPaginatorOptions is the paginator options
// for ListAccessPointsForDirectoryBuckets
type ListAccessPointsForDirectoryBucketsPaginatorOptions struct {
	// The maximum number of access points that you would like returned in the
	// ListAccessPointsForDirectoryBuckets response. If the directory bucket is
	// associated with more than this number of access points, the results include the
	// pagination token NextToken . Make another call using the NextToken to retrieve
	// more results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccessPointsForDirectoryBucketsPaginator is a paginator for
// ListAccessPointsForDirectoryBuckets
type ListAccessPointsForDirectoryBucketsPaginator struct {
	options   ListAccessPointsForDirectoryBucketsPaginatorOptions
	client    ListAccessPointsForDirectoryBucketsAPIClient
	params    *ListAccessPointsForDirectoryBucketsInput
	nextToken *string
	firstPage bool
}

// NewListAccessPointsForDirectoryBucketsPaginator returns a new
// ListAccessPointsForDirectoryBucketsPaginator
func NewListAccessPointsForDirectoryBucketsPaginator(client ListAccessPointsForDirectoryBucketsAPIClient, params *ListAccessPointsForDirectoryBucketsInput, optFns ...func(*ListAccessPointsForDirectoryBucketsPaginatorOptions)) *ListAccessPointsForDirectoryBucketsPaginator {
	if params == nil {
		params = &ListAccessPointsForDirectoryBucketsInput{}
	}

	options := ListAccessPointsForDirectoryBucketsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccessPointsForDirectoryBucketsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccessPointsForDirectoryBucketsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccessPointsForDirectoryBuckets page.
func (p *ListAccessPointsForDirectoryBucketsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccessPointsForDirectoryBucketsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccessPointsForDirectoryBuckets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func (m *ListAccessPointsForDirectoryBucketsInput) GetARNMember() (*string, bool) {
	if m.DirectoryBucket == nil {
		return nil, false
	}
	return m.DirectoryBucket, true
}

func (m *ListAccessPointsForDirectoryBucketsInput) SetARNMember(v string) error {
	m.DirectoryBucket = &v
	return nil
}

// ListAccessPointsForDirectoryBucketsAPIClient is a client that implements the
// ListAccessPointsForDirectoryBuckets operation.
type ListAccessPointsForDirectoryBucketsAPIClient interface {
	ListAccessPointsForDirectoryBuckets(context.Context, *ListAccessPointsForDirectoryBucketsInput, ...func(*Options)) (*ListAccessPointsForDirectoryBucketsOutput, error)
}

var _ ListAccessPointsForDirectoryBucketsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccessPointsForDirectoryBuckets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccessPointsForDirectoryBuckets",
	}
}

func copyListAccessPointsForDirectoryBucketsInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*ListAccessPointsForDirectoryBucketsInput)
	if !ok {
		return nil, fmt.Errorf("expect *ListAccessPointsForDirectoryBucketsInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *ListAccessPointsForDirectoryBucketsInput) copy() interface{} {
	v := *in
	return &v
}
func getListAccessPointsForDirectoryBucketsARNMember(input interface{}) (*string, bool) {
	in := input.(*ListAccessPointsForDirectoryBucketsInput)
	if in.DirectoryBucket == nil {
		return nil, false
	}
	return in.DirectoryBucket, true
}
func setListAccessPointsForDirectoryBucketsARNMember(input interface{}, v string) error {
	in := input.(*ListAccessPointsForDirectoryBucketsInput)
	in.DirectoryBucket = &v
	return nil
}
func backFillListAccessPointsForDirectoryBucketsAccountID(input interface{}, v string) error {
	in := input.(*ListAccessPointsForDirectoryBucketsInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addListAccessPointsForDirectoryBucketsUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: getListAccessPointsForDirectoryBucketsARNMember,
			BackfillAccountID: backFillListAccessPointsForDirectoryBucketsAccountID,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    setListAccessPointsForDirectoryBucketsARNMember,
			CopyInput:         copyListAccessPointsForDirectoryBucketsInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
