// Code generated by smithy-go-codegen DO NOT EDIT.

package s3vectors

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a vector bucket in the Amazon Web Services Region that you want your
// bucket to be in.
//
// Permissions You must have the s3vectors:CreateVectorBucket permission to use
// this operation.
//
// You must have the s3vectors:TagResource permission in addition to
// s3vectors:CreateVectorBucket permission to create a vector bucket with tags.
func (c *Client) CreateVectorBucket(ctx context.Context, params *CreateVectorBucketInput, optFns ...func(*Options)) (*CreateVectorBucketOutput, error) {
	if params == nil {
		params = &CreateVectorBucketInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateVectorBucket", params, optFns, c.addOperationCreateVectorBucketMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateVectorBucketOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateVectorBucketInput struct {

	// The name of the vector bucket to create.
	//
	// This member is required.
	VectorBucketName *string

	// The encryption configuration for the vector bucket. By default, if you don't
	// specify, all new vectors in Amazon S3 vector buckets use server-side encryption
	// with Amazon S3 managed keys (SSE-S3), specifically AES256 .
	EncryptionConfiguration *types.EncryptionConfiguration

	// An array of user-defined tags that you would like to apply to the vector bucket
	// that you are creating. A tag is a key-value pair that you apply to your
	// resources. Tags can help you organize and control access to resources. For more
	// information, see [Tagging for cost allocation or attribute-based access control (ABAC)].
	//
	// You must have the s3vectors:TagResource permission in addition to
	// s3vectors:CreateVectorBucket permission to create a vector bucket with tags.
	//
	// [Tagging for cost allocation or attribute-based access control (ABAC)]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateVectorBucketOutput struct {

	// The Amazon Resource Name (ARN) of the newly created vector bucket.
	//
	// This member is required.
	VectorBucketArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateVectorBucketMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateVectorBucket{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateVectorBucket{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateVectorBucket"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateVectorBucketValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateVectorBucket(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateVectorBucket(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateVectorBucket",
	}
}
