// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The encryption configuration for a vector bucket or index. By default, if you
// don't specify, all new vectors in Amazon S3 vector buckets use server-side
// encryption with Amazon S3 managed keys (SSE-S3), specifically AES256 . You can
// optionally override bucket level encryption settings, and set a specific
// encryption configuration for a vector index at the time of index creation.
type EncryptionConfiguration struct {

	// Amazon Web Services Key Management Service (KMS) customer managed key ID to use
	// for the encryption configuration. This parameter is allowed if and only if
	// sseType is set to aws:kms .
	//
	// To specify the KMS key, you must use the format of the KMS key Amazon Resource
	// Name (ARN).
	//
	// For example, specify Key ARN in the following format:
	// arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	KmsKeyArn *string

	// The server-side encryption type to use for the encryption configuration of the
	// vector bucket. By default, if you don't specify, all new vectors in Amazon S3
	// vector buckets use server-side encryption with Amazon S3 managed keys (SSE-S3),
	// specifically AES256 .
	SseType SseType

	noSmithyDocumentSerde
}

// The attributes of a vector returned by the GetVectors operation.
type GetOutputVector struct {

	// The name of the vector.
	//
	// This member is required.
	Key *string

	// The vector data of the vector.
	Data VectorData

	// Metadata about the vector.
	Metadata document.Interface

	noSmithyDocumentSerde
}

// The attributes of a vector index.
type Index struct {

	// Date and time when the vector index was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The data type of the vectors inserted into the vector index.
	//
	// This member is required.
	DataType DataType

	// The number of values in the vectors that are inserted into the vector index.
	//
	// This member is required.
	Dimension *int32

	// The distance metric to be used for similarity search.
	//
	// This member is required.
	DistanceMetric DistanceMetric

	// The Amazon Resource Name (ARN) of the vector index.
	//
	// This member is required.
	IndexArn *string

	// The name of the vector index.
	//
	// This member is required.
	IndexName *string

	// The name of the vector bucket that contains the vector index.
	//
	// This member is required.
	VectorBucketName *string

	// The encryption configuration for a vector index. By default, if you don't
	// specify, all new vectors in the vector index will use the encryption
	// configuration of the vector bucket.
	EncryptionConfiguration *EncryptionConfiguration

	// The metadata configuration for the vector index.
	MetadataConfiguration *MetadataConfiguration

	noSmithyDocumentSerde
}

// Summary information about a vector index.
type IndexSummary struct {

	// Date and time when the vector index was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the vector index.
	//
	// This member is required.
	IndexArn *string

	// The name of the vector index.
	//
	// This member is required.
	IndexName *string

	// The name of the vector bucket that contains the vector index.
	//
	// This member is required.
	VectorBucketName *string

	noSmithyDocumentSerde
}

// The attributes of a vector returned by the ListVectors operation.
type ListOutputVector struct {

	// The name of the vector.
	//
	// This member is required.
	Key *string

	// The vector data of the vector.
	Data VectorData

	// Metadata about the vector.
	Metadata document.Interface

	noSmithyDocumentSerde
}

// The metadata configuration for a vector index.
type MetadataConfiguration struct {

	// Non-filterable metadata keys allow you to enrich vectors with additional
	// context during storage and retrieval. Unlike default metadata keys, these keys
	// can’t be used as query filters. Non-filterable metadata keys can be retrieved
	// but can’t be searched, queried, or filtered. You can access non-filterable
	// metadata keys of your vectors after finding the vectors. For more information
	// about non-filterable metadata keys, see [Vectors]and [Limitations and restrictions] in the Amazon S3 User Guide.
	//
	// [Limitations and restrictions]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html
	// [Vectors]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html
	//
	// This member is required.
	NonFilterableMetadataKeys []string

	noSmithyDocumentSerde
}

// The attributes of a vector to add to a vector index.
type PutInputVector struct {

	// The vector data of the vector.
	//
	// Vector dimensions must match the dimension count that's configured for the
	// vector index.
	//
	//   - For the cosine distance metric, zero vectors (vectors containing all zeros)
	//   aren't allowed.
	//
	//   - For both cosine and euclidean distance metrics, vector data must contain
	//   only valid floating-point values. Invalid values such as NaN (Not a Number) or
	//   Infinity aren't allowed.
	//
	// This member is required.
	Data VectorData

	// The name of the vector. The key uniquely identifies the vector in a vector
	// index.
	//
	// This member is required.
	Key *string

	// Metadata about the vector. All metadata entries undergo validation to ensure
	// they meet the format requirements for size and data types.
	Metadata document.Interface

	noSmithyDocumentSerde
}

// The attributes of a vector in the approximate nearest neighbor search.
type QueryOutputVector struct {

	// The key of the vector in the approximate nearest neighbor search.
	//
	// This member is required.
	Key *string

	// The measure of similarity between the vector in the response and the query
	// vector.
	Distance *float32

	// The metadata associated with the vector, if requested.
	Metadata document.Interface

	noSmithyDocumentSerde
}

// Contains information about a validation exception.
type ValidationExceptionField struct {

	// A message about the validation exception.
	//
	// This member is required.
	Message *string

	// A path about the validation exception.
	//
	// This member is required.
	Path *string

	noSmithyDocumentSerde
}

// The attributes of a vector bucket.
type VectorBucket struct {

	// Date and time when the vector bucket was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the vector bucket.
	//
	// This member is required.
	VectorBucketArn *string

	// The name of the vector bucket.
	//
	// This member is required.
	VectorBucketName *string

	// The encryption configuration for the vector bucket.
	EncryptionConfiguration *EncryptionConfiguration

	noSmithyDocumentSerde
}

// Summary information about a vector bucket.
type VectorBucketSummary struct {

	// Date and time when the vector bucket was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the vector bucket.
	//
	// This member is required.
	VectorBucketArn *string

	// The name of the vector bucket.
	//
	// This member is required.
	VectorBucketName *string

	noSmithyDocumentSerde
}

// The vector data in different formats.
//
// The following types satisfy this interface:
//
//	VectorDataMemberFloat32
type VectorData interface {
	isVectorData()
}

// The vector data as 32-bit floating point numbers. The number of elements in
// this array must exactly match the dimension of the vector index where the
// operation is being performed.
type VectorDataMemberFloat32 struct {
	Value []float32

	noSmithyDocumentSerde
}

func (*VectorDataMemberFloat32) isVectorData() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isVectorData() {}
