// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a presigned URL that you can use to connect to the MLflow UI attached
// to your MLflow App. For more information, see [Launch the MLflow UI using a presigned URL].
//
// [Launch the MLflow UI using a presigned URL]: https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html
func (c *Client) CreatePresignedMlflowAppUrl(ctx context.Context, params *CreatePresignedMlflowAppUrlInput, optFns ...func(*Options)) (*CreatePresignedMlflowAppUrlOutput, error) {
	if params == nil {
		params = &CreatePresignedMlflowAppUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePresignedMlflowAppUrl", params, optFns, c.addOperationCreatePresignedMlflowAppUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePresignedMlflowAppUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePresignedMlflowAppUrlInput struct {

	// The ARN of the MLflow App to connect to your MLflow UI.
	//
	// This member is required.
	Arn *string

	// The duration in seconds that your presigned URL is valid. The presigned URL can
	// be used only once.
	ExpiresInSeconds *int32

	// The duration in seconds that your presigned URL is valid. The presigned URL can
	// be used only once.
	SessionExpirationDurationInSeconds *int32

	noSmithyDocumentSerde
}

type CreatePresignedMlflowAppUrlOutput struct {

	// A presigned URL with an authorization token.
	AuthorizedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePresignedMlflowAppUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreatePresignedMlflowAppUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreatePresignedMlflowAppUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePresignedMlflowAppUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePresignedMlflowAppUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePresignedMlflowAppUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePresignedMlflowAppUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePresignedMlflowAppUrl",
	}
}
