// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Provides the properties of the specified optimization job.
func (c *Client) DescribeOptimizationJob(ctx context.Context, params *DescribeOptimizationJobInput, optFns ...func(*Options)) (*DescribeOptimizationJobOutput, error) {
	if params == nil {
		params = &DescribeOptimizationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeOptimizationJob", params, optFns, c.addOperationDescribeOptimizationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeOptimizationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeOptimizationJobInput struct {

	// The name that you assigned to the optimization job.
	//
	// This member is required.
	OptimizationJobName *string

	noSmithyDocumentSerde
}

type DescribeOptimizationJobOutput struct {

	// The time when you created the optimization job.
	//
	// This member is required.
	CreationTime *time.Time

	// The type of instance that hosts the optimized model that you create with the
	// optimization job.
	//
	// This member is required.
	DeploymentInstanceType types.OptimizationJobDeploymentInstanceType

	// The time when the optimization job was last updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The location of the source model to optimize with an optimization job.
	//
	// This member is required.
	ModelSource *types.OptimizationJobModelSource

	// Settings for each of the optimization techniques that the job applies.
	//
	// This member is required.
	OptimizationConfigs []types.OptimizationConfig

	// The Amazon Resource Name (ARN) of the optimization job.
	//
	// This member is required.
	OptimizationJobArn *string

	// The name that you assigned to the optimization job.
	//
	// This member is required.
	OptimizationJobName *string

	// The current status of the optimization job.
	//
	// This member is required.
	OptimizationJobStatus types.OptimizationJobStatus

	// Details for where to store the optimized model that you create with the
	// optimization job.
	//
	// This member is required.
	OutputConfig *types.OptimizationJobOutputConfig

	// The ARN of the IAM role that you assigned to the optimization job.
	//
	// This member is required.
	RoleArn *string

	// Specifies a limit to how long a job can run. When the job reaches the time
	// limit, SageMaker ends the job. Use this API to cap costs.
	//
	// To stop a training job, SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	//
	// The training algorithms provided by SageMaker automatically save the
	// intermediate results of a model training job when possible. This attempt to save
	// artifacts is only a best effort case as model might not be in a state from which
	// it can be saved. For example, if training has just started, the model might not
	// be ready to save. When saved, this intermediate data is a valid model artifact.
	// You can use it to create a model with CreateModel .
	//
	// The Neural Topic Model (NTM) currently does not support saving intermediate
	// model artifacts. When training NTMs, make sure that the maximum runtime is
	// sufficient for the training job to complete.
	//
	// This member is required.
	StoppingCondition *types.StoppingCondition

	// If the optimization job status is FAILED , the reason for the failure.
	FailureReason *string

	// The maximum number of instances to use for the optimization job.
	MaxInstanceCount *int32

	// The time when the optimization job finished processing.
	OptimizationEndTime *time.Time

	// The environment variables to set in the model container.
	OptimizationEnvironment map[string]string

	// Output values produced by an optimization job.
	OptimizationOutput *types.OptimizationOutput

	// The time when the optimization job started.
	OptimizationStartTime *time.Time

	// A VPC in Amazon VPC that your optimized model has access to.
	VpcConfig *types.OptimizationVpcConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeOptimizationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeOptimizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeOptimizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeOptimizationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeOptimizationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeOptimizationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeOptimizationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeOptimizationJob",
	}
}
