// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns findings trend data based on the specified criteria. This operation
// helps you analyze patterns and changes in findings over time.
func (c *Client) GetFindingsTrendsV2(ctx context.Context, params *GetFindingsTrendsV2Input, optFns ...func(*Options)) (*GetFindingsTrendsV2Output, error) {
	if params == nil {
		params = &GetFindingsTrendsV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFindingsTrendsV2", params, optFns, c.addOperationGetFindingsTrendsV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFindingsTrendsV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFindingsTrendsV2Input struct {

	// The ending timestamp for the time period to analyze findings trends, in ISO
	// 8601 format.
	//
	// This member is required.
	EndTime *time.Time

	// The starting timestamp for the time period to analyze findings trends, in ISO
	// 8601 format.
	//
	// This member is required.
	StartTime *time.Time

	// The filters to apply to the findings trend data.
	Filters *types.FindingsTrendsFilters

	// The maximum number of trend data points to return in a single response.
	MaxResults *int32

	// The token to use for paginating results. This value is returned in the response
	// if more results are available.
	NextToken *string

	noSmithyDocumentSerde
}

type GetFindingsTrendsV2Output struct {

	// The time interval granularity for the returned trend data.
	//
	// This member is required.
	Granularity types.GranularityField

	// The collection of time-series trend metrics, including counts of findings by
	// severity across the specified time period.
	//
	// This member is required.
	TrendsMetrics []types.TrendsMetricsResult

	// The token to use for retrieving the next page of results, if more trend data is
	// available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFindingsTrendsV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFindingsTrendsV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFindingsTrendsV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFindingsTrendsV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetFindingsTrendsV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFindingsTrendsV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetFindingsTrendsV2PaginatorOptions is the paginator options for
// GetFindingsTrendsV2
type GetFindingsTrendsV2PaginatorOptions struct {
	// The maximum number of trend data points to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetFindingsTrendsV2Paginator is a paginator for GetFindingsTrendsV2
type GetFindingsTrendsV2Paginator struct {
	options   GetFindingsTrendsV2PaginatorOptions
	client    GetFindingsTrendsV2APIClient
	params    *GetFindingsTrendsV2Input
	nextToken *string
	firstPage bool
}

// NewGetFindingsTrendsV2Paginator returns a new GetFindingsTrendsV2Paginator
func NewGetFindingsTrendsV2Paginator(client GetFindingsTrendsV2APIClient, params *GetFindingsTrendsV2Input, optFns ...func(*GetFindingsTrendsV2PaginatorOptions)) *GetFindingsTrendsV2Paginator {
	if params == nil {
		params = &GetFindingsTrendsV2Input{}
	}

	options := GetFindingsTrendsV2PaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetFindingsTrendsV2Paginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetFindingsTrendsV2Paginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetFindingsTrendsV2 page.
func (p *GetFindingsTrendsV2Paginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetFindingsTrendsV2Output, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetFindingsTrendsV2(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetFindingsTrendsV2APIClient is a client that implements the
// GetFindingsTrendsV2 operation.
type GetFindingsTrendsV2APIClient interface {
	GetFindingsTrendsV2(context.Context, *GetFindingsTrendsV2Input, ...func(*Options)) (*GetFindingsTrendsV2Output, error)
}

var _ GetFindingsTrendsV2APIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetFindingsTrendsV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFindingsTrendsV2",
	}
}
