// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

type CaseAttachmentAttributes struct {

	//
	//
	// This member is required.
	AttachmentId *string

	//
	//
	// This member is required.
	AttachmentStatus CaseAttachmentStatus

	//
	//
	// This member is required.
	CreatedDate *time.Time

	//
	//
	// This member is required.
	Creator *string

	//
	//
	// This member is required.
	FileName *string

	noSmithyDocumentSerde
}

type CaseEditItem struct {

	//
	Action *string

	//
	EventTimestamp *time.Time

	//
	Message *string

	//
	Principal *string

	noSmithyDocumentSerde
}

// Represents a single metadata entry associated with a case. Each entry consists
// of a key-value pair that provides additional contextual information about the
// case, such as classification tags, custom attributes, or system-generated
// properties.
type CaseMetadataEntry struct {

	// The identifier for the metadata field. This key uniquely identifies the type of
	// metadata being stored, such as "severity", "category", or "assignee".
	//
	// This member is required.
	Key *string

	// The value associated with the metadata key. This contains the actual data for
	// the metadata field identified by the key.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type GetMembershipAccountDetailError struct {

	//
	//
	// This member is required.
	AccountId *string

	//
	//
	// This member is required.
	Error *string

	//
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

type GetMembershipAccountDetailItem struct {

	//
	AccountId *string

	//
	RelationshipStatus MembershipAccountRelationshipStatus

	//
	RelationshipType MembershipAccountRelationshipType

	noSmithyDocumentSerde
}

type ImpactedAwsRegion struct {

	//
	//
	// This member is required.
	Region AwsRegion

	noSmithyDocumentSerde
}

type IncidentResponder struct {

	//
	//
	// This member is required.
	Email *string

	//
	//
	// This member is required.
	JobTitle *string

	//
	//
	// This member is required.
	Name *string

	//
	CommunicationPreferences []CommunicationType

	noSmithyDocumentSerde
}

// Represents an investigation action performed within a case. This structure
// captures the details of an automated or manual investigation, including its
// status, results, and user feedback.
type InvestigationAction struct {

	// The type of investigation action being performed. This categorizes the
	// investigation method or approach used in the case.
	//
	// This member is required.
	ActionType ActionType

	// Detailed investigation results in rich markdown format. This field contains the
	// comprehensive findings, analysis, and conclusions from the investigation.
	//
	// This member is required.
	Content *string

	// The unique identifier for this investigation action. This ID is used to track
	// and reference the specific investigation throughout its lifecycle.
	//
	// This member is required.
	InvestigationId *string

	// ISO 8601 timestamp of the most recent status update. This indicates when the
	// investigation was last modified or when its status last changed.
	//
	// This member is required.
	LastUpdated *time.Time

	// The current execution status of the investigation. This indicates whether the
	// investigation is pending, in progress, completed, or failed.
	//
	// This member is required.
	Status ExecutionStatus

	// Human-readable summary of the investigation focus. This provides a brief
	// description of what the investigation is examining or analyzing.
	//
	// This member is required.
	Title *string

	// User feedback for this investigation result. This contains the user's
	// assessment and comments about the quality and usefulness of the investigation
	// findings.
	Feedback *InvestigationFeedback

	noSmithyDocumentSerde
}

// Represents user feedback for an investigation result. This structure captures
// the user's evaluation of the investigation's quality, usefulness, and any
// additional comments.
type InvestigationFeedback struct {

	// Optional user comments providing additional context about the investigation
	// feedback. This allows users to explain their rating or provide suggestions for
	// improvement.
	Comment *string

	// ISO 8601 timestamp when the feedback was submitted. This records when the user
	// provided their assessment of the investigation results.
	SubmittedAt *time.Time

	// User assessment of the investigation result's quality and helpfulness. This
	// rating indicates how valuable the investigation findings were in addressing the
	// case.
	Usefulness UsefulnessRating

	noSmithyDocumentSerde
}

type ListCasesItem struct {

	//
	//
	// This member is required.
	CaseId *string

	//
	CaseArn *string

	//
	CaseStatus CaseStatus

	//
	ClosedDate *time.Time

	//
	CreatedDate *time.Time

	//
	EngagementType EngagementType

	//
	LastUpdatedDate *time.Time

	//
	PendingAction PendingAction

	//
	ResolverType ResolverType

	//
	Title *string

	noSmithyDocumentSerde
}

type ListCommentsItem struct {

	//
	//
	// This member is required.
	CommentId *string

	//
	Body *string

	//
	CreatedDate *time.Time

	//
	Creator *string

	//
	LastUpdatedBy *string

	//
	LastUpdatedDate *time.Time

	noSmithyDocumentSerde
}

type ListMembershipItem struct {

	//
	//
	// This member is required.
	MembershipId *string

	//
	AccountId *string

	//
	MembershipArn *string

	//
	MembershipStatus MembershipStatus

	//
	Region AwsRegion

	noSmithyDocumentSerde
}

// The MembershipAccountsConfigurations structure defines the configuration
// settings for managing membership accounts withinAmazon Web Services.
//
// This structure contains settings that determine how member accounts are
// configured and managed within your organization, including:
//
//   - Account configuration preferences
//
//   - Membership validation rules
//
//   - Account access settings
//
// You can use this structure to define and maintain standardized configurations
// across multiple member accounts in your organization.
type MembershipAccountsConfigurations struct {

	// The coverEntireOrganization field is a boolean value that determines whether
	// the membership configuration applies to all accounts within an Amazon Web
	// Services Organization.
	//
	// When set to true , the configuration will be applied across all accounts in the
	// organization. When set to false , the configuration will only apply to
	// specifically designated accounts under the AWS Organizational Units specificied.
	CoverEntireOrganization *bool

	// A list of organizational unit IDs that follow the pattern
	// ou-[0-9a-z]{4,32}-[a-z0-9]{8,32} . These IDs represent the organizational units
	// within an Amazon Web Services Organizations structure that are covered by the
	// membership.
	//
	// Each organizational unit ID in the list must:
	//
	//   - Begin with the prefix 'ou-'
	//
	//   - Contain between 4 and 32 alphanumeric characters in the first segment
	//
	//   - Contain between 8 and 32 alphanumeric characters in the second segment
	OrganizationalUnits []string

	noSmithyDocumentSerde
}

// The MembershipAccountsConfigurationsUpdate structure represents the
// configuration updates for member accounts within an Amazon Web Services
// organization.
//
// This structure is used to modify existing account configurations and settings
// for members in the organization. When applying updates, ensure all required
// fields are properly specified to maintain account consistency.
//
// Key considerations when using this structure:
//
//   - All configuration changes are validated before being applied
//
//   - Updates are processed asynchronously in the background
//
//   - Configuration changes may take several minutes to propagate across all
//     affected accounts
type MembershipAccountsConfigurationsUpdate struct {

	// The coverEntireOrganization field is a boolean value that determines whether
	// the membership configuration should be applied across the entire Amazon Web
	// Services Organization.
	//
	// When set to true , the configuration will be applied to all accounts within the
	// organization. When set to false , the configuration will only apply to
	// specifically designated accounts.
	CoverEntireOrganization *bool

	// A list of organizational unit IDs to add to the membership configuration. Each
	// organizational unit ID must match the pattern ou-[0-9a-z]{4,32}-[a-z0-9]{8,32} .
	//
	// The list must contain between 1 and 5 organizational unit IDs.
	OrganizationalUnitsToAdd []string

	// A list of organizational unit IDs to remove from the membership configuration.
	// Each organizational unit ID must match the pattern
	// ou-[0-9a-z]{4,32}-[a-z0-9]{8,32} .
	//
	// The list must contain between 1 and 5 organizational unit IDs per invocation of
	// the API request.
	OrganizationalUnitsToRemove []string

	noSmithyDocumentSerde
}

type OptInFeature struct {

	//
	//
	// This member is required.
	FeatureName OptInFeatureName

	//
	//
	// This member is required.
	IsEnabled *bool

	noSmithyDocumentSerde
}

type ThreatActorIp struct {

	//
	//
	// This member is required.
	IpAddress *string

	//
	UserAgent *string

	noSmithyDocumentSerde
}

type ValidationExceptionField struct {

	//
	//
	// This member is required.
	Message *string

	//
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type Watcher struct {

	//
	//
	// This member is required.
	Email *string

	//
	JobTitle *string

	//
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
