# v1.39.6 (2025-12-02)

* **Dependency Update**: Updated to the latest SDK module versions
* **Dependency Update**: Upgrade to smithy-go v1.24.0. Notably this version of the library reduces the allocation footprint of the middleware system. We observe a ~10% reduction in allocations per SDK call with this change.

# v1.39.5 (2025-11-25)

* **Bug Fix**: Add error check for endpoint param binding during auth scheme resolution to fix panic reported in #3234

# v1.39.4 (2025-11-19.2)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.39.3 (2025-11-12)

* **Bug Fix**: Further reduce allocation overhead when the metrics system isn't in-use.
* **Bug Fix**: Reduce allocation overhead when the client doesn't have any HTTP interceptors configured.
* **Bug Fix**: Remove blank trace spans towards the beginning of the request that added no additional information. This conveys a slight reduction in overall allocations.

# v1.39.2 (2025-11-11)

* **Bug Fix**: Return validation error if input region is not a valid host label.

# v1.39.1 (2025-11-04)

* **Dependency Update**: Updated to the latest SDK module versions
* **Dependency Update**: Upgrade to smithy-go v1.23.2 which should convey some passive reduction of overall allocations, especially when not using the metrics system.

# v1.39.0 (2025-10-30)

* **Feature**: Update endpoint ruleset parameters casing
* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.8 (2025-10-23)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.7 (2025-10-16)

* **Dependency Update**: Bump minimum Go version to 1.23.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.6 (2025-09-26)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.5 (2025-09-23)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.4 (2025-09-10)

* No change notes available for this release.

# v1.38.3 (2025-09-08)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.2 (2025-08-29)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.1 (2025-08-27)

* **Dependency Update**: Update to smithy-go v1.23.0.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.38.0 (2025-08-25)

* **Feature**: Remove incorrect endpoint tests

# v1.37.2 (2025-08-21)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.37.1 (2025-08-20)

* **Bug Fix**: Remove unused deserialization code.

# v1.37.0 (2025-08-11)

* **Feature**: Add support for configuring per-service Options via callback on global config.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.36.0 (2025-08-04)

* **Feature**: Support configurable auth scheme preferences in service clients via AWS_AUTH_SCHEME_PREFERENCE in the environment, auth_scheme_preference in the config file, and through in-code settings on LoadDefaultConfig and client constructor methods.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.35.1 (2025-07-30)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.35.0 (2025-07-28)

* **Feature**: Add support for HTTP interceptors.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.34.3 (2025-07-19)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.34.2 (2025-06-17)

* **Dependency Update**: Update to smithy-go v1.22.4.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.34.1 (2025-06-10)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.34.0 (2025-05-06)

* **Feature**: ServiceCatalog's APIs (DeleteServiceAction, DisassociateServiceActionFromProvisioningArtifact, AssociateServiceActionWithProvisioningArtifact) now throw InvalidParametersException when IdempotencyToken is invalid.

# v1.33.4 (2025-04-16)

* **Documentation**: Updated default value for the access-level-filter in SearchProvisionedProducts API to Account. For access to userLevel or roleLevel, the user must provide access-level-filter parameter.

# v1.33.3 (2025-04-10)

* No change notes available for this release.

# v1.33.2 (2025-04-03)

* No change notes available for this release.

# v1.33.1 (2025-03-04.2)

* **Bug Fix**: Add assurance test for operation order.

# v1.33.0 (2025-02-27)

* **Feature**: Track credential providers via User-Agent Feature ids
* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.16 (2025-02-18)

* **Bug Fix**: Bump go version to 1.22
* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.15 (2025-02-05)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.14 (2025-01-31)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.13 (2025-01-30)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.12 (2025-01-24)

* **Dependency Update**: Updated to the latest SDK module versions
* **Dependency Update**: Upgrade to smithy-go v1.22.2.

# v1.32.11 (2025-01-17)

* **Bug Fix**: Fix bug where credentials weren't refreshed during retry loop.

# v1.32.10 (2025-01-15)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.9 (2025-01-09)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.8 (2024-12-19)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.7 (2024-12-02)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.6 (2024-11-18)

* **Dependency Update**: Update to smithy-go v1.22.1.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.5 (2024-11-07)

* **Bug Fix**: Adds case-insensitive handling of error message fields in service responses

# v1.32.4 (2024-11-06)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.3 (2024-10-28)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.2 (2024-10-08)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.1 (2024-10-07)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.32.0 (2024-10-04)

* **Feature**: Add support for HTTP client metrics.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.31.4 (2024-10-03)

* No change notes available for this release.

# v1.31.3 (2024-09-27)

* No change notes available for this release.

# v1.31.2 (2024-09-25)

* No change notes available for this release.

# v1.31.1 (2024-09-23)

* No change notes available for this release.

# v1.31.0 (2024-09-20)

* **Feature**: Add tracing and metrics support to service clients.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.30.7 (2024-09-17)

* **Bug Fix**: **BREAKFIX**: Only generate AccountIDEndpointMode config for services that use it. This is a compiler break, but removes no actual functionality, as no services currently use the account ID in endpoint resolution.

# v1.30.6 (2024-09-04)

* No change notes available for this release.

# v1.30.5 (2024-09-03)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.30.4 (2024-08-15)

* **Dependency Update**: Bump minimum Go version to 1.21.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.30.3 (2024-07-10.2)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.30.2 (2024-07-10)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.30.1 (2024-06-28)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.30.0 (2024-06-26)

* **Feature**: Support list-of-string endpoint parameter.

# v1.29.1 (2024-06-19)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.29.0 (2024-06-18)

* **Feature**: Track usage of various AWS SDK features in user-agent string.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.11 (2024-06-17)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.10 (2024-06-07)

* **Bug Fix**: Add clock skew correction on all service clients
* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.9 (2024-06-03)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.8 (2024-05-23)

* No change notes available for this release.

# v1.28.7 (2024-05-16)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.6 (2024-05-15)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.5 (2024-05-08)

* **Bug Fix**: GoDoc improvement

# v1.28.4 (2024-03-29)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.3 (2024-03-18)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.2 (2024-03-07)

* **Bug Fix**: Remove dependency on go-cmp.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.1 (2024-02-23)

* **Bug Fix**: Move all common, SDK-side middleware stack ops into the service client module to prevent cross-module compatibility issues in the future.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.28.0 (2024-02-22)

* **Feature**: Add middleware stack snapshot tests.

# v1.27.3 (2024-02-21)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.27.2 (2024-02-20)

* **Bug Fix**: When sourcing values for a service's `EndpointParameters`, the lack of a configured region (i.e. `options.Region == ""`) will now translate to a `nil` value for `EndpointParameters.Region` instead of a pointer to the empty string `""`. This will result in a much more explicit error when calling an operation instead of an obscure hostname lookup failure.

# v1.27.1 (2024-02-15)

* **Bug Fix**: Correct failure to determine the error type in awsJson services that could occur when errors were modeled with a non-string `code` field.

# v1.27.0 (2024-02-13)

* **Feature**: Bump minimum Go version to 1.20 per our language support policy.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.26.0 (2024-01-04)

* **Feature**: Added Idempotency token support to Service Catalog  AssociateServiceActionWithProvisioningArtifact, DisassociateServiceActionFromProvisioningArtifact, DeleteServiceAction API
* **Dependency Update**: Updated to the latest SDK module versions

# v1.25.5 (2023-12-08)

* **Bug Fix**: Reinstate presence of default Retryer in functional options, but still respect max attempts set therein.

# v1.25.4 (2023-12-07)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.25.3 (2023-12-06)

* **Bug Fix**: Restore pre-refactor auth behavior where all operations could technically be performed anonymously.

# v1.25.2 (2023-12-01)

* **Bug Fix**: Correct wrapping of errors in authentication workflow.
* **Bug Fix**: Correctly recognize cache-wrapped instances of AnonymousCredentials at client construction.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.25.1 (2023-11-30)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.25.0 (2023-11-29)

* **Feature**: Expose Options() accessor on service clients.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.24.5 (2023-11-28.2)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.24.4 (2023-11-28)

* **Bug Fix**: Respect setting RetryMaxAttempts in functional options at client construction.

# v1.24.3 (2023-11-20)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.24.2 (2023-11-15)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.24.1 (2023-11-09)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.24.0 (2023-11-01)

* **Feature**: Adds support for configured endpoints via environment variables and the AWS shared configuration file.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.23.0 (2023-10-31)

* **Feature**: **BREAKING CHANGE**: Bump minimum go version to 1.19 per the revised [go version support policy](https://aws.amazon.com/blogs/developer/aws-sdk-for-go-aligns-with-go-release-policy-on-supported-runtimes/).
* **Dependency Update**: Updated to the latest SDK module versions

# v1.22.0 (2023-10-19)

* **Feature**: Introduce support for EXTERNAL product and provisioning artifact type in CreateProduct and CreateProvisioningArtifact APIs.

# v1.21.5 (2023-10-12)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.21.4 (2023-10-06)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.21.3 (2023-08-21)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.21.2 (2023-08-18)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.21.1 (2023-08-17)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.21.0 (2023-08-08)

* **Feature**: Introduce support for HashiCorp Terraform Cloud in Service Catalog by addying TERRAFORM_CLOUD product type in CreateProduct and CreateProvisioningArtifact API.

# v1.20.2 (2023-08-07)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.20.1 (2023-08-01)

* No change notes available for this release.

# v1.20.0 (2023-07-31)

* **Feature**: Adds support for smithy-modeled endpoint resolution. A new rules-based endpoint resolution will be added to the SDK which will supercede and deprecate existing endpoint resolution. Specifically, EndpointResolver will be deprecated while BaseEndpoint and EndpointResolverV2 will take its place. For more information, please see the Endpoints section in our Developer Guide.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.19.4 (2023-07-28)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.19.3 (2023-07-13)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.19.2 (2023-06-15)

* No change notes available for this release.

# v1.19.1 (2023-06-13)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.19.0 (2023-06-08)

* **Feature**: New parameter added in ServiceCatalog DescribeProvisioningArtifact api - IncludeProvisioningArtifactParameters. This parameter can be used to return information about the parameters used to provision the product

# v1.18.5 (2023-05-31)

* **Documentation**: Documentation updates for ServiceCatalog.

# v1.18.4 (2023-05-04)

* No change notes available for this release.

# v1.18.3 (2023-04-24)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.18.2 (2023-04-10)

* No change notes available for this release.

# v1.18.1 (2023-04-07)

* **Documentation**: Updates description for property
* **Dependency Update**: Updated to the latest SDK module versions

# v1.18.0 (2023-04-05)

* **Feature**: removed incorrect product type value

# v1.17.0 (2023-04-03)

* **Feature**: This release introduces Service Catalog support for Terraform open source. It enables 1. The notify* APIs to Service Catalog. These APIs are used by the terraform engine to notify the result of the provisioning engine execution. 2. Adds a new TERRAFORM_OPEN_SOURCE product type in CreateProduct API.

# v1.16.10 (2023-03-30)

* No change notes available for this release.

# v1.16.9 (2023-03-29)

* No change notes available for this release.

# v1.16.8 (2023-03-23)

* No change notes available for this release.

# v1.16.7 (2023-03-21)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.16.6 (2023-03-10)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.16.5 (2023-02-24)

* **Documentation**: Documentation updates for Service Catalog

# v1.16.4 (2023-02-22)

* **Bug Fix**: Prevent nil pointer dereference when retrieving error codes.

# v1.16.3 (2023-02-20)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.16.2 (2023-02-15)

* **Announcement**: When receiving an error response in restJson-based services, an incorrect error type may have been returned based on the content of the response. This has been fixed via PR #2012 tracked in issue #1910.
* **Bug Fix**: Correct error type parsing for restJson services.

# v1.16.1 (2023-02-03)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.16.0 (2023-01-05)

* **Feature**: Add `ErrorCodeOverride` field to all error structs (aws/smithy-go#401).

# v1.15.2 (2022-12-15)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.15.1 (2022-12-02)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.15.0 (2022-11-18)

* **Feature**: This release 1. adds support for Principal Name Sharing with Service Catalog portfolio sharing. 2. Introduces repo sourced products which are created and managed with existing SC APIs. These products are synced to external repos and auto create new product versions based on changes in the repo.

# v1.14.19 (2022-10-24)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.18 (2022-10-21)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.17 (2022-09-20)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.16 (2022-09-14)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.15 (2022-09-02)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.14 (2022-08-31)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.13 (2022-08-29)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.12 (2022-08-16)

* **Documentation**: Documentation updates for Service Catalog

# v1.14.11 (2022-08-11)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.10 (2022-08-09)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.9 (2022-08-08)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.8 (2022-08-01)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.7 (2022-07-05)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.6 (2022-06-29)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.5 (2022-06-10)

* No change notes available for this release.

# v1.14.4 (2022-06-07)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.3 (2022-05-17)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.2 (2022-05-16)

* **Documentation**: Updated the descriptions for the ListAcceptedPortfolioShares API description and the PortfolioShareType parameters.

# v1.14.1 (2022-04-25)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.14.0 (2022-04-04)

* **Feature**: This release adds ProvisioningArtifictOutputKeys to DescribeProvisioningParameters to reference the outputs of a Provisioned Product and deprecates ProvisioningArtifactOutputs.

# v1.13.3 (2022-03-30)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.13.2 (2022-03-24)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.13.1 (2022-03-23)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.13.0 (2022-03-08)

* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.12.0 (2022-02-24)

* **Feature**: API client updated
* **Feature**: Adds RetryMaxAttempts and RetryMod to API client Options. This allows the API clients' default Retryer to be configured from the shared configuration files or environment variables. Adding a new Retry mode of `Adaptive`. `Adaptive` retry mode is an experimental mode, adding client rate limiting when throttles reponses are received from an API. See [retry.AdaptiveMode](https://pkg.go.dev/github.com/aws/aws-sdk-go-v2/aws/retry#AdaptiveMode) for more details, and configuration options.
* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.11.0 (2022-01-14)

* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.10.0 (2022-01-07)

* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.9.0 (2021-12-21)

* **Feature**: API Paginators now support specifying the initial starting token, and support stopping on empty string tokens.

# v1.8.2 (2021-12-02)

* **Bug Fix**: Fixes a bug that prevented aws.EndpointResolverWithOptions from being used by the service client. ([#1514](https://github.com/aws/aws-sdk-go-v2/pull/1514))
* **Dependency Update**: Updated to the latest SDK module versions

# v1.8.1 (2021-11-19)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.8.0 (2021-11-12)

* **Feature**: Service clients now support custom endpoints that have an initial URI path defined.

# v1.7.0 (2021-11-06)

* **Feature**: The SDK now supports configuration of FIPS and DualStack endpoints using environment variables, shared configuration, or programmatically.
* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.6.0 (2021-10-21)

* **Feature**: Updated  to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.5.2 (2021-10-11)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.5.1 (2021-09-17)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.5.0 (2021-08-27)

* **Feature**: Updated API model to latest revision.
* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.4.3 (2021-08-19)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.4.2 (2021-08-04)

* **Dependency Update**: Updated `github.com/aws/smithy-go` to latest version.
* **Dependency Update**: Updated to the latest SDK module versions

# v1.4.1 (2021-07-15)

* **Dependency Update**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.4.0 (2021-06-25)

* **Feature**: Updated `github.com/aws/smithy-go` to latest version
* **Dependency Update**: Updated to the latest SDK module versions

# v1.3.1 (2021-05-20)

* **Dependency Update**: Updated to the latest SDK module versions

# v1.3.0 (2021-05-14)

* **Feature**: Constant has been added to modules to enable runtime version inspection for reporting.
* **Dependency Update**: Updated to the latest SDK module versions

