// Code generated by smithy-go-codegen DO NOT EDIT.

package servicequotas

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/servicequotas/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about your [Service Quotas Automatic Management] configuration. Automatic Management monitors
// your Service Quotas utilization and notifies you before you run out of your
// allocated quotas.
//
// [Service Quotas Automatic Management]: https://docs.aws.amazon.com/servicequotas/latest/userguide/automatic-management.html
func (c *Client) GetAutoManagementConfiguration(ctx context.Context, params *GetAutoManagementConfigurationInput, optFns ...func(*Options)) (*GetAutoManagementConfigurationOutput, error) {
	if params == nil {
		params = &GetAutoManagementConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutoManagementConfiguration", params, optFns, c.addOperationGetAutoManagementConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutoManagementConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutoManagementConfigurationInput struct {
	noSmithyDocumentSerde
}

type GetAutoManagementConfigurationOutput struct {

	// List of Amazon Web Services services excluded from Automatic Management. You
	// won't be notified of Service Quotas utilization for Amazon Web Services services
	// added to the Automatic Management exclusion list.
	ExclusionList map[string][]types.QuotaInfo

	// The [User Notifications] Amazon Resource Name (ARN) for Automatic Management notifications.
	//
	// [User Notifications]: https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html#rlp-table
	NotificationArn *string

	// Information on the opt-in level for Automatic Management. Only Amazon Web
	// Services account level is supported.
	OptInLevel types.OptInLevel

	// Status on whether Automatic Management is started or stopped.
	OptInStatus types.OptInStatus

	// Information on the opt-in type for Automatic Management. There are two modes:
	// Notify only and Notify and Auto-Adjust. Currently, only NotifyOnly is available.
	OptInType types.OptInType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutoManagementConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetAutoManagementConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetAutoManagementConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutoManagementConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutoManagementConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutoManagementConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutoManagementConfiguration",
	}
}
