// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/socialmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists templates available in Meta's template library for WhatsApp messaging.
func (c *Client) ListWhatsAppTemplateLibrary(ctx context.Context, params *ListWhatsAppTemplateLibraryInput, optFns ...func(*Options)) (*ListWhatsAppTemplateLibraryOutput, error) {
	if params == nil {
		params = &ListWhatsAppTemplateLibraryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWhatsAppTemplateLibrary", params, optFns, c.addOperationListWhatsAppTemplateLibraryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWhatsAppTemplateLibraryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWhatsAppTemplateLibraryInput struct {

	// The ID of the WhatsApp Business Account to list library templates for.
	//
	// This member is required.
	Id *string

	// Map of filters to apply (searchKey, topic, usecase, industry, language).
	Filters map[string]string

	// The maximum number of results to return per page (1-100).
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWhatsAppTemplateLibraryOutput struct {

	// A list of templates from Meta's library.
	MetaLibraryTemplates []types.MetaLibraryTemplateDefinition

	// The token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWhatsAppTemplateLibraryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListWhatsAppTemplateLibrary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListWhatsAppTemplateLibrary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWhatsAppTemplateLibrary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListWhatsAppTemplateLibraryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWhatsAppTemplateLibrary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListWhatsAppTemplateLibraryPaginatorOptions is the paginator options for
// ListWhatsAppTemplateLibrary
type ListWhatsAppTemplateLibraryPaginatorOptions struct {
	// The maximum number of results to return per page (1-100).
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWhatsAppTemplateLibraryPaginator is a paginator for
// ListWhatsAppTemplateLibrary
type ListWhatsAppTemplateLibraryPaginator struct {
	options   ListWhatsAppTemplateLibraryPaginatorOptions
	client    ListWhatsAppTemplateLibraryAPIClient
	params    *ListWhatsAppTemplateLibraryInput
	nextToken *string
	firstPage bool
}

// NewListWhatsAppTemplateLibraryPaginator returns a new
// ListWhatsAppTemplateLibraryPaginator
func NewListWhatsAppTemplateLibraryPaginator(client ListWhatsAppTemplateLibraryAPIClient, params *ListWhatsAppTemplateLibraryInput, optFns ...func(*ListWhatsAppTemplateLibraryPaginatorOptions)) *ListWhatsAppTemplateLibraryPaginator {
	if params == nil {
		params = &ListWhatsAppTemplateLibraryInput{}
	}

	options := ListWhatsAppTemplateLibraryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWhatsAppTemplateLibraryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWhatsAppTemplateLibraryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWhatsAppTemplateLibrary page.
func (p *ListWhatsAppTemplateLibraryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWhatsAppTemplateLibraryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWhatsAppTemplateLibrary(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWhatsAppTemplateLibraryAPIClient is a client that implements the
// ListWhatsAppTemplateLibrary operation.
type ListWhatsAppTemplateLibraryAPIClient interface {
	ListWhatsAppTemplateLibrary(context.Context, *ListWhatsAppTemplateLibraryInput, ...func(*Options)) (*ListWhatsAppTemplateLibraryOutput, error)
}

var _ ListWhatsAppTemplateLibraryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWhatsAppTemplateLibrary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWhatsAppTemplateLibrary",
	}
}
