// Code generated by smithy-go-codegen DO NOT EDIT.

package ssoadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssoadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the applications to which a specified principal is assigned. You must
// provide a filter when calling this action from a member account against your
// organization instance of IAM Identity Center. A filter is not required when
// called from the management account against an organization instance of IAM
// Identity Center, or from a member account against an account instance of IAM
// Identity Center in the same account.
func (c *Client) ListApplicationAssignmentsForPrincipal(ctx context.Context, params *ListApplicationAssignmentsForPrincipalInput, optFns ...func(*Options)) (*ListApplicationAssignmentsForPrincipalOutput, error) {
	if params == nil {
		params = &ListApplicationAssignmentsForPrincipalInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApplicationAssignmentsForPrincipal", params, optFns, c.addOperationListApplicationAssignmentsForPrincipalMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApplicationAssignmentsForPrincipalOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListApplicationAssignmentsForPrincipalInput struct {

	// Specifies the instance of IAM Identity Center that contains principal and
	// applications.
	//
	// This member is required.
	InstanceArn *string

	// Specifies the unique identifier of the principal for which you want to retrieve
	// its assignments.
	//
	// This member is required.
	PrincipalId *string

	// Specifies the type of the principal for which you want to retrieve its
	// assignments.
	//
	// This member is required.
	PrincipalType types.PrincipalType

	// Filters the output to include only assignments associated with the application
	// that has the specified ARN.
	Filter *types.ListApplicationAssignmentsFilter

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value as the
	// NextToken request parameter in the next call to the operation to get the next
	// set of results. Note that the service might return fewer results than the
	// maximum even when there are more results available. You should check NextToken
	// after every operation to ensure that you receive all of the results.
	MaxResults *int32

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a NextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's NextToken response to request the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListApplicationAssignmentsForPrincipalOutput struct {

	// An array list of the application assignments for the specified principal.
	ApplicationAssignments []types.ApplicationAssignmentForPrincipal

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null . This
	// indicates that this is the last page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApplicationAssignmentsForPrincipalMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListApplicationAssignmentsForPrincipal{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListApplicationAssignmentsForPrincipal{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApplicationAssignmentsForPrincipal"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListApplicationAssignmentsForPrincipalValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApplicationAssignmentsForPrincipal(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListApplicationAssignmentsForPrincipalPaginatorOptions is the paginator options
// for ListApplicationAssignmentsForPrincipal
type ListApplicationAssignmentsForPrincipalPaginatorOptions struct {
	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value as the
	// NextToken request parameter in the next call to the operation to get the next
	// set of results. Note that the service might return fewer results than the
	// maximum even when there are more results available. You should check NextToken
	// after every operation to ensure that you receive all of the results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApplicationAssignmentsForPrincipalPaginator is a paginator for
// ListApplicationAssignmentsForPrincipal
type ListApplicationAssignmentsForPrincipalPaginator struct {
	options   ListApplicationAssignmentsForPrincipalPaginatorOptions
	client    ListApplicationAssignmentsForPrincipalAPIClient
	params    *ListApplicationAssignmentsForPrincipalInput
	nextToken *string
	firstPage bool
}

// NewListApplicationAssignmentsForPrincipalPaginator returns a new
// ListApplicationAssignmentsForPrincipalPaginator
func NewListApplicationAssignmentsForPrincipalPaginator(client ListApplicationAssignmentsForPrincipalAPIClient, params *ListApplicationAssignmentsForPrincipalInput, optFns ...func(*ListApplicationAssignmentsForPrincipalPaginatorOptions)) *ListApplicationAssignmentsForPrincipalPaginator {
	if params == nil {
		params = &ListApplicationAssignmentsForPrincipalInput{}
	}

	options := ListApplicationAssignmentsForPrincipalPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApplicationAssignmentsForPrincipalPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApplicationAssignmentsForPrincipalPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApplicationAssignmentsForPrincipal page.
func (p *ListApplicationAssignmentsForPrincipalPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApplicationAssignmentsForPrincipalOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListApplicationAssignmentsForPrincipal(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListApplicationAssignmentsForPrincipalAPIClient is a client that implements the
// ListApplicationAssignmentsForPrincipal operation.
type ListApplicationAssignmentsForPrincipalAPIClient interface {
	ListApplicationAssignmentsForPrincipal(context.Context, *ListApplicationAssignmentsForPrincipalInput, ...func(*Options)) (*ListApplicationAssignmentsForPrincipalOutput, error)
}

var _ ListApplicationAssignmentsForPrincipalAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListApplicationAssignmentsForPrincipal(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApplicationAssignmentsForPrincipal",
	}
}
