// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about an action for a request for which an authorization
// decision is made.
//
// This data type is used as a request parameter to the [IsAuthorized], [BatchIsAuthorized], and [IsAuthorizedWithToken] operations.
//
// Example: { "actionId": "<action name>", "actionType": "Action" }
//
// [BatchIsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
type ActionIdentifier struct {

	// The ID of an action.
	//
	// This member is required.
	ActionId *string

	// The type of an action.
	//
	// This member is required.
	ActionType *string

	noSmithyDocumentSerde
}

// The value of an attribute.
//
// Contains information about the runtime context for a request for which an
// authorization decision is made.
//
// This data type is used as a member of the [ContextDefinition] structure which is used as a request
// parameter for the [IsAuthorized], [BatchIsAuthorized], and [IsAuthorizedWithToken] operations.
//
// The following types satisfy this interface:
//
//	AttributeValueMemberBoolean
//	AttributeValueMemberDatetime
//	AttributeValueMemberDecimal
//	AttributeValueMemberDuration
//	AttributeValueMemberEntityIdentifier
//	AttributeValueMemberIpaddr
//	AttributeValueMemberLong
//	AttributeValueMemberRecord
//	AttributeValueMemberSet
//	AttributeValueMemberString
//
// [BatchIsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
// [ContextDefinition]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ContextDefinition.html
type AttributeValue interface {
	isAttributeValue()
}

// An attribute value of [Boolean] type.
//
// Example: {"boolean": true}
//
// [Boolean]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-bool
type AttributeValueMemberBoolean struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AttributeValueMemberBoolean) isAttributeValue() {}

// An attribute value of [datetime] type.
//
// Example: {"datetime": "2024-10-15T11:35:00Z"}
//
// [datetime]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-datetime
type AttributeValueMemberDatetime struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberDatetime) isAttributeValue() {}

// An attribute value of [decimal] type.
//
// Example: {"decimal": "1.1"}
//
// [decimal]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal
type AttributeValueMemberDecimal struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberDecimal) isAttributeValue() {}

// An attribute value of [duration] type.
//
// Example: {"duration": "1h30m"}
//
// [duration]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-duration
type AttributeValueMemberDuration struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberDuration) isAttributeValue() {}

// An attribute value of type [EntityIdentifier].
//
// Example: {"entityIdentifier": { "entityId": "alice", "entityType": "User"} }
//
// [EntityIdentifier]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html
type AttributeValueMemberEntityIdentifier struct {
	Value EntityIdentifier

	noSmithyDocumentSerde
}

func (*AttributeValueMemberEntityIdentifier) isAttributeValue() {}

// An attribute value of [ipaddr] type.
//
// Example: {"ip": "192.168.1.100"}
//
// [ipaddr]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr
type AttributeValueMemberIpaddr struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberIpaddr) isAttributeValue() {}

// An attribute value of [Long] type.
//
// Example: {"long": 0}
//
// [Long]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-long
type AttributeValueMemberLong struct {
	Value int64

	noSmithyDocumentSerde
}

func (*AttributeValueMemberLong) isAttributeValue() {}

// An attribute value of [Record] type.
//
// Example: {"record": { "keyName": {} } }
//
// [Record]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-record
type AttributeValueMemberRecord struct {
	Value map[string]AttributeValue

	noSmithyDocumentSerde
}

func (*AttributeValueMemberRecord) isAttributeValue() {}

// An attribute value of [Set] type.
//
// Example: {"set": [ {} ] }
//
// [Set]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-set
type AttributeValueMemberSet struct {
	Value []AttributeValue

	noSmithyDocumentSerde
}

func (*AttributeValueMemberSet) isAttributeValue() {}

// An attribute value of [String] type.
//
// Example: {"string": "abc"}
//
// [String]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-string
type AttributeValueMemberString struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberString) isAttributeValue() {}

// Contains the information about an error resulting from a BatchGetPolicy API
// call.
type BatchGetPolicyErrorItem struct {

	// The error code that was returned.
	//
	// This member is required.
	Code BatchGetPolicyErrorCode

	// A detailed error message.
	//
	// This member is required.
	Message *string

	// The identifier of the policy associated with the failed request.
	//
	// This member is required.
	PolicyId *string

	// The identifier of the policy store associated with the failed request.
	//
	// This member is required.
	PolicyStoreId *string

	noSmithyDocumentSerde
}

// Information about a policy that you include in a BatchGetPolicy API request.
type BatchGetPolicyInputItem struct {

	// The identifier of the policy you want information about.
	//
	// This member is required.
	PolicyId *string

	// The identifier of the policy store where the policy you want information about
	// is stored.
	//
	// This member is required.
	PolicyStoreId *string

	noSmithyDocumentSerde
}

// Contains information about a policy returned from a BatchGetPolicy API request.
type BatchGetPolicyOutputItem struct {

	// The date and time the policy was created.
	//
	// This member is required.
	CreatedDate *time.Time

	// The policy definition of an item in the list of policies returned.
	//
	// This member is required.
	Definition PolicyDefinitionDetail

	// The date and time the policy was most recently updated.
	//
	// This member is required.
	LastUpdatedDate *time.Time

	// The identifier of the policy you want information about.
	//
	// This member is required.
	PolicyId *string

	// The identifier of the policy store where the policy you want information about
	// is stored.
	//
	// This member is required.
	PolicyStoreId *string

	// The type of the policy. This is one of the following values:
	//
	//   - STATIC
	//
	//   - TEMPLATE_LINKED
	//
	// This member is required.
	PolicyType PolicyType

	noSmithyDocumentSerde
}

// An authorization request that you include in a BatchIsAuthorized API request.
type BatchIsAuthorizedInputItem struct {

	// Specifies the requested action to be authorized. For example,
	// PhotoFlash::ReadPhoto .
	Action *ActionIdentifier

	// Specifies additional context that can be used to make more granular
	// authorization decisions.
	Context ContextDefinition

	// Specifies the principal for which the authorization decision is to be made.
	Principal *EntityIdentifier

	// Specifies the resource that you want an authorization decision for. For
	// example, PhotoFlash::Photo .
	Resource *EntityIdentifier

	noSmithyDocumentSerde
}

// The decision, based on policy evaluation, from an individual authorization
// request in a BatchIsAuthorized API request.
type BatchIsAuthorizedOutputItem struct {

	// An authorization decision that indicates if the authorization request should be
	// allowed or denied.
	//
	// This member is required.
	Decision Decision

	// The list of determining policies used to make the authorization decision. For
	// example, if there are two matching policies, where one is a forbid and the other
	// is a permit, then the forbid policy will be the determining policy. In the case
	// of multiple matching permit policies then there would be multiple determining
	// policies. In the case that no policies match, and hence the response is DENY,
	// there would be no determining policies.
	//
	// This member is required.
	DeterminingPolicies []DeterminingPolicyItem

	// Errors that occurred while making an authorization decision. For example, a
	// policy might reference an entity or attribute that doesn't exist in the request.
	//
	// This member is required.
	Errors []EvaluationErrorItem

	// The authorization request that initiated the decision.
	//
	// This member is required.
	Request *BatchIsAuthorizedInputItem

	noSmithyDocumentSerde
}

// An authorization request that you include in a BatchIsAuthorizedWithToken API
// request.
type BatchIsAuthorizedWithTokenInputItem struct {

	// Specifies the requested action to be authorized. For example,
	// PhotoFlash::ReadPhoto .
	Action *ActionIdentifier

	// Specifies additional context that can be used to make more granular
	// authorization decisions.
	Context ContextDefinition

	// Specifies the resource that you want an authorization decision for. For
	// example, PhotoFlash::Photo .
	Resource *EntityIdentifier

	noSmithyDocumentSerde
}

// The decision, based on policy evaluation, from an individual authorization
// request in a BatchIsAuthorizedWithToken API request.
type BatchIsAuthorizedWithTokenOutputItem struct {

	// An authorization decision that indicates if the authorization request should be
	// allowed or denied.
	//
	// This member is required.
	Decision Decision

	// The list of determining policies used to make the authorization decision. For
	// example, if there are two matching policies, where one is a forbid and the other
	// is a permit, then the forbid policy will be the determining policy. In the case
	// of multiple matching permit policies then there would be multiple determining
	// policies. In the case that no policies match, and hence the response is DENY,
	// there would be no determining policies.
	//
	// This member is required.
	DeterminingPolicies []DeterminingPolicyItem

	// Errors that occurred while making an authorization decision. For example, a
	// policy might reference an entity or attribute that doesn't exist in the request.
	//
	// This member is required.
	Errors []EvaluationErrorItem

	// The authorization request that initiated the decision.
	//
	// This member is required.
	Request *BatchIsAuthorizedWithTokenInputItem

	noSmithyDocumentSerde
}

// The value of an entity's Cedar tag.
//
// This data type is used as a member of the [EntityItem] structure that forms the body of the
// Entities request parameter for the [IsAuthorized], [BatchIsAuthorized], [IsAuthorizedWithToken], and [BatchIsAuthorizedWithToken] operations.
//
// The following types satisfy this interface:
//
//	CedarTagValueMemberBoolean
//	CedarTagValueMemberDatetime
//	CedarTagValueMemberDecimal
//	CedarTagValueMemberDuration
//	CedarTagValueMemberEntityIdentifier
//	CedarTagValueMemberIpaddr
//	CedarTagValueMemberLong
//	CedarTagValueMemberRecord
//	CedarTagValueMemberSet
//	CedarTagValueMemberString
//
// [BatchIsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
// [EntityItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityItem.html
// [BatchIsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorizedWithToken.html
type CedarTagValue interface {
	isCedarTagValue()
}

// A Cedar tag value of [Boolean] type.
//
// Example: {"boolean": false}
//
// [Boolean]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-bool
type CedarTagValueMemberBoolean struct {
	Value bool

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberBoolean) isCedarTagValue() {}

// A Cedar tag value of [datetime] type.
//
// Example: {"datetime": "2025-11-04T11:35:00.000+0100"}
//
// [datetime]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-datetime
type CedarTagValueMemberDatetime struct {
	Value string

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberDatetime) isCedarTagValue() {}

// A Cedar tag value of [decimal] type.
//
// Example: {"decimal": "-2.0"}
//
// [decimal]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-decimal
type CedarTagValueMemberDecimal struct {
	Value string

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberDecimal) isCedarTagValue() {}

// A Cedar tag value of [duration] type.
//
// Example: {"duration": "-1d12h"}
//
// [duration]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-duration
type CedarTagValueMemberDuration struct {
	Value string

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberDuration) isCedarTagValue() {}

// A Cedar tag value of type [EntityIdentifier].
//
// Example: {"entityIdentifier": { "entityId": "alice", "entityType": "User"} }
//
// [EntityIdentifier]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html
type CedarTagValueMemberEntityIdentifier struct {
	Value EntityIdentifier

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberEntityIdentifier) isCedarTagValue() {}

// A Cedar tag value of [ipaddr] type.
//
// Example: {"ip": "10.50.0.0/24"}
//
// [ipaddr]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-ipaddr
type CedarTagValueMemberIpaddr struct {
	Value string

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberIpaddr) isCedarTagValue() {}

// A Cedar tag value of [Long] type.
//
// Example: {"long": 0}
//
// [Long]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-long
type CedarTagValueMemberLong struct {
	Value int64

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberLong) isCedarTagValue() {}

// A Cedar tag value of [Record] type.
//
// Example: {"record": { "keyName": {} } }
//
// [Record]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-record
type CedarTagValueMemberRecord struct {
	Value map[string]CedarTagValue

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberRecord) isCedarTagValue() {}

// A Cedar tag value of [Set] type.
//
// Example: {"set": [ { "string": "abc" } ] }
//
// [Set]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-set
type CedarTagValueMemberSet struct {
	Value []CedarTagValue

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberSet) isCedarTagValue() {}

// A Cedar tag value of [String] type.
//
// Example: {"string": "abc"}
//
// [String]: https://docs.cedarpolicy.com/policies/syntax-datatypes.html#datatype-string
type CedarTagValueMemberString struct {
	Value string

	noSmithyDocumentSerde
}

func (*CedarTagValueMemberString) isCedarTagValue() {}

// The type of entity that a policy store maps to groups from an Amazon Cognito
// user pool identity source.
//
// This data type is part of a [CognitoUserPoolConfiguration] structure and is a request parameter in [CreateIdentitySource].
//
// [CognitoUserPoolConfiguration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfiguration.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type CognitoGroupConfiguration struct {

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup .
	//
	// This member is required.
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The type of entity that a policy store maps to groups from an Amazon Cognito
// user pool identity source.
//
// This data type is part of an [CognitoUserPoolConfigurationDetail] structure and is a response parameter to [GetIdentitySource].
//
// [CognitoUserPoolConfigurationDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfigurationItem.html
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
type CognitoGroupConfigurationDetail struct {

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup .
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The type of entity that a policy store maps to groups from an Amazon Cognito
// user pool identity source.
//
// This data type is part of an [CognitoUserPoolConfigurationItem] structure and is a response parameter to [ListIdentitySources].
//
// [CognitoUserPoolConfigurationItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfigurationDetail.html
// [ListIdentitySources]: http://forums.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type CognitoGroupConfigurationItem struct {

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup .
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The configuration for an identity source that represents a connection to an
// Amazon Cognito user pool used as an identity provider for Verified Permissions.
//
// This data type part of a [Configuration] structure that is used as a parameter to [CreateIdentitySource].
//
// Example:
// "CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}
//
// [Configuration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type CognitoUserPoolConfiguration struct {

	// The [Amazon Resource Name (ARN)] of the Amazon Cognito user pool that contains the identities to be
	// authorized.
	//
	// Example: "UserPoolArn":
	// "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	UserPoolArn *string

	// The unique application client IDs that are associated with the specified Amazon
	// Cognito user pool.
	//
	// Example: "ClientIds": ["&ExampleCogClientId;"]
	ClientIds []string

	// The type of entity that a policy store maps to groups from an Amazon Cognito
	// user pool identity source.
	GroupConfiguration *CognitoGroupConfiguration

	noSmithyDocumentSerde
}

// The configuration for an identity source that represents a connection to an
// Amazon Cognito user pool used as an identity provider for Verified Permissions.
//
// This data type is used as a field that is part of an [ConfigurationDetail] structure that is part of
// the response to [GetIdentitySource].
//
// Example:
// "CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}
//
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
// [ConfigurationDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html
type CognitoUserPoolConfigurationDetail struct {

	// The unique application client IDs that are associated with the specified Amazon
	// Cognito user pool.
	//
	// Example: "clientIds": ["&ExampleCogClientId;"]
	//
	// This member is required.
	ClientIds []string

	// The OpenID Connect (OIDC) issuer ID of the Amazon Cognito user pool that
	// contains the identities to be authorized.
	//
	// Example: "issuer":
	// "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"
	//
	// This member is required.
	Issuer *string

	// The [Amazon Resource Name (ARN)] of the Amazon Cognito user pool that contains the identities to be
	// authorized.
	//
	// Example: "userPoolArn":
	// "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	UserPoolArn *string

	// The type of entity that a policy store maps to groups from an Amazon Cognito
	// user pool identity source.
	GroupConfiguration *CognitoGroupConfigurationDetail

	noSmithyDocumentSerde
}

// The configuration for an identity source that represents a connection to an
// Amazon Cognito user pool used as an identity provider for Verified Permissions.
//
// This data type is used as a field that is part of the [ConfigurationItem] structure that is part
// of the response to [ListIdentitySources].
//
// Example:
// "CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}
//
// [ConfigurationItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type CognitoUserPoolConfigurationItem struct {

	// The unique application client IDs that are associated with the specified Amazon
	// Cognito user pool.
	//
	// Example: "clientIds": ["&ExampleCogClientId;"]
	//
	// This member is required.
	ClientIds []string

	// The OpenID Connect (OIDC) issuer ID of the Amazon Cognito user pool that
	// contains the identities to be authorized.
	//
	// Example: "issuer":
	// "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"
	//
	// This member is required.
	Issuer *string

	// The [Amazon Resource Name (ARN)] of the Amazon Cognito user pool that contains the identities to be
	// authorized.
	//
	// Example: "userPoolArn":
	// "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	UserPoolArn *string

	// The type of entity that a policy store maps to groups from an Amazon Cognito
	// user pool identity source.
	GroupConfiguration *CognitoGroupConfigurationItem

	noSmithyDocumentSerde
}

// Contains configuration information used when creating a new identity source.
//
// This data type is used as a request parameter for the [CreateIdentitySource] operation.
//
// The following types satisfy this interface:
//
//	ConfigurationMemberCognitoUserPoolConfiguration
//	ConfigurationMemberOpenIdConnectConfiguration
//
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type Configuration interface {
	isConfiguration()
}

// Contains configuration details of a Amazon Cognito user pool that Verified
// Permissions can use as a source of authenticated identities as entities. It
// specifies the [Amazon Resource Name (ARN)]of a Amazon Cognito user pool and one or more application client
// IDs.
//
// Example:
// "configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}}
//
// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
type ConfigurationMemberCognitoUserPoolConfiguration struct {
	Value CognitoUserPoolConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberCognitoUserPoolConfiguration) isConfiguration() {}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// Example:
// "configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}
type ConfigurationMemberOpenIdConnectConfiguration struct {
	Value OpenIdConnectConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberOpenIdConnectConfiguration) isConfiguration() {}

// Contains configuration information about an identity source.
//
// This data type is a response parameter to the [GetIdentitySource] operation.
//
// The following types satisfy this interface:
//
//	ConfigurationDetailMemberCognitoUserPoolConfiguration
//	ConfigurationDetailMemberOpenIdConnectConfiguration
//
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
type ConfigurationDetail interface {
	isConfigurationDetail()
}

// Contains configuration details of a Amazon Cognito user pool that Verified
// Permissions can use as a source of authenticated identities as entities. It
// specifies the [Amazon Resource Name (ARN)]of a Amazon Cognito user pool, the policy store entity that you
// want to assign to user groups, and one or more application client IDs.
//
// Example:
// "configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}}
//
// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
type ConfigurationDetailMemberCognitoUserPoolConfiguration struct {
	Value CognitoUserPoolConfigurationDetail

	noSmithyDocumentSerde
}

func (*ConfigurationDetailMemberCognitoUserPoolConfiguration) isConfigurationDetail() {}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// Example:
// "configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}
type ConfigurationDetailMemberOpenIdConnectConfiguration struct {
	Value OpenIdConnectConfigurationDetail

	noSmithyDocumentSerde
}

func (*ConfigurationDetailMemberOpenIdConnectConfiguration) isConfigurationDetail() {}

// Contains configuration information about an identity source.
//
// This data type is a response parameter to the [ListIdentitySources] operation.
//
// The following types satisfy this interface:
//
//	ConfigurationItemMemberCognitoUserPoolConfiguration
//	ConfigurationItemMemberOpenIdConnectConfiguration
//
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type ConfigurationItem interface {
	isConfigurationItem()
}

// Contains configuration details of a Amazon Cognito user pool that Verified
// Permissions can use as a source of authenticated identities as entities. It
// specifies the [Amazon Resource Name (ARN)]of a Amazon Cognito user pool, the policy store entity that you
// want to assign to user groups, and one or more application client IDs.
//
// Example:
// "configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds":
// ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType":
// "MyCorp::Group"}}}
//
// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
type ConfigurationItemMemberCognitoUserPoolConfiguration struct {
	Value CognitoUserPoolConfigurationItem

	noSmithyDocumentSerde
}

func (*ConfigurationItemMemberCognitoUserPoolConfiguration) isConfigurationItem() {}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// Example:
// "configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}
type ConfigurationItemMemberOpenIdConnectConfiguration struct {
	Value OpenIdConnectConfigurationItem

	noSmithyDocumentSerde
}

func (*ConfigurationItemMemberOpenIdConnectConfiguration) isConfigurationItem() {}

// Contains additional details about the context of the request. Verified
// Permissions evaluates this information in an authorization request as part of
// the when and unless clauses in a policy.
//
// This data type is used as a request parameter for the [IsAuthorized], [BatchIsAuthorized], and [IsAuthorizedWithToken] operations.
//
// If you're passing context as part of the request, exactly one instance of
// context must be passed. If you don't want to pass context, omit the context
// parameter from your request rather than sending context {} .
//
// Example:
// "context":{"contextMap":{"<KeyName1>":{"boolean":true},"<KeyName2>":{"long":1234}}}
//
// The following types satisfy this interface:
//
//	ContextDefinitionMemberCedarJson
//	ContextDefinitionMemberContextMap
//
// [BatchIsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
type ContextDefinition interface {
	isContextDefinition()
}

// A Cedar JSON string representation of the context needed to successfully
// evaluate an authorization request.
//
// Example: {"cedarJson":"{\"<KeyName1>\": true, \"<KeyName2>\": 1234}" }
type ContextDefinitionMemberCedarJson struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContextDefinitionMemberCedarJson) isContextDefinition() {}

// An list of attributes that are needed to successfully evaluate an authorization
// request. Each attribute in this array must include a map of a data type and its
// value.
//
// Example: "contextMap":{"<KeyName1>":{"boolean":true},"<KeyName2>":{"long":1234}}
type ContextDefinitionMemberContextMap struct {
	Value map[string]AttributeValue

	noSmithyDocumentSerde
}

func (*ContextDefinitionMemberContextMap) isContextDefinition() {}

// Contains information about one of the policies that determined an authorization
// decision.
//
// This data type is used as an element in a response parameter for the [IsAuthorized], [BatchIsAuthorized], and [IsAuthorizedWithToken]
// operations.
//
// Example: "determiningPolicies":[{"policyId":"SPEXAMPLEabcdefg111111"}]
//
// [BatchIsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
type DeterminingPolicyItem struct {

	// The Id of a policy that determined to an authorization decision.
	//
	// Example: "policyId":"SPEXAMPLEabcdefg111111"
	//
	// This member is required.
	PolicyId *string

	noSmithyDocumentSerde
}

// Contains the list of entities to be considered during an authorization request.
// This includes all principals, resources, and actions required to successfully
// evaluate the request.
//
// This data type is used as a field in the response parameter for the [IsAuthorized] and [IsAuthorizedWithToken]
// operations.
//
// The following types satisfy this interface:
//
//	EntitiesDefinitionMemberCedarJson
//	EntitiesDefinitionMemberEntityList
//
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
type EntitiesDefinition interface {
	isEntitiesDefinition()
}

// A Cedar JSON string representation of the entities needed to successfully
// evaluate an authorization request.
//
// Example: {"cedarJson":
// "[{\"uid\":{\"type\":\"Photo\",\"id\":\"VacationPhoto94.jpg\"},\"attrs\":{\"accessLevel\":\"public\"},\"parents\":[]}]"}
type EntitiesDefinitionMemberCedarJson struct {
	Value string

	noSmithyDocumentSerde
}

func (*EntitiesDefinitionMemberCedarJson) isEntitiesDefinition() {}

// An array of entities that are needed to successfully evaluate an authorization
// request. Each entity in this array must include an identifier for the entity,
// the attributes of the entity, and a list of any parent entities.
//
// If you include multiple entities with the same identifier , only the last one is
// processed in the request.
type EntitiesDefinitionMemberEntityList struct {
	Value []EntityItem

	noSmithyDocumentSerde
}

func (*EntitiesDefinitionMemberEntityList) isEntitiesDefinition() {}

// Contains the identifier of an entity, including its ID and type.
//
// This data type is used as a request parameter for [IsAuthorized] operation, and as a response
// parameter for the [CreatePolicy], [GetPolicy], and [UpdatePolicy] operations.
//
// Example: {"entityId":"string","entityType":"string"}
//
// [CreatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
// [UpdatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
// [GetPolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html
type EntityIdentifier struct {

	// The identifier of an entity.
	//
	//     "entityId":"identifier"
	//
	// This member is required.
	EntityId *string

	// The type of an entity.
	//
	// Example: "entityType":"typeName"
	//
	// This member is required.
	EntityType *string

	noSmithyDocumentSerde
}

// Contains information about an entity that can be referenced in a Cedar policy.
//
// This data type is used as one of the fields in the [EntitiesDefinition] structure.
//
//	{ "identifier": { "entityType": "Photo", "entityId": "VacationPhoto94.jpg" },
//	"attributes": {}, "parents": [ { "entityType": "Album", "entityId":
//	"alice_folder" } ] }
//
// [EntitiesDefinition]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntitiesDefinition.html
type EntityItem struct {

	// The identifier of the entity.
	//
	// This member is required.
	Identifier *EntityIdentifier

	// A list of attributes for the entity.
	Attributes map[string]AttributeValue

	// The parent entities in the hierarchy that contains the entity. A principal or
	// resource entity can be defined with at most 99 transitive parents per
	// authorization request.
	//
	// A transitive parent is an entity in the hierarchy of entities including all
	// direct parents, and parents of parents. For example, a user can be a member of
	// 91 groups if one of those groups is a member of eight groups, for a total of
	// 100: one entity, 91 entity parents, and eight parents of parents.
	Parents []EntityIdentifier

	// A list of cedar tags for the entity.
	Tags map[string]CedarTagValue

	noSmithyDocumentSerde
}

// Contains information about a principal or resource that can be referenced in a
// Cedar policy.
//
// This data type is used as part of the [PolicyFilter] structure that is used as a request
// parameter for the [ListPolicies]operation..
//
// The following types satisfy this interface:
//
//	EntityReferenceMemberIdentifier
//	EntityReferenceMemberUnspecified
//
// [ListPolicies]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html
// [PolicyFilter]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyFilter.html
type EntityReference interface {
	isEntityReference()
}

// The identifier of the entity. It can consist of either an EntityType and
// EntityId, a principal, or a resource.
type EntityReferenceMemberIdentifier struct {
	Value EntityIdentifier

	noSmithyDocumentSerde
}

func (*EntityReferenceMemberIdentifier) isEntityReference() {}

// Used to indicate that a principal or resource is not specified. This can be
// used to search for policies that are not associated with a specific principal or
// resource.
type EntityReferenceMemberUnspecified struct {
	Value bool

	noSmithyDocumentSerde
}

func (*EntityReferenceMemberUnspecified) isEntityReference() {}

// Contains a description of an evaluation error.
//
// This data type is a response parameter of the [IsAuthorized], [BatchIsAuthorized], and [IsAuthorizedWithToken] operations.
//
// [BatchIsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html
// [IsAuthorizedWithToken]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html
// [IsAuthorized]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html
type EvaluationErrorItem struct {

	// The error description.
	//
	// This member is required.
	ErrorDescription *string

	noSmithyDocumentSerde
}

// A structure that contains configuration of the identity source.
//
// This data type was a response parameter for the [GetIdentitySource] operation. Replaced by [ConfigurationDetail].
//
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
// [ConfigurationDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html
type IdentitySourceDetails struct {

	// The application client IDs associated with the specified Amazon Cognito user
	// pool that are enabled for this identity source.
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration.clientIds
	ClientIds []string

	// The well-known URL that points to this user pool's OIDC discovery endpoint.
	// This is a URL string in the following format. This URL replaces the placeholders
	// for both the Amazon Web Services Region and the user pool identifier with those
	// appropriate for this user pool.
	//
	//     https://cognito-idp.<region>.amazonaws.com/<user-pool-id>/.well-known/openid-configuration
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration.issuer
	DiscoveryUrl *string

	// A string that identifies the type of OIDC service represented by this identity
	// source.
	//
	// At this time, the only valid value is cognito .
	//
	// Deprecated: This attribute has been replaced by configuration
	OpenIdIssuer OpenIdIssuer

	// The [Amazon Resource Name (ARN)] of the Amazon Cognito user pool whose identities are accessible to this
	// Verified Permissions policy store.
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration.userPoolArn
	UserPoolArn *string

	noSmithyDocumentSerde
}

// A structure that defines characteristics of an identity source that you can use
// to filter.
//
// This data type is a request parameter for the [ListIdentityStores] operation.
//
// [ListIdentityStores]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentityStores.html
type IdentitySourceFilter struct {

	// The Cedar entity type of the principals returned by the identity provider (IdP)
	// associated with this identity source.
	PrincipalEntityType *string

	noSmithyDocumentSerde
}

// A structure that defines an identity source.
//
// This data type is a response parameter to the [ListIdentitySources] operation.
//
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type IdentitySourceItem struct {

	// The date and time the identity source was originally created.
	//
	// This member is required.
	CreatedDate *time.Time

	// The unique identifier of the identity source.
	//
	// This member is required.
	IdentitySourceId *string

	// The date and time the identity source was most recently updated.
	//
	// This member is required.
	LastUpdatedDate *time.Time

	// The identifier of the policy store that contains the identity source.
	//
	// This member is required.
	PolicyStoreId *string

	// The Cedar entity type of the principals returned from the IdP associated with
	// this identity source.
	//
	// This member is required.
	PrincipalEntityType *string

	// Contains configuration information about an identity source.
	Configuration ConfigurationItem

	// A structure that contains the details of the associated identity provider (IdP).
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration
	Details *IdentitySourceItemDetails

	noSmithyDocumentSerde
}

// A structure that contains configuration of the identity source.
//
// This data type was a response parameter for the [ListIdentitySources] operation. Replaced by [ConfigurationItem].
//
// [ConfigurationItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type IdentitySourceItemDetails struct {

	// The application client IDs associated with the specified Amazon Cognito user
	// pool that are enabled for this identity source.
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration.clientIds
	ClientIds []string

	// The well-known URL that points to this user pool's OIDC discovery endpoint.
	// This is a URL string in the following format. This URL replaces the placeholders
	// for both the Amazon Web Services Region and the user pool identifier with those
	// appropriate for this user pool.
	//
	//     https://cognito-idp.<region>.amazonaws.com/<user-pool-id>/.well-known/openid-configuration
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration.issuer
	DiscoveryUrl *string

	// A string that identifies the type of OIDC service represented by this identity
	// source.
	//
	// At this time, the only valid value is cognito .
	//
	// Deprecated: This attribute has been replaced by configuration
	OpenIdIssuer OpenIdIssuer

	// The Amazon Cognito user pool whose identities are accessible to this Verified
	// Permissions policy store.
	//
	// Deprecated: This attribute has been replaced by
	// configuration.cognitoUserPoolConfiguration.userPoolArn
	UserPoolArn *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [OpenIdConnectTokenSelection] structure, which is a parameter of [CreateIdentitySource].
//
// [OpenIdConnectTokenSelection]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type OpenIdConnectAccessTokenConfiguration struct {

	// The access token aud claim values that you want to accept in your policy store.
	// For example, https://myapp.example.com, https://myapp2.example.com .
	Audiences []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [OpenIdConnectTokenSelectionDetail] structure, which is a parameter of [GetIdentitySource].
//
// [OpenIdConnectTokenSelectionDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionDetail.html
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
type OpenIdConnectAccessTokenConfigurationDetail struct {

	// The access token aud claim values that you want to accept in your policy store.
	// For example, https://myapp.example.com, https://myapp2.example.com .
	Audiences []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [OpenIdConnectTokenSelectionItem] structure, which is a parameter of [ListIdentitySources].
//
// [OpenIdConnectTokenSelectionItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type OpenIdConnectAccessTokenConfigurationItem struct {

	// The access token aud claim values that you want to accept in your policy store.
	// For example, https://myapp.example.com, https://myapp2.example.com .
	Audiences []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// This data type is part of a [Configuration] structure, which is a parameter to [CreateIdentitySource].
//
// [Configuration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type OpenIdConnectConfiguration struct {

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC
	// discovery endpoint at the path .well-known/openid-configuration .
	//
	// This member is required.
	Issuer *string

	// The token type that you want to process from your OIDC identity provider. Your
	// policy store can process either identity (ID) or access tokens from a given OIDC
	// identity source.
	//
	// This member is required.
	TokenSelection OpenIdConnectTokenSelection

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider ,
	// you can reference principals in your policies in the format
	// MyCorp::User::MyOIDCProvider|Carlos .
	EntityIdPrefix *string

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example, this
	// object can map the contents of a groups claim to MyCorp::UserGroup .
	GroupConfiguration *OpenIdConnectGroupConfiguration

	noSmithyDocumentSerde
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// This data type is part of a [ConfigurationDetail] structure, which is a parameter to [GetIdentitySource].
//
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
// [ConfigurationDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html
type OpenIdConnectConfigurationDetail struct {

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC
	// discovery endpoint at the path .well-known/openid-configuration .
	//
	// This member is required.
	Issuer *string

	// The token type that you want to process from your OIDC identity provider. Your
	// policy store can process either identity (ID) or access tokens from a given OIDC
	// identity source.
	//
	// This member is required.
	TokenSelection OpenIdConnectTokenSelectionDetail

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider ,
	// you can reference principals in your policies in the format
	// MyCorp::User::MyOIDCProvider|Carlos .
	EntityIdPrefix *string

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example, this
	// object can map the contents of a groups claim to MyCorp::UserGroup .
	GroupConfiguration *OpenIdConnectGroupConfigurationDetail

	noSmithyDocumentSerde
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// This data type is part of a [ConfigurationItem] structure, which is a parameter to [ListIdentitySources].
//
// [ConfigurationItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type OpenIdConnectConfigurationItem struct {

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC
	// discovery endpoint at the path .well-known/openid-configuration .
	//
	// This member is required.
	Issuer *string

	// The token type that you want to process from your OIDC identity provider. Your
	// policy store can process either identity (ID) or access tokens from a given OIDC
	// identity source.
	//
	// This member is required.
	TokenSelection OpenIdConnectTokenSelectionItem

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider ,
	// you can reference principals in your policies in the format
	// MyCorp::User::MyOIDCProvider|Carlos .
	EntityIdPrefix *string

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example, this
	// object can map the contents of a groups claim to MyCorp::UserGroup .
	GroupConfiguration *OpenIdConnectGroupConfigurationItem

	noSmithyDocumentSerde
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example, this
// object can map the contents of a groups claim to MyCorp::UserGroup .
//
// This data type is part of a [OpenIdConnectConfiguration] structure, which is a parameter of [CreateIdentitySource].
//
// [OpenIdConnectConfiguration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type OpenIdConnectGroupConfiguration struct {

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups .
	//
	// This member is required.
	GroupClaim *string

	// The policy store entity type that you want to map your users' group claim to.
	// For example, MyCorp::UserGroup . A group entity type is an entity that can have
	// a user entity type as a member.
	//
	// This member is required.
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example, this
// object can map the contents of a groups claim to MyCorp::UserGroup .
//
// This data type is part of a [OpenIdConnectConfigurationDetail] structure, which is a parameter of [GetIdentitySource].
//
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
// [OpenIdConnectConfigurationDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationDetail.html
type OpenIdConnectGroupConfigurationDetail struct {

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups .
	//
	// This member is required.
	GroupClaim *string

	// The policy store entity type that you want to map your users' group claim to.
	// For example, MyCorp::UserGroup . A group entity type is an entity that can have
	// a user entity type as a member.
	//
	// This member is required.
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example, this
// object can map the contents of a groups claim to MyCorp::UserGroup .
//
// This data type is part of a [OpenIdConnectConfigurationItem] structure, which is a parameter of [ListIdentitySourcea].
//
// [ListIdentitySourcea]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
// [OpenIdConnectConfigurationItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationItem.html
type OpenIdConnectGroupConfigurationItem struct {

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups .
	//
	// This member is required.
	GroupClaim *string

	// The policy store entity type that you want to map your users' group claim to.
	// For example, MyCorp::UserGroup . A group entity type is an entity that can have
	// a user entity type as a member.
	//
	// This member is required.
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [OpenIdConnectTokenSelection] structure, which is a parameter of [CreateIdentitySource].
//
// [OpenIdConnectTokenSelection]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelection.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type OpenIdConnectIdentityTokenConfiguration struct {

	// The ID token audience, or client ID, claim values that you want to accept in
	// your policy store from an OIDC identity provider. For example,
	// 1example23456789, 2example10111213 .
	ClientIds []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [OpenIdConnectTokenSelectionDetail] structure, which is a parameter of [GetIdentitySource].
//
// [OpenIdConnectTokenSelectionDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionDetail.html
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
type OpenIdConnectIdentityTokenConfigurationDetail struct {

	// The ID token audience, or client ID, claim values that you want to accept in
	// your policy store from an OIDC identity provider. For example,
	// 1example23456789, 2example10111213 .
	ClientIds []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [OpenIdConnectTokenSelectionItem] structure, which is a parameter of [ListIdentitySources].
//
// [OpenIdConnectTokenSelectionItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html
// [ListIdentitySources]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type OpenIdConnectIdentityTokenConfigurationItem struct {

	// The ID token audience, or client ID, claim values that you want to accept in
	// your policy store from an OIDC identity provider. For example,
	// 1example23456789, 2example10111213 .
	ClientIds []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// The token type that you want to process from your OIDC identity provider. Your
// policy store can process either identity (ID) or access tokens from a given OIDC
// identity source.
//
// This data type is part of a [OpenIdConnectConfiguration] structure, which is a parameter of [CreateIdentitySource].
//
// The following types satisfy this interface:
//
//	OpenIdConnectTokenSelectionMemberAccessTokenOnly
//	OpenIdConnectTokenSelectionMemberIdentityTokenOnly
//
// [OpenIdConnectConfiguration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html
// [CreateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html
type OpenIdConnectTokenSelection interface {
	isOpenIdConnectTokenSelection()
}

// The OIDC configuration for processing access tokens. Contains allowed audience
// claims, for example https://auth.example.com , and the claim that you want to
// map to the principal, for example sub .
type OpenIdConnectTokenSelectionMemberAccessTokenOnly struct {
	Value OpenIdConnectAccessTokenConfiguration

	noSmithyDocumentSerde
}

func (*OpenIdConnectTokenSelectionMemberAccessTokenOnly) isOpenIdConnectTokenSelection() {}

// The OIDC configuration for processing identity (ID) tokens. Contains allowed
// client ID claims, for example 1example23456789 , and the claim that you want to
// map to the principal, for example sub .
type OpenIdConnectTokenSelectionMemberIdentityTokenOnly struct {
	Value OpenIdConnectIdentityTokenConfiguration

	noSmithyDocumentSerde
}

func (*OpenIdConnectTokenSelectionMemberIdentityTokenOnly) isOpenIdConnectTokenSelection() {}

// The token type that you want to process from your OIDC identity provider. Your
// policy store can process either identity (ID) or access tokens from a given OIDC
// identity source.
//
// This data type is part of a [OpenIdConnectConfigurationDetail] structure, which is a parameter of [GetIdentitySource].
//
// The following types satisfy this interface:
//
//	OpenIdConnectTokenSelectionDetailMemberAccessTokenOnly
//	OpenIdConnectTokenSelectionDetailMemberIdentityTokenOnly
//
// [GetIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetIdentitySource.html
// [OpenIdConnectConfigurationDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationDetail.html
type OpenIdConnectTokenSelectionDetail interface {
	isOpenIdConnectTokenSelectionDetail()
}

// The OIDC configuration for processing access tokens. Contains allowed audience
// claims, for example https://auth.example.com , and the claim that you want to
// map to the principal, for example sub .
type OpenIdConnectTokenSelectionDetailMemberAccessTokenOnly struct {
	Value OpenIdConnectAccessTokenConfigurationDetail

	noSmithyDocumentSerde
}

func (*OpenIdConnectTokenSelectionDetailMemberAccessTokenOnly) isOpenIdConnectTokenSelectionDetail() {
}

// The OIDC configuration for processing identity (ID) tokens. Contains allowed
// client ID claims, for example 1example23456789 , and the claim that you want to
// map to the principal, for example sub .
type OpenIdConnectTokenSelectionDetailMemberIdentityTokenOnly struct {
	Value OpenIdConnectIdentityTokenConfigurationDetail

	noSmithyDocumentSerde
}

func (*OpenIdConnectTokenSelectionDetailMemberIdentityTokenOnly) isOpenIdConnectTokenSelectionDetail() {
}

// The token type that you want to process from your OIDC identity provider. Your
// policy store can process either identity (ID) or access tokens from a given OIDC
// identity source.
//
// This data type is part of a [OpenIdConnectConfigurationItem] structure, which is a parameter of [ListIdentitySources].
//
// The following types satisfy this interface:
//
//	OpenIdConnectTokenSelectionItemMemberAccessTokenOnly
//	OpenIdConnectTokenSelectionItemMemberIdentityTokenOnly
//
// [OpenIdConnectConfigurationItem]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfigurationItem.html
// [ListIdentitySources]: http://amazonaws.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html
type OpenIdConnectTokenSelectionItem interface {
	isOpenIdConnectTokenSelectionItem()
}

// The OIDC configuration for processing access tokens. Contains allowed audience
// claims, for example https://auth.example.com , and the claim that you want to
// map to the principal, for example sub .
type OpenIdConnectTokenSelectionItemMemberAccessTokenOnly struct {
	Value OpenIdConnectAccessTokenConfigurationItem

	noSmithyDocumentSerde
}

func (*OpenIdConnectTokenSelectionItemMemberAccessTokenOnly) isOpenIdConnectTokenSelectionItem() {}

// The OIDC configuration for processing identity (ID) tokens. Contains allowed
// client ID claims, for example 1example23456789 , and the claim that you want to
// map to the principal, for example sub .
type OpenIdConnectTokenSelectionItemMemberIdentityTokenOnly struct {
	Value OpenIdConnectIdentityTokenConfigurationItem

	noSmithyDocumentSerde
}

func (*OpenIdConnectTokenSelectionItemMemberIdentityTokenOnly) isOpenIdConnectTokenSelectionItem() {}

// A structure that contains the details for a Cedar policy definition. It
// includes the policy type, a description, and a policy body. This is a top level
// data type used to create a policy.
//
// This data type is used as a request parameter for the [CreatePolicy] operation. This
// structure must always have either an static or a templateLinked element.
//
// The following types satisfy this interface:
//
//	PolicyDefinitionMemberStatic
//	PolicyDefinitionMemberTemplateLinked
//
// [CreatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
type PolicyDefinition interface {
	isPolicyDefinition()
}

// A structure that describes a static policy. An static policy doesn't use a
// template or allow placeholders for entities.
type PolicyDefinitionMemberStatic struct {
	Value StaticPolicyDefinition

	noSmithyDocumentSerde
}

func (*PolicyDefinitionMemberStatic) isPolicyDefinition() {}

// A structure that describes a policy that was instantiated from a template. The
// template can specify placeholders for principal and resource . When you use [CreatePolicy] to
// create a policy from a template, you specify the exact principal and resource to
// use for the instantiated policy.
//
// [CreatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
type PolicyDefinitionMemberTemplateLinked struct {
	Value TemplateLinkedPolicyDefinition

	noSmithyDocumentSerde
}

func (*PolicyDefinitionMemberTemplateLinked) isPolicyDefinition() {}

// A structure that describes a policy definition. It must always have either an
// static or a templateLinked element.
//
// This data type is used as a response parameter for the [GetPolicy] operation.
//
// The following types satisfy this interface:
//
//	PolicyDefinitionDetailMemberStatic
//	PolicyDefinitionDetailMemberTemplateLinked
//
// [GetPolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html
type PolicyDefinitionDetail interface {
	isPolicyDefinitionDetail()
}

// Information about a static policy that wasn't created with a policy template.
type PolicyDefinitionDetailMemberStatic struct {
	Value StaticPolicyDefinitionDetail

	noSmithyDocumentSerde
}

func (*PolicyDefinitionDetailMemberStatic) isPolicyDefinitionDetail() {}

// Information about a template-linked policy that was created by instantiating a
// policy template.
type PolicyDefinitionDetailMemberTemplateLinked struct {
	Value TemplateLinkedPolicyDefinitionDetail

	noSmithyDocumentSerde
}

func (*PolicyDefinitionDetailMemberTemplateLinked) isPolicyDefinitionDetail() {}

// A structure that describes a [PolicyDefinintion]. It will always have either an StaticPolicy or a
// TemplateLinkedPolicy element.
//
// This data type is used as a response parameter for the [CreatePolicy] and [ListPolicies] operations.
//
// The following types satisfy this interface:
//
//	PolicyDefinitionItemMemberStatic
//	PolicyDefinitionItemMemberTemplateLinked
//
// [CreatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
// [ListPolicies]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html
// [PolicyDefinintion]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinintion.html
type PolicyDefinitionItem interface {
	isPolicyDefinitionItem()
}

// Information about a static policy that wasn't created with a policy template.
type PolicyDefinitionItemMemberStatic struct {
	Value StaticPolicyDefinitionItem

	noSmithyDocumentSerde
}

func (*PolicyDefinitionItemMemberStatic) isPolicyDefinitionItem() {}

// Information about a template-linked policy that was created by instantiating a
// policy template.
type PolicyDefinitionItemMemberTemplateLinked struct {
	Value TemplateLinkedPolicyDefinitionItem

	noSmithyDocumentSerde
}

func (*PolicyDefinitionItemMemberTemplateLinked) isPolicyDefinitionItem() {}

// Contains information about a filter to refine policies returned in a query.
//
// This data type is used as a response parameter for the [ListPolicies] operation.
//
// [ListPolicies]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html
type PolicyFilter struct {

	// Filters the output to only template-linked policies that were instantiated from
	// the specified policy template.
	PolicyTemplateId *string

	// Filters the output to only policies of the specified type.
	PolicyType PolicyType

	// Filters the output to only policies that reference the specified principal.
	Principal EntityReference

	// Filters the output to only policies that reference the specified resource.
	Resource EntityReference

	noSmithyDocumentSerde
}

// Contains information about a policy.
//
// This data type is used as a response parameter for the [ListPolicies] operation.
//
// [ListPolicies]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html
type PolicyItem struct {

	// The date and time the policy was created.
	//
	// This member is required.
	CreatedDate *time.Time

	// The policy definition of an item in the list of policies returned.
	//
	// This member is required.
	Definition PolicyDefinitionItem

	// The date and time the policy was most recently updated.
	//
	// This member is required.
	LastUpdatedDate *time.Time

	// The identifier of the policy you want information about.
	//
	// This member is required.
	PolicyId *string

	// The identifier of the policy store where the policy you want information about
	// is stored.
	//
	// This member is required.
	PolicyStoreId *string

	// The type of the policy. This is one of the following values:
	//
	//   - STATIC
	//
	//   - TEMPLATE_LINKED
	//
	// This member is required.
	PolicyType PolicyType

	// The action that a policy permits or forbids. For example, {"actions":
	// [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID":
	// "SharePhoto", "entityType": "PhotoFlash::Action"}]} .
	Actions []ActionIdentifier

	// The effect of the decision that a policy returns to an authorization request.
	// For example, "effect": "Permit" .
	Effect PolicyEffect

	// The principal associated with the policy.
	Principal *EntityIdentifier

	// The resource associated with the policy.
	Resource *EntityIdentifier

	noSmithyDocumentSerde
}

// Contains information about a policy store.
//
// This data type is used as a response parameter for the [ListPolicyStores] operation.
//
// [ListPolicyStores]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyStores.html
type PolicyStoreItem struct {

	// The Amazon Resource Name (ARN) of the policy store.
	//
	// This member is required.
	Arn *string

	// The date and time the policy was created.
	//
	// This member is required.
	CreatedDate *time.Time

	// The unique identifier of the policy store.
	//
	// This member is required.
	PolicyStoreId *string

	// Descriptive text that you can provide to help with identification of the
	// current policy store.
	Description *string

	// The date and time the policy store was most recently updated.
	LastUpdatedDate *time.Time

	noSmithyDocumentSerde
}

// Contains details about a policy template
//
// This data type is used as a response parameter for the [ListPolicyTemplates] operation.
//
// [ListPolicyTemplates]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyTemplates.html
type PolicyTemplateItem struct {

	// The date and time that the policy template was created.
	//
	// This member is required.
	CreatedDate *time.Time

	// The date and time that the policy template was most recently updated.
	//
	// This member is required.
	LastUpdatedDate *time.Time

	// The unique identifier of the policy store that contains the template.
	//
	// This member is required.
	PolicyStoreId *string

	// The unique identifier of the policy template.
	//
	// This member is required.
	PolicyTemplateId *string

	// The description attached to the policy template.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about a resource conflict.
type ResourceConflict struct {

	// The unique identifier of the resource involved in a conflict.
	//
	// This member is required.
	ResourceId *string

	// The type of the resource involved in a conflict.
	//
	// This member is required.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Contains a list of principal types, resource types, and actions that can be
// specified in policies stored in the same policy store. If the validation mode
// for the policy store is set to STRICT , then policies that can't be validated by
// this schema are rejected by Verified Permissions and can't be stored in the
// policy store.
//
// The following types satisfy this interface:
//
//	SchemaDefinitionMemberCedarJson
type SchemaDefinition interface {
	isSchemaDefinition()
}

// A JSON string representation of the schema supported by applications that use
// this policy store. To delete the schema, run [PutSchema]with {} for this parameter. For
// more information, see [Policy store schema]in the Amazon Verified Permissions User Guide.
//
// [PutSchema]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PutSchema.html
// [Policy store schema]: https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html
type SchemaDefinitionMemberCedarJson struct {
	Value string

	noSmithyDocumentSerde
}

func (*SchemaDefinitionMemberCedarJson) isSchemaDefinition() {}

// Contains information about a static policy.
//
// This data type is used as a field that is part of the [PolicyDefinitionDetail] type.
//
// [PolicyDefinitionDetail]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinitionDetail.html
type StaticPolicyDefinition struct {

	// The policy content of the static policy, written in the Cedar policy language.
	//
	// This member is required.
	Statement *string

	// The description of the static policy.
	Description *string

	noSmithyDocumentSerde
}

// A structure that contains details about a static policy. It includes the
// description and policy body.
//
// This data type is used within a [PolicyDefinition] structure as part of a request parameter for
// the [CreatePolicy]operation.
//
// [CreatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
// [PolicyDefinition]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html
type StaticPolicyDefinitionDetail struct {

	// The content of the static policy written in the Cedar policy language.
	//
	// This member is required.
	Statement *string

	// A description of the static policy.
	Description *string

	noSmithyDocumentSerde
}

// A structure that contains details about a static policy. It includes the
// description and policy statement.
//
// This data type is used within a [PolicyDefinition] structure as part of a request parameter for
// the [CreatePolicy]operation.
//
// [CreatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html
// [PolicyDefinition]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html
type StaticPolicyDefinitionItem struct {

	// A description of the static policy.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about a policy created by instantiating a policy template.
type TemplateLinkedPolicyDefinition struct {

	// The unique identifier of the policy template used to create this policy.
	//
	// This member is required.
	PolicyTemplateId *string

	// The principal associated with this template-linked policy. Verified Permissions
	// substitutes this principal for the ?principal placeholder in the policy
	// template when it evaluates an authorization request.
	Principal *EntityIdentifier

	// The resource associated with this template-linked policy. Verified Permissions
	// substitutes this resource for the ?resource placeholder in the policy template
	// when it evaluates an authorization request.
	Resource *EntityIdentifier

	noSmithyDocumentSerde
}

// Contains information about a policy that was created by instantiating a policy
// template.
type TemplateLinkedPolicyDefinitionDetail struct {

	// The unique identifier of the policy template used to create this policy.
	//
	// This member is required.
	PolicyTemplateId *string

	// The principal associated with this template-linked policy. Verified Permissions
	// substitutes this principal for the ?principal placeholder in the policy
	// template when it evaluates an authorization request.
	Principal *EntityIdentifier

	// The resource associated with this template-linked policy. Verified Permissions
	// substitutes this resource for the ?resource placeholder in the policy template
	// when it evaluates an authorization request.
	Resource *EntityIdentifier

	noSmithyDocumentSerde
}

// Contains information about a policy created by instantiating a policy template.
type TemplateLinkedPolicyDefinitionItem struct {

	// The unique identifier of the policy template used to create this policy.
	//
	// This member is required.
	PolicyTemplateId *string

	// The principal associated with this template-linked policy. Verified Permissions
	// substitutes this principal for the ?principal placeholder in the policy
	// template when it evaluates an authorization request.
	Principal *EntityIdentifier

	// The resource associated with this template-linked policy. Verified Permissions
	// substitutes this resource for the ?resource placeholder in the policy template
	// when it evaluates an authorization request.
	Resource *EntityIdentifier

	noSmithyDocumentSerde
}

// The user group entities from an Amazon Cognito user pool identity source.
type UpdateCognitoGroupConfiguration struct {

	// The name of the schema entity type that's mapped to the user pool group.
	// Defaults to AWS::CognitoGroup .
	//
	// This member is required.
	GroupEntityType *string

	noSmithyDocumentSerde
}

// Contains configuration details of a Amazon Cognito user pool for use with an
// identity source.
type UpdateCognitoUserPoolConfiguration struct {

	// The [Amazon Resource Name (ARN)] of the Amazon Cognito user pool associated with this identity source.
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	UserPoolArn *string

	// The client ID of an app client that is configured for the specified Amazon
	// Cognito user pool.
	ClientIds []string

	// The configuration of the user groups from an Amazon Cognito user pool identity
	// source.
	GroupConfiguration *UpdateCognitoGroupConfiguration

	noSmithyDocumentSerde
}

// Contains an update to replace the configuration in an existing identity source.
//
// The following types satisfy this interface:
//
//	UpdateConfigurationMemberCognitoUserPoolConfiguration
//	UpdateConfigurationMemberOpenIdConnectConfiguration
type UpdateConfiguration interface {
	isUpdateConfiguration()
}

// Contains configuration details of a Amazon Cognito user pool.
type UpdateConfigurationMemberCognitoUserPoolConfiguration struct {
	Value UpdateCognitoUserPoolConfiguration

	noSmithyDocumentSerde
}

func (*UpdateConfigurationMemberCognitoUserPoolConfiguration) isUpdateConfiguration() {}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
type UpdateConfigurationMemberOpenIdConnectConfiguration struct {
	Value UpdateOpenIdConnectConfiguration

	noSmithyDocumentSerde
}

func (*UpdateConfigurationMemberOpenIdConnectConfiguration) isUpdateConfiguration() {}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// access token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [UpdateOpenIdConnectTokenSelection] structure, which is a parameter to [UpdateIdentitySource].
//
// [UpdateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html
// [UpdateOpenIdConnectTokenSelection]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html
type UpdateOpenIdConnectAccessTokenConfiguration struct {

	// The access token aud claim values that you want to accept in your policy store.
	// For example, https://myapp.example.com, https://myapp2.example.com .
	Audiences []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// Contains configuration details of an OpenID Connect (OIDC) identity provider,
// or identity source, that Verified Permissions can use to generate entities from
// authenticated identities. It specifies the issuer URL, token type that you want
// to use, and policy store entity details.
//
// This data type is part of a [UpdateConfiguration] structure, which is a parameter to [UpdateIdentitySource].
//
// [UpdateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html
// [UpdateConfiguration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateConfiguration.html
type UpdateOpenIdConnectConfiguration struct {

	// The issuer URL of an OIDC identity provider. This URL must have an OIDC
	// discovery endpoint at the path .well-known/openid-configuration .
	//
	// This member is required.
	Issuer *string

	// The token type that you want to process from your OIDC identity provider. Your
	// policy store can process either identity (ID) or access tokens from a given OIDC
	// identity source.
	//
	// This member is required.
	TokenSelection UpdateOpenIdConnectTokenSelection

	// A descriptive string that you want to prefix to user entities from your OIDC
	// identity provider. For example, if you set an entityIdPrefix of MyOIDCProvider ,
	// you can reference principals in your policies in the format
	// MyCorp::User::MyOIDCProvider|Carlos .
	EntityIdPrefix *string

	// The claim in OIDC identity provider tokens that indicates a user's group
	// membership, and the entity type that you want to map it to. For example, this
	// object can map the contents of a groups claim to MyCorp::UserGroup .
	GroupConfiguration *UpdateOpenIdConnectGroupConfiguration

	noSmithyDocumentSerde
}

// The claim in OIDC identity provider tokens that indicates a user's group
// membership, and the entity type that you want to map it to. For example, this
// object can map the contents of a groups claim to MyCorp::UserGroup .
//
// This data type is part of a [UpdateOpenIdConnectConfiguration] structure, which is a parameter to [UpdateIdentitySource].
//
// [UpdateOpenIdConnectConfiguration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html
// [UpdateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html
type UpdateOpenIdConnectGroupConfiguration struct {

	// The token claim that you want Verified Permissions to interpret as group
	// membership. For example, groups .
	//
	// This member is required.
	GroupClaim *string

	// The policy store entity type that you want to map your users' group claim to.
	// For example, MyCorp::UserGroup . A group entity type is an entity that can have
	// a user entity type as a member.
	//
	// This member is required.
	GroupEntityType *string

	noSmithyDocumentSerde
}

// The configuration of an OpenID Connect (OIDC) identity source for handling
// identity (ID) token claims. Contains the claim that you want to identify as the
// principal in an authorization request, and the values of the aud claim, or
// audiences, that you want to accept.
//
// This data type is part of a [UpdateOpenIdConnectTokenSelection] structure, which is a parameter to [UpdateIdentitySource].
//
// [UpdateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html
// [UpdateOpenIdConnectTokenSelection]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html
type UpdateOpenIdConnectIdentityTokenConfiguration struct {

	// The ID token audience, or client ID, claim values that you want to accept in
	// your policy store from an OIDC identity provider. For example,
	// 1example23456789, 2example10111213 .
	ClientIds []string

	// The claim that determines the principal in OIDC access tokens. For example, sub .
	PrincipalIdClaim *string

	noSmithyDocumentSerde
}

// The token type that you want to process from your OIDC identity provider. Your
// policy store can process either identity (ID) or access tokens from a given OIDC
// identity source.
//
// This data type is part of a [UpdateOpenIdConnectConfiguration] structure, which is a parameter to [UpdateIdentitySource].
//
// The following types satisfy this interface:
//
//	UpdateOpenIdConnectTokenSelectionMemberAccessTokenOnly
//	UpdateOpenIdConnectTokenSelectionMemberIdentityTokenOnly
//
// [UpdateOpenIdConnectConfiguration]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectConfiguration.html
// [UpdateIdentitySource]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html
type UpdateOpenIdConnectTokenSelection interface {
	isUpdateOpenIdConnectTokenSelection()
}

// The OIDC configuration for processing access tokens. Contains allowed audience
// claims, for example https://auth.example.com , and the claim that you want to
// map to the principal, for example sub .
type UpdateOpenIdConnectTokenSelectionMemberAccessTokenOnly struct {
	Value UpdateOpenIdConnectAccessTokenConfiguration

	noSmithyDocumentSerde
}

func (*UpdateOpenIdConnectTokenSelectionMemberAccessTokenOnly) isUpdateOpenIdConnectTokenSelection() {
}

// The OIDC configuration for processing identity (ID) tokens. Contains allowed
// client ID claims, for example 1example23456789 , and the claim that you want to
// map to the principal, for example sub .
type UpdateOpenIdConnectTokenSelectionMemberIdentityTokenOnly struct {
	Value UpdateOpenIdConnectIdentityTokenConfiguration

	noSmithyDocumentSerde
}

func (*UpdateOpenIdConnectTokenSelectionMemberIdentityTokenOnly) isUpdateOpenIdConnectTokenSelection() {
}

// Contains information about updates to be applied to a policy.
//
// This data type is used as a request parameter in the [UpdatePolicy] operation.
//
// The following types satisfy this interface:
//
//	UpdatePolicyDefinitionMemberStatic
//
// [UpdatePolicy]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html
type UpdatePolicyDefinition interface {
	isUpdatePolicyDefinition()
}

// Contains details about the updates to be applied to a static policy.
type UpdatePolicyDefinitionMemberStatic struct {
	Value UpdateStaticPolicyDefinition

	noSmithyDocumentSerde
}

func (*UpdatePolicyDefinitionMemberStatic) isUpdatePolicyDefinition() {}

// Contains information about an update to a static policy.
type UpdateStaticPolicyDefinition struct {

	// Specifies the Cedar policy language text to be added to or replaced on the
	// static policy.
	//
	// You can change only the following elements from the original content:
	//
	//   - The action referenced by the policy.
	//
	//   - Any conditional clauses, such as when or unless clauses.
	//
	// You can't change the following elements:
	//
	//   - Changing from StaticPolicy to TemplateLinkedPolicy .
	//
	//   - The effect ( permit or forbid ) of the policy.
	//
	//   - The principal referenced by the policy.
	//
	//   - The resource referenced by the policy.
	//
	// This member is required.
	Statement *string

	// Specifies the description to be added to or replaced on the static policy.
	Description *string

	noSmithyDocumentSerde
}

// Details about a field that failed policy validation.
type ValidationExceptionField struct {

	// Describes the policy validation error.
	//
	// This member is required.
	Message *string

	// The path to the specific element that Verified Permissions found to be not
	// valid.
	//
	// This member is required.
	Path *string

	noSmithyDocumentSerde
}

// A structure that contains Cedar policy validation settings for the policy
// store. The validation mode determines which validation failures that Cedar
// considers serious enough to block acceptance of a new or edited static policy or
// policy template.
//
// This data type is used as a request parameter in the [CreatePolicyStore] and [UpdatePolicyStore] operations.
//
// [UpdatePolicyStore]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore.html
// [CreatePolicyStore]: https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyStore.html
type ValidationSettings struct {

	// The validation mode currently configured for this policy store. The valid
	// values are:
	//
	//   - OFF – Neither Verified Permissions nor Cedar perform any validation on
	//   policies. No validation errors are reported by either service.
	//
	//   - STRICT – Requires a schema to be present in the policy store. Cedar
	//   performs validation on all submitted new or updated static policies and policy
	//   templates. Any that fail validation are rejected and Cedar doesn't store them in
	//   the policy store.
	//
	// If Mode=STRICT and the policy store doesn't contain a schema, Verified
	// Permissions rejects all static policies and policy templates because there is no
	// schema to validate against.
	//
	// To submit a static policy or policy template without a schema, you must turn
	// off validation.
	//
	// This member is required.
	Mode ValidationMode

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAttributeValue()                    {}
func (*UnknownUnionMember) isCedarTagValue()                     {}
func (*UnknownUnionMember) isConfiguration()                     {}
func (*UnknownUnionMember) isConfigurationDetail()               {}
func (*UnknownUnionMember) isConfigurationItem()                 {}
func (*UnknownUnionMember) isContextDefinition()                 {}
func (*UnknownUnionMember) isEntitiesDefinition()                {}
func (*UnknownUnionMember) isEntityReference()                   {}
func (*UnknownUnionMember) isOpenIdConnectTokenSelection()       {}
func (*UnknownUnionMember) isOpenIdConnectTokenSelectionDetail() {}
func (*UnknownUnionMember) isOpenIdConnectTokenSelectionItem()   {}
func (*UnknownUnionMember) isPolicyDefinition()                  {}
func (*UnknownUnionMember) isPolicyDefinitionDetail()            {}
func (*UnknownUnionMember) isPolicyDefinitionItem()              {}
func (*UnknownUnionMember) isSchemaDefinition()                  {}
func (*UnknownUnionMember) isUpdateConfiguration()               {}
func (*UnknownUnionMember) isUpdateOpenIdConnectTokenSelection() {}
func (*UnknownUnionMember) isUpdatePolicyDefinition()            {}
