# v0.12 - Preinfusion

![](./v0.12/banner.png)

## Preinvoke

Generic alteration of completion before execution which enables features like directory change in `git -C <DIR>`:

![](./v0.12/preinvoke.png)

## Spec

Experimental support for simple completions using `yaml` [spec files](https://github.com/carapace-sh/carapace-spec/tree/master/example):

```yaml
name: example
description:
flags:
  --dynamic=: dynamic value
  -o, --optarg?: optarg flag
  -s, --styled=: styled values
completion:
  flag:
    dynamic: ["$(git branch --all | cut -c 3- | sed 's/$/\t\tblue/')", "static value"]
    optarg: ["first", "second", "third"]
    styled:
    - "blue\tblue\tblue"
    - "cyan\tcyan\tcyan"
  positional:
  -  ["pos1-a", "pos1-b", "pos1-c"]
  -  ["$_files"]
```

## Spec Autoloading

Specs placed in `${UserConfigDir}/carapace/specs/` ([UserConfigDir](https://pkg.go.dev/os@go1.18.1#UserConfigDir)) are now registered with `carapace _carapace`.
File name must be the command to be completed and match `^[0-9a-zA-Z_\-.]+\.yaml$` (sanity check to avoid breakage in scripts).

## Custom Macros

Exposed [actions](https://pkg.go.dev/github.com/carapace-sh/carapace-bin/pkg/actions) as custom macros (list with `carapace --macros`).
Removed the `_` prefix from core macros to avoid clashes (e.g. `$files`, `$directories`).

## Macro Arguments
Arguments are parsed as `yaml` (`$macro(yaml)` - e.g.: `$_tools.gh.Users({users: true})`).
Brackets are optional when no argument is passed (`$files` instead of `$files()`).

## Variable Substitution

Variables are replaced using [drone/envsubst](https://github.com/drone/envsubst) for contextual completion:

```yaml
name: myzip
completion:
  positional:
    - ["$files([.zip])"] # ${C_ARG0}
  positionalany: ["$_fs.ZipFileContents(${C_ARG0})"] # ${C_ARG1},${C_ARG2},...
```

Flags are only added to env when their value changed (thus: `${C_FLAG_FLAGNAME:-default}`):

```yaml
name: myrefs
flags:
  --tags: list tags # ${C_FLAG_TAGS}
  --localbranches: list local branches # ${C_FLAG_LOCALBRANCHES}
  --commits=: amount of commits # ${C_FLAG_COMMITS}
completion:
  positional:
    - ["$_tools.git.Refs({tags: ${C_FLAG_TAGS:-false}, localbranches: ${C_FLAG_LOCALBRANCHES:-false}, commits: ${C_FLAG_COMMITS:-0}})"] # refs based on flag values with defaults
    - ["$_tools.git.Refs"] # default refs
    - ["$(env)"] # env
```
