package golang

import (
	"github.com/carapace-sh/carapace"
)

// ActionVersions completes go versions
//
//	1.18 (2022-03-15)
//	1.19 (2022-08-02)
func ActionVersions() carapace.Action {
	//  https://go.dev/doc/devel/release
	return carapace.ActionValuesDescribed(
		"1.25.0", "2025-08-12",
		"1.24.0", "2025-02-11",
		"1.23.0", "2024-08-13",
		"1.22.0", "2024-02-06",
		"1.21.0", "2023-08-08",
		"1.20", "2023-02-01",
		"1.19", "2022-08-02",
		"1.18", "2022-03-15",
		"1.17", "2021-08-16",
		"1.16", "2021-02-16",
		"1.15", "2020-08-11",
		"1.14", "2020-02-25",
		"1.13", "2019-09-03",
		"1.12", "2019-02-25",
		"1.11", "2018-08-24",
		"1.10", "2018-02-16",
		"1.9", "2017-08-24",
		"1.8", "2017-02-16",
		"1.7", "2016-08-15",
		"1.6", "2016-02-17",
		"1.5", "2015-08-19",
		"1.4", "2014-12-10",
		"1.3", "2014-06-18",
		"1.2", "2013-12-01",
		"1.1", "2013-05-13",
		"1", "2012-03-28",
	).Tag("go versions").Uid("go", "version")
}
