# syntax=docker/dockerfile:1.4
FROM golang:1.26-alpine

ARG TARGETPLATFORM

# related to https://github.com/golangci/golangci-lint/issues/3107
ENV GOROOT /usr/local/go

# Allow to download a more recent version of Go.
# https://go.dev/doc/toolchain
# GOTOOLCHAIN=auto is shorthand for GOTOOLCHAIN=local+auto
ENV GOTOOLCHAIN auto

# gcc is required to support cgo;
# git and mercurial are needed most times for go get`, etc.
# See https://github.com/docker-library/golang/issues/80
RUN apk --no-cache add gcc musl-dev git mercurial

# Set all directories as safe
RUN git config --global --add safe.directory '*'

COPY $TARGETPLATFORM/golangci-lint /usr/bin/
CMD ["golangci-lint"]
