# This file was generated by GoReleaser. DO NOT EDIT.
cask "{{ .Name }}" do
  {{- with .CustomBlock -}}
  {{ range (split .) }}
  {{ . }}
  {{- end }}

  {{ end }}
  name "{{ .Name }}"
  desc "{{ .Description }}"
  homepage "{{ .Homepage }}"
  version "{{ .Version }}"

  livecheck do
    skip "Auto-generated on release."
  end

  {{ with and (not .HasOnlyBinaryPkgs) .Binaries }}
  {{- range . }}
  binary "{{ . }}"
  {{- end }}
  {{- end }}
  {{- range .Manpages }}
  manpage "{{ .}}"
  {{- end }}
  {{- with .Completions.Bash }}
  bash_completion "{{ . }}"
  {{- end }}
  {{- with .Completions.Zsh }}
  zsh_completion "{{ . }}"
  {{- end }}
  {{- with .Completions.Fish }}
  fish_completion "{{ . }}"
  {{- end }}

  {{- with .Dependencies }}
  {{ depends  . }}
  {{- end }}

  {{ if .MacOSPackages }}
  on_macos do
  {{- include "macos_packages" . | indent 2 }}
  end
  {{ end }}

  {{ if .LinuxPackages }}
  on_linux do
  {{- include "linux_packages" . | indent 2 }}
  end
  {{ end }}

  {{- with .Conflicts }}
  {{ conflicts . }}
  {{- end }}

  {{ with .Hooks.Pre.Install -}}
  preflight do
    {{- range (split .) }}
    {{ . }}
    {{- end }}
  end
  {{- end }}

  {{ with .Hooks.Post.Install -}}
  postflight do
    {{- range (split .) }}
    {{ . }}
    {{- end }}
  end
  {{- end }}

  {{ with .Hooks.Pre.Uninstall -}}
  uninstall_preflight do
    {{- range (split .) }}
    {{ . }}
    {{- end }}
  end
  {{- end }}

  {{ with .Hooks.Post.Uninstall -}}
  uninstall_postflight do
    {{- range (split .) }}
    {{ . }}
    {{- end }}
  end
  {{- end }}

  {{ with .Caveats -}}
  caveats do
    {{- range (split .) }}
    "{{ . -}}"
    {{- end }}
  end
  {{- end }}

  {{ with .Service -}}
  service "{{ . }}"
  {{- end }}


  {{ uninstall .Uninstall }}

  {{ zap .Zap }}
end
