# Roadmap

## Bash Parity

- [ ] History expansion
- [ ] Multiline input

## Ergonomics

- [ ] Keybind configuration (inputrc)
- [ ] Markdown rendering for agent text responses in REPL

## Language

- [ ] Agent structured output
- [ ] Parse time type checks
- [ ] Runtime type validation for tool parameters
- [ ] Type checking for tool return values
- [ ] Type annotations for variables and functions
- [ ] Type inference improvements
- [ ] Package management (optional)
- [ ] HTTP client
- [ ] JSON/CSV parsing
- [ ] Timezone support for DateTime
- [ ] File I/O helpers
- [ ] TreeSitter syntax highlighting
- [ ] Language Server Protocol (LSP)
- [ ] Built-in formatter
- [ ] Debugger
- [ ] Bytecode compilation
- [ ] VM optimization
- [ ] Caching and precompilation
- [ ] [concurrency support](./spec/GSH_CONCURRENCY_SPEC.md)
- [ ] Pattern matching

## SDK

- [ ] [Keystroke middleware](./spec/GSH_KEYSTROKE_MIDDLEWARE_SPEC.md)

## Default agent

- [ ] Improve default agent system prompt (context)
- [ ] Loading AGENTS.md
- [ ] Skills

## Performance

- [ ] Optimize startup time
- [ ] Limit total history size

## Distribution

- [ ] Official Homebrew
- [ ] Apt
- [ ] Nix
- [ ] Starship

## Bugs
