---
description: List all the devices Xcode knows about.
hide_table_of_contents: true
---

# List *OS Devices

> List all the devices Xcode knows about *(by parsing the `device_traits.db`)*

```bash
❯ ipsw device-list
```

| PRODUCT       | MODEL   | DESCRIPTION                                | CPU      | ARCH   | MEMCLASS |
| ------------- | ------- | ------------------------------------------ | -------- | ------ | -------- |
| AppleTV3,1    | j33ap   | AppleTV                                    | s5l8942x | armv7  | 0        |
| AppleTV3,2    | j33iap  | AppleTV                                    | s5l8947x | armv7  | 0        |
| AppleTV5,3    | j42dap  | Apple TV                                   | t7000    | arm64  | 2        |
| AppleTV6,2    | j105aap | Apple TV 4K                                | t8011    | arm64  | 4        |
| AppleTV11,1   | j305ap  | Apple TV 4K (2nd gen)                      | t8020    | arm64e | 4        |
| AppleTV14,1   | j255ap  | Apple TV 4K (3rd gen)                      | t8110    | arm64e | 3        |
| MacFamily20,1 | j129aap | Mac                                        | t8103    | arm64e | 16       |
| Watch1,1      | n27aap  | Apple Watch (1st gen) 38mm                 | s7002    | armv7k | 0        |
| Watch1,2      | n28aap  | Apple Watch (1st gen) 42mm                 | s7002    | armv7k | 0        |
| Watch2,3      | n74ap   | Apple Watch Series 2 38mm                  | t8002    | armv7k | 0        |
| Watch2,4      | n75ap   | Apple Watch Series 2 42mm                  | t8002    | armv7k | 0        |
| Watch2,6      | n27dap  | Apple Watch Series 1 38mm                  | t8002    | armv7k | 0        |
| Watch2,7      | n28dap  | Apple Watch Series 1 42mm                  | t8002    | armv7k | 0        |
| Watch3,1      | n111sap | Apple Watch Series 3 (GPS + Cellular) 38mm | t8004    | armv7k | 0        |
| Watch3,2      | n111bap | Apple Watch Series 3 (GPS + Cellular) 42mm | t8004    | armv7k | 0        |
| Watch3,3      | n121sap | Apple Watch Series 3 (GPS) 38mm            | t8004    | armv7k | 0        |
| Watch3,4      | n121bap | Apple Watch Series 3 (GPS) 42mm            | t8004    | armv7k | 0        |
| Watch4,1      | n131sap | Apple Watch Series 4                       | t8006    | arm64e | 1        |
| Watch4,2      | n131bap | Apple Watch Series 4                       | t8006    | arm64e | 1        |
| Watch4,3      | n141sap | Apple Watch Series 4                       | t8006    | arm64e | 1        |
| Watch4,4      | n141bap | Apple Watch Series 4                       | t8006    | arm64e | 1        |
| Watch5,1      | n144sap | Apple Watch Series 5                       | t8006    | arm64e | 1        |
| Watch5,2      | n144bap | Apple Watch Series 5                       | t8006    | arm64e | 1        |
| Watch5,3      | n146sap | Apple Watch Series 5                       | t8006    | arm64e | 1        |
| Watch5,4      | n146bap | Apple Watch Series 5                       | t8006    | arm64e | 1        |
| Watch5,9      | n140sap | Apple Watch SE (GPS)                       | t8006    | arm64e | 1        |
| Watch5,10     | n140bap | Apple Watch SE (GPS)                       | t8006    | arm64e | 1        |
| Watch5,11     | n142sap | Apple Watch SE (GPS + Cellular)            | t8006    | arm64e | 1        |
| Watch5,12     | n142bap | Apple Watch SE (GPS + Cellular)            | t8006    | arm64e | 1        |
| Watch6,1      | n157sap | Apple Watch Series 6 (GPS)                 | t8301    | arm64e | 15       |
| Watch6,2      | n157bap | Apple Watch Series 6 (GPS)                 | t8301    | arm64e | 15       |
| Watch6,3      | n158sap | Apple Watch Series 6 (GPS + Cellular)      | t8301    | arm64e | 15       |
| Watch6,4      | n158bap | Apple Watch Series 6 (GPS + Cellular)      | t8301    | arm64e | 15       |
| Watch6,6      | n187sap | Apple Watch Series 7 (GPS)                 | t8301    | arm64e | 15       |
| Watch6,7      | n187bap | Apple Watch Series 7 (GPS)                 | t8301    | arm64e | 15       |
| Watch6,8      | n188sap | Apple Watch Series 7 (GPS + Cellular)      | t8301    | arm64e | 15       |
| Watch6,9      | n188bap | Apple Watch Series 7 (GPS + Cellular)      | t8301    | arm64e | 15       |
| Watch6,10     | n143sap | Apple Watch SE (GPS)                       | t8301    | arm64e | 15       |
| Watch6,11     | n143bap | Apple Watch SE (GPS)                       | t8301    | arm64e | 15       |
| Watch6,12     | n149sap | Apple Watch SE (GPS + Cellular)            | t8301    | arm64e | 15       |
| Watch6,13     | n149bap | Apple Watch SE (GPS + Cellular)            | t8301    | arm64e | 15       |
| Watch6,14     | n197sap | Apple Watch Series 8 (GPS)                 | t8301    | arm64e | 15       |
| Watch6,15     | n197bap | Apple Watch Series 8 (GPS)                 | t8301    | arm64e | 15       |
| Watch6,16     | n198sap | Apple Watch Series 8 (GPS + Cellular)      | t8301    | arm64e | 15       |
| Watch6,17     | n198bap | Apple Watch Series 8 (GPS + Cellular)      | t8301    | arm64e | 15       |
| Watch6,18     | n199ap  | Apple Watch Ultra                          | t8301    | arm64e | 15       |
| iPad2,1       | k93ap   | iPad 2                                     | s5l8940x | armv7  | 0        |
| iPad2,2       | k94ap   | iPad 2                                     | s5l8940x | armv7  | 0        |
| iPad2,3       | k95ap   | iPad 2                                     | s5l8940x | armv7  | 0        |
| iPad2,4       | k93aap  | iPad 2                                     | s5l8942x | armv7  | 0        |
| iPad2,5       | p105ap  | iPad mini                                  | s5l8942x | armv7  | 0        |
| iPad2,6       | p106ap  | iPad mini                                  | s5l8942x | armv7  | 0        |
| iPad2,7       | p107ap  | iPad mini                                  | s5l8942x | armv7  | 0        |
| iPad3,1       | j1ap    | iPad (3rd gen)                             | s5l8945x | armv7  | 1        |
| iPad3,2       | j2ap    | iPad (3rd gen)                             | s5l8945x | armv7  | 1        |
| iPad3,3       | j2aap   | iPad (3rd gen)                             | s5l8945x | armv7  | 1        |
| iPad3,4       | p101ap  | iPad (4th gen)                             | s5l8955x | armv7s | 1        |
| iPad3,5       | p102ap  | iPad (4th gen)                             | s5l8955x | armv7s | 1        |
| iPad3,6       | p103ap  | iPad (4th gen)                             | s5l8955x | armv7s | 1        |
| iPad4,1       | j71ap   | iPad Air                                   | s5l8960x | arm64  | 1        |
| iPad4,2       | j72ap   | iPad Air                                   | s5l8960x | arm64  | 1        |
| iPad4,3       | j73ap   | iPad Air                                   | s5l8960x | arm64  | 1        |
| iPad4,4       | j85ap   | iPad mini 2                                | s5l8960x | arm64  | 1        |
| iPad4,5       | j86ap   | iPad mini 2                                | s5l8960x | arm64  | 1        |
| iPad4,6       | j87ap   | iPad mini 2                                | s5l8960x | arm64  | 1        |
| iPad4,7       | j85map  | iPad mini 3                                | s5l8960x | arm64  | 1        |
| iPad4,8       | j86map  | iPad mini 3                                | s5l8960x | arm64  | 1        |
| iPad4,9       | j87map  | iPad mini 3                                | s5l8960x | arm64  | 1        |
| iPad5,1       | j96ap   | iPad mini 4                                | t7000    | arm64  | 2        |
| iPad5,2       | j97ap   | iPad mini 4                                | t7000    | arm64  | 2        |
| iPad5,3       | j81ap   | iPad Air 2                                 | t7001    | arm64  | 2        |
| iPad5,4       | j82ap   | iPad Air 2                                 | t7001    | arm64  | 2        |
| iPad6,3       | j127ap  | iPad Pro (9.7-inch)                        | s8001    | arm64  | 2        |
| iPad6,4       | j128ap  | iPad Pro (9.7-inch)                        | s8001    | arm64  | 2        |
| iPad6,7       | j98aap  | iPad Pro (12.9-inch)                       | s8001    | arm64  | 3        |
| iPad6,8       | j99aap  | iPad Pro (12.9-inch)                       | s8001    | arm64  | 3        |
| iPad6,11      | j71sap  | iPad (5th gen)                             | s8000    | arm64  | 2        |
| iPad6,11      | j71tap  | iPad (5th gen)                             | s8003    | arm64  | 2        |
| iPad6,12      | j72tap  | iPad (5th gen)                             | s8003    | arm64  | 2        |
| iPad6,12      | j72sap  | iPad (5th gen)                             | s8000    | arm64  | 2        |
| iPad7,1       | j120ap  | iPad Pro (12.9-inch) (2nd gen)             | t8011    | arm64  | 3        |
| iPad7,2       | j121ap  | iPad Pro (12.9-inch) (2nd gen)             | t8011    | arm64  | 3        |
| iPad7,3       | j207ap  | iPad Pro (10.5-inch)                       | t8011    | arm64  | 3        |
| iPad7,4       | j208ap  | iPad Pro (10.5-inch)                       | t8011    | arm64  | 3        |
| iPad7,5       | j71bap  | iPad (6th gen)                             | t8010    | arm64  | 2        |
| iPad7,6       | j72bap  | iPad (6th gen)                             | t8010    | arm64  | 2        |
| iPad7,11      | j171ap  | iPad (7th gen)                             | t8010    | arm64  | 4        |
| iPad7,12      | j172ap  | iPad (7th gen)                             | t8010    | arm64  | 4        |
| iPad8,1       | j317ap  | iPad Pro (11-inch)                         | t8027    | arm64e | 3        |
| iPad8,2       | j317xap | iPad Pro (11-inch)                         | t8027    | arm64e | 6        |
| iPad8,3       | j318ap  | iPad Pro (11-inch)                         | t8027    | arm64e | 3        |
| iPad8,4       | j318xap | iPad Pro (11-inch)                         | t8027    | arm64e | 6        |
| iPad8,5       | j320ap  | iPad Pro (12.9-inch) (3rd gen)             | t8027    | arm64e | 3        |
| iPad8,6       | j320xap | iPad Pro (12.9-inch) (3rd gen)             | t8027    | arm64e | 6        |
| iPad8,7       | j321ap  | iPad Pro (12.9-inch) (3rd gen)             | t8027    | arm64e | 3        |
| iPad8,8       | j321xap | iPad Pro (12.9-inch) (3rd gen)             | t8027    | arm64e | 6        |
| iPad8,9       | j417ap  | iPad Pro (11-inch) (2nd gen)               | t8027    | arm64e | 6        |
| iPad8,10      | j418ap  | iPad Pro (11-inch) (2nd gen)               | t8027    | arm64e | 6        |
| iPad8,11      | j420ap  | iPad Pro (12.9-inch) (4th gen)             | t8027    | arm64e | 6        |
| iPad8,12      | j421ap  | iPad Pro (12.9-inch) (4th gen)             | t8027    | arm64e | 6        |
| iPad11,1      | j210ap  | iPad mini (5th gen)                        | t8020    | arm64e | 4        |
| iPad11,2      | j211ap  | iPad mini (5th gen)                        | t8020    | arm64e | 4        |
| iPad11,3      | j217ap  | iPad Air (3rd gen)                         | t8020    | arm64e | 4        |
| iPad11,4      | j218ap  | iPad Air (3rd gen)                         | t8020    | arm64e | 4        |
| iPad11,6      | j171aap | iPad (8th gen)                             | t8020    | arm64e | 4        |
| iPad11,7      | j172aap | iPad (8th gen)                             | t8020    | arm64e | 4        |
| iPad12,1      | j181ap  | iPad (9th gen)                             | t8030    | arm64e | 4        |
| iPad12,2      | j182ap  | iPad (9th gen)                             | t8030    | arm64e | 4        |
| iPad13,1      | j307ap  | iPad Air (4th gen)                         | t8101    | arm64e | 3        |
| iPad13,2      | j308ap  | iPad Air (4th gen)                         | t8101    | arm64e | 3        |
| iPad13,4      | j517ap  | iPad Pro (11-inch) (3rd gen)               | t8103    | arm64e | 8        |
| iPad13,5      | j517xap | iPad Pro (11-inch) (3rd gen)               | t8103    | arm64e | 16       |
| iPad13,6      | j518ap  | iPad Pro (11-inch) (3rd gen)               | t8103    | arm64e | 8        |
| iPad13,7      | j518xap | iPad Pro (11-inch) (3rd gen)               | t8103    | arm64e | 16       |
| iPad13,8      | j522ap  | iPad Pro (12.9-inch) (5th gen)             | t8103    | arm64e | 8        |
| iPad13,9      | j522xap | iPad Pro (12.9-inch) (5th gen)             | t8103    | arm64e | 16       |
| iPad13,10     | j523ap  | iPad Pro (12.9-inch) (5th gen)             | t8103    | arm64e | 8        |
| iPad13,11     | j523xap | iPad Pro (12.9-inch) (5th gen)             | t8103    | arm64e | 16       |
| iPad13,16     | j407ap  | iPad Air (5th gen)                         | t8103    | arm64e | 8        |
| iPad13,17     | j408ap  | iPad Air (5th gen)                         | t8103    | arm64e | 8        |
| iPad13,18     | j271ap  | iPad (10th gen)                            | t8101    | arm64e | 3        |
| iPad13,19     | j272ap  | iPad (10th gen)                            | t8101    | arm64e | 3        |
| iPad14,1      | j310ap  | iPad mini (6th gen)                        | t8110    | arm64e | 3        |
| iPad14,2      | j311ap  | iPad mini (6th gen)                        | t8110    | arm64e | 3        |
| iPad14,3      | j617ap  | iPad Pro (11-inch) (4th gen)               | t8112    | arm64e | 8        |
| iPad14,4      | j618ap  | iPad Pro (11-inch) (4th gen)               | t8112    | arm64e | 8        |
| iPad14,5      | j620ap  | iPad Pro (12.9-inch) (6th gen)             | t8112    | arm64e | 8        |
| iPad14,6      | j621ap  | iPad Pro (12.9-inch) (6th gen)             | t8112    | arm64e | 8        |
| iPhone4,1     | n94ap   | iPhone 4S                                  | s5l8940x | armv7  | 0        |
| iPhone5,1     | n41ap   | iPhone 5                                   | s5l8950x | armv7s | 1        |
| iPhone5,2     | n42ap   | iPhone 5                                   | s5l8950x | armv7s | 1        |
| iPhone5,3     | n48ap   | iPhone 5c                                  | s5l8950x | armv7s | 1        |
| iPhone5,4     | n49ap   | iPhone 5c                                  | s5l8950x | armv7s | 1        |
| iPhone6,1     | n51ap   | iPhone 5s                                  | s5l8960x | arm64  | 1        |
| iPhone6,2     | n53ap   | iPhone 5s                                  | s5l8960x | arm64  | 1        |
| iPhone7,1     | n56ap   | iPhone 6 Plus                              | t7000    | arm64  | 1        |
| iPhone7,2     | n61ap   | iPhone 6                                   | t7000    | arm64  | 1        |
| iPhone8,1     | n71ap   | iPhone 6s                                  | s8000    | arm64  | 2        |
| iPhone8,1     | n71map  | iPhone 6s                                  | s8003    | arm64  | 2        |
| iPhone8,2     | n66ap   | iPhone 6s Plus                             | s8000    | arm64  | 2        |
| iPhone8,2     | n66map  | iPhone 6s Plus                             | s8003    | arm64  | 2        |
| iPhone8,4     | n69ap   | iPhone SE (1st gen)                        | s8003    | arm64  | 2        |
| iPhone8,4     | n69uap  | iPhone SE (1st gen)                        | s8000    | arm64  | 2        |
| iPhone9,1     | d10ap   | iPhone 7                                   | t8010    | arm64  | 2        |
| iPhone9,2     | d11ap   | iPhone 7 Plus                              | t8010    | arm64  | 4        |
| iPhone9,3     | d101ap  | iPhone 7                                   | t8010    | arm64  | 2        |
| iPhone9,4     | d111ap  | iPhone 7 Plus                              | t8010    | arm64  | 4        |
| iPhone10,1    | d20ap   | iPhone 8                                   | t8015    | arm64  | 2        |
| iPhone10,2    | d21ap   | iPhone 8 Plus                              | t8015    | arm64  | 4        |
| iPhone10,3    | d22ap   | iPhone X                                   | t8015    | arm64  | 4        |
| iPhone10,4    | d201ap  | iPhone 8                                   | t8015    | arm64  | 2        |
| iPhone10,5    | d211ap  | iPhone 8 Plus                              | t8015    | arm64  | 4        |
| iPhone10,6    | d221ap  | iPhone X                                   | t8015    | arm64  | 4        |
| iPhone11,2    | d321ap  | iPhone XS                                  | t8020    | arm64e | 3        |
| iPhone11,4    | d331ap  | iPhone XS Max                              | t8020    | arm64e | 3        |
| iPhone11,6    | d331pap | iPhone XS Max                              | t8020    | arm64e | 3        |
| iPhone11,8    | n841ap  | iPhone XR                                  | t8020    | arm64e | 4        |
| iPhone12,1    | n104ap  | iPhone 11                                  | t8030    | arm64e | 3        |
| iPhone12,3    | d421ap  | iPhone 11 Pro                              | t8030    | arm64e | 3        |
| iPhone12,5    | d431ap  | iPhone 11 Pro Max                          | t8030    | arm64e | 3        |
| iPhone12,8    | d79ap   | iPhone SE (2nd gen)                        | t8030    | arm64e | 4        |
| iPhone13,1    | d52gap  | iPhone 12 mini                             | t8101    | arm64e | 3        |
| iPhone13,2    | d53gap  | iPhone 12                                  | t8101    | arm64e | 3        |
| iPhone13,3    | d53pap  | iPhone 12 Pro                              | t8101    | arm64e | 6        |
| iPhone13,4    | d54pap  | iPhone 12 Pro Max                          | t8101    | arm64e | 6        |
| iPhone14,2    | d63ap   | iPhone 13 Pro                              | t8110    | arm64e | 6        |
| iPhone14,3    | d64ap   | iPhone 13 Pro Max                          | t8110    | arm64e | 6        |
| iPhone14,4    | d16ap   | iPhone 13 mini                             | t8110    | arm64e | 3        |
| iPhone14,5    | d17ap   | iPhone 13                                  | t8110    | arm64e | 3        |
| iPhone14,6    | d49ap   | iPhone SE (3rd gen)                        | t8110    | arm64e | 3        |
| iPhone14,7    | d27ap   | iPhone 14                                  | t8110    | arm64e | 6        |
| iPhone14,8    | d28ap   | iPhone 14 Plus                             | t8110    | arm64e | 6        |
| iPhone15,2    | d73ap   | iPhone 14 Pro                              | t8120    | arm64e | 6        |
| iPhone15,3    | d74ap   | iPhone 14 Pro Max                          | t8120    | arm64e | 6        |
| iPod5,1       | n78ap   | iPod touch                                 | s5l8942x | armv7  | 0        |
| iPod7,1       | n102ap  | iPod touch (6th gen)                       | t7000    | arm64  | 1        |
| iPod9,1       | n112ap  | iPod touch (7th gen)                       | t8010    | arm64  | 2        |

