## Release notes for kOps 1.33 series

kOps 1.33.0 introduces significant improvements to cloud provider support, networking capabilities, and Kubernetes integration. This release adds new features for AWS ECR, Hetzner Cloud, and Cilium while removing deprecated legacy components.

# Significant changes

## New Features

### AWS ECR Pull-Through Cache Support
* Add support for using ECR as pull-through image cache ([#16593](https://github.com/kubernetes/kops/pull/16593))
  - Enables faster container image pulls by caching images in ECR
  - Reduces external registry dependencies and improves reliability

### Hetzner Cloud Object Storage
* Add support for Object Storage ([#17453](https://github.com/kubernetes/kops/pull/17453))
  - Enables state store configuration using Hetzner Cloud Object Storage
  - Provides alternative to S3 for Hetzner Cloud users

### Cilium Gateway API Support
* Add support for Gateway API within Cilium ([#17358](https://github.com/kubernetes/kops/pull/17358))
  - Enables modern Kubernetes networking with Gateway API
  - Provides advanced traffic management capabilities

## Cloud Provider Improvements

### Kubernetes 1.33 Cloud Provider Changes
* Remove cloud-config and cloud-provider flags from kubelet and kube-apiserver for Kubernetes 1.33+ ([#17412](https://github.com/kubernetes/kops/pull/17412), [#17270](https://github.com/kubernetes/kops/pull/17270))
  - Aligns with Kubernetes deprecation of in-tree cloud providers
  - Mandatory for Kubernetes 1.33+ compatibility

### Azure Enhancements
* Deploy cloud-node-manager for Kubernetes 1.31+
  - Ensures proper node management for newer Kubernetes versions
  - Improves Azure cloud integration

### GCP Updates
* Do not reset MIG target size on cluster updates
  - Prevents unwanted scaling during cluster operations
  - Improves autoscaler compatibility

## Container Runtime and Component Updates

### Major Version Updates
* Update Cilium to v1.16.7
* Update Calico to v3.29.4
* Update CoreDNS to v1.11.4
* Update containerd to v1.7.28
* Update etcd to v3.5.21
* Update etcd-manager to v3.0.20250803
* Update metrics-server to v0.7.2
* Update flannel to v0.26.4
* Update kube-router from v2.1.1 to v2.5.0
* Update Amazon VPC CNI to v1.19.3

### Flannel Support Restored
* Re-enable Flannel and remove deprecation notice
  - Flannel continues to be supported as a networking option
  - Updates documentation to reflect continued support

# Breaking changes

## Legacy Addon Removal
* Remove legacy addons from kOps repository ([#17332](https://github.com/kubernetes/kops/pull/17332))
  - Only affects clusters using kOps versions prior to 1.22
  - Modern clusters using managed addons are unaffected

## Cloud Provider Flag Removal
* Remove cloud-config and cloud-provider flags for Kubernetes 1.33+
  - **Breaking change** for clusters upgrading to Kubernetes 1.33
  - External cloud providers must be configured separately
  - Ensures compliance with Kubernetes 1.33 requirements

# Other notable changes

## Networking Enhancements
* Add CNI-exclusive setting for Cilium
* Allow setup of CoreDNS pod annotations ([#17315](https://github.com/kubernetes/kops/pull/17315))
* Prevent systemd-networkd from removing Cilium routes on restart
* Support systemd config on Ubuntu 22.04+ for Amazon VPC CNI

## Security and Configuration
* Use official etcd images from registry.k8s.io
* Increase key size for KubeConfig private key
* Enable more admission controllers by default
* Add goaway-chance parameter for kube-apiserver

## Testing and Infrastructure
* Use ephemeral S3 buckets for E2E tests ([#17157](https://github.com/kubernetes/kops/pull/17157))
  - Improves test isolation and cleanup
  - Reduces testing infrastructure costs

## OpenStack Support
* Fix: determine ports to delete based on tags
  - Improves resource cleanup accuracy
  - Prevents deletion of unmanaged ports

# Known Issues

* None at this time

# Deprecations

* Support for Kubernetes version 1.27 is removed in kOps 1.33
* Support for Kubernetes version 1.28 is deprecated and will be removed in kOps 1.34

# Installation and Upgrade Notes

## Kubernetes 1.33 Upgrade Requirements
* **Important**: Clusters upgrading to Kubernetes 1.33 must use external cloud providers
* The cloud-config and cloud-provider flags are no longer supported in Kubernetes 1.33
* Plan your upgrade carefully and test in non-production environments first

## Recommended Upgrade Process
* Use the `kops reconcile cluster` command for Kubernetes minor version upgrades
* Review breaking changes before upgrading production clusters
* Ensure proper testing of cloud provider configuration changes

---

This release includes contributions from the kOps community. Thank you to all contributors who made this release possible!
