/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha3

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	kopsv1alpha3 "k8s.io/kops/pkg/apis/kops/v1alpha3"
	scheme "k8s.io/kops/pkg/client/clientset_generated/clientset/scheme"
)

// ClustersGetter has a method to return a ClusterInterface.
// A group's client should implement this interface.
type ClustersGetter interface {
	Clusters(namespace string) ClusterInterface
}

// ClusterInterface has methods to work with Cluster resources.
type ClusterInterface interface {
	Create(ctx context.Context, cluster *kopsv1alpha3.Cluster, opts v1.CreateOptions) (*kopsv1alpha3.Cluster, error)
	Update(ctx context.Context, cluster *kopsv1alpha3.Cluster, opts v1.UpdateOptions) (*kopsv1alpha3.Cluster, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kopsv1alpha3.Cluster, error)
	List(ctx context.Context, opts v1.ListOptions) (*kopsv1alpha3.ClusterList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kopsv1alpha3.Cluster, err error)
	ClusterExpansion
}

// clusters implements ClusterInterface
type clusters struct {
	*gentype.ClientWithList[*kopsv1alpha3.Cluster, *kopsv1alpha3.ClusterList]
}

// newClusters returns a Clusters
func newClusters(c *KopsV1alpha3Client, namespace string) *clusters {
	return &clusters{
		gentype.NewClientWithList[*kopsv1alpha3.Cluster, *kopsv1alpha3.ClusterList](
			"clusters",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kopsv1alpha3.Cluster { return &kopsv1alpha3.Cluster{} },
			func() *kopsv1alpha3.ClusterList { return &kopsv1alpha3.ClusterList{} },
		),
	}
}
