/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	internalversion "k8s.io/kops/pkg/client/clientset_generated/internalclientset/typed/kops/internalversion"
)

// fakeClusters implements ClusterInterface
type fakeClusters struct {
	*gentype.FakeClientWithList[*kops.Cluster, *kops.ClusterList]
	Fake *FakeKops
}

func newFakeClusters(fake *FakeKops, namespace string) internalversion.ClusterInterface {
	return &fakeClusters{
		gentype.NewFakeClientWithList[*kops.Cluster, *kops.ClusterList](
			fake.Fake,
			namespace,
			kops.SchemeGroupVersion.WithResource("clusters"),
			kops.SchemeGroupVersion.WithKind("Cluster"),
			func() *kops.Cluster { return &kops.Cluster{} },
			func() *kops.ClusterList { return &kops.ClusterList{} },
			func(dst, src *kops.ClusterList) { dst.ListMeta = src.ListMeta },
			func(list *kops.ClusterList) []*kops.Cluster { return gentype.ToPointerSlice(list.Items) },
			func(list *kops.ClusterList, items []*kops.Cluster) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
