//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1beta1

import (
	unsafe "unsafe"

	certificatesv1beta1 "k8s.io/api/certificates/v1beta1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	certificates "k8s.io/kubernetes/pkg/apis/certificates"
	core "k8s.io/kubernetes/pkg/apis/core"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.CertificateSigningRequest)(nil), (*certificates.CertificateSigningRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CertificateSigningRequest_To_certificates_CertificateSigningRequest(a.(*certificatesv1beta1.CertificateSigningRequest), b.(*certificates.CertificateSigningRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.CertificateSigningRequest)(nil), (*certificatesv1beta1.CertificateSigningRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_CertificateSigningRequest_To_v1beta1_CertificateSigningRequest(a.(*certificates.CertificateSigningRequest), b.(*certificatesv1beta1.CertificateSigningRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.CertificateSigningRequestCondition)(nil), (*certificates.CertificateSigningRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CertificateSigningRequestCondition_To_certificates_CertificateSigningRequestCondition(a.(*certificatesv1beta1.CertificateSigningRequestCondition), b.(*certificates.CertificateSigningRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.CertificateSigningRequestCondition)(nil), (*certificatesv1beta1.CertificateSigningRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_CertificateSigningRequestCondition_To_v1beta1_CertificateSigningRequestCondition(a.(*certificates.CertificateSigningRequestCondition), b.(*certificatesv1beta1.CertificateSigningRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.CertificateSigningRequestList)(nil), (*certificates.CertificateSigningRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CertificateSigningRequestList_To_certificates_CertificateSigningRequestList(a.(*certificatesv1beta1.CertificateSigningRequestList), b.(*certificates.CertificateSigningRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.CertificateSigningRequestList)(nil), (*certificatesv1beta1.CertificateSigningRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_CertificateSigningRequestList_To_v1beta1_CertificateSigningRequestList(a.(*certificates.CertificateSigningRequestList), b.(*certificatesv1beta1.CertificateSigningRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.CertificateSigningRequestSpec)(nil), (*certificates.CertificateSigningRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CertificateSigningRequestSpec_To_certificates_CertificateSigningRequestSpec(a.(*certificatesv1beta1.CertificateSigningRequestSpec), b.(*certificates.CertificateSigningRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.CertificateSigningRequestSpec)(nil), (*certificatesv1beta1.CertificateSigningRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_CertificateSigningRequestSpec_To_v1beta1_CertificateSigningRequestSpec(a.(*certificates.CertificateSigningRequestSpec), b.(*certificatesv1beta1.CertificateSigningRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.CertificateSigningRequestStatus)(nil), (*certificates.CertificateSigningRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_CertificateSigningRequestStatus_To_certificates_CertificateSigningRequestStatus(a.(*certificatesv1beta1.CertificateSigningRequestStatus), b.(*certificates.CertificateSigningRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.CertificateSigningRequestStatus)(nil), (*certificatesv1beta1.CertificateSigningRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_CertificateSigningRequestStatus_To_v1beta1_CertificateSigningRequestStatus(a.(*certificates.CertificateSigningRequestStatus), b.(*certificatesv1beta1.CertificateSigningRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.ClusterTrustBundle)(nil), (*certificates.ClusterTrustBundle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(a.(*certificatesv1beta1.ClusterTrustBundle), b.(*certificates.ClusterTrustBundle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.ClusterTrustBundle)(nil), (*certificatesv1beta1.ClusterTrustBundle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_ClusterTrustBundle_To_v1beta1_ClusterTrustBundle(a.(*certificates.ClusterTrustBundle), b.(*certificatesv1beta1.ClusterTrustBundle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.ClusterTrustBundleList)(nil), (*certificates.ClusterTrustBundleList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(a.(*certificatesv1beta1.ClusterTrustBundleList), b.(*certificates.ClusterTrustBundleList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.ClusterTrustBundleList)(nil), (*certificatesv1beta1.ClusterTrustBundleList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_ClusterTrustBundleList_To_v1beta1_ClusterTrustBundleList(a.(*certificates.ClusterTrustBundleList), b.(*certificatesv1beta1.ClusterTrustBundleList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.ClusterTrustBundleSpec)(nil), (*certificates.ClusterTrustBundleSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(a.(*certificatesv1beta1.ClusterTrustBundleSpec), b.(*certificates.ClusterTrustBundleSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.ClusterTrustBundleSpec)(nil), (*certificatesv1beta1.ClusterTrustBundleSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_ClusterTrustBundleSpec_To_v1beta1_ClusterTrustBundleSpec(a.(*certificates.ClusterTrustBundleSpec), b.(*certificatesv1beta1.ClusterTrustBundleSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.PodCertificateRequest)(nil), (*certificates.PodCertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_PodCertificateRequest_To_certificates_PodCertificateRequest(a.(*certificatesv1beta1.PodCertificateRequest), b.(*certificates.PodCertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequest)(nil), (*certificatesv1beta1.PodCertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequest_To_v1beta1_PodCertificateRequest(a.(*certificates.PodCertificateRequest), b.(*certificatesv1beta1.PodCertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.PodCertificateRequestList)(nil), (*certificates.PodCertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(a.(*certificatesv1beta1.PodCertificateRequestList), b.(*certificates.PodCertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequestList)(nil), (*certificatesv1beta1.PodCertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequestList_To_v1beta1_PodCertificateRequestList(a.(*certificates.PodCertificateRequestList), b.(*certificatesv1beta1.PodCertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.PodCertificateRequestSpec)(nil), (*certificates.PodCertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(a.(*certificatesv1beta1.PodCertificateRequestSpec), b.(*certificates.PodCertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequestSpec)(nil), (*certificatesv1beta1.PodCertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequestSpec_To_v1beta1_PodCertificateRequestSpec(a.(*certificates.PodCertificateRequestSpec), b.(*certificatesv1beta1.PodCertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1beta1.PodCertificateRequestStatus)(nil), (*certificates.PodCertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(a.(*certificatesv1beta1.PodCertificateRequestStatus), b.(*certificates.PodCertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequestStatus)(nil), (*certificatesv1beta1.PodCertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequestStatus_To_v1beta1_PodCertificateRequestStatus(a.(*certificates.PodCertificateRequestStatus), b.(*certificatesv1beta1.PodCertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1beta1_CertificateSigningRequest_To_certificates_CertificateSigningRequest(in *certificatesv1beta1.CertificateSigningRequest, out *certificates.CertificateSigningRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_CertificateSigningRequestSpec_To_certificates_CertificateSigningRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_CertificateSigningRequestStatus_To_certificates_CertificateSigningRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_CertificateSigningRequest_To_certificates_CertificateSigningRequest is an autogenerated conversion function.
func Convert_v1beta1_CertificateSigningRequest_To_certificates_CertificateSigningRequest(in *certificatesv1beta1.CertificateSigningRequest, out *certificates.CertificateSigningRequest, s conversion.Scope) error {
	return autoConvert_v1beta1_CertificateSigningRequest_To_certificates_CertificateSigningRequest(in, out, s)
}

func autoConvert_certificates_CertificateSigningRequest_To_v1beta1_CertificateSigningRequest(in *certificates.CertificateSigningRequest, out *certificatesv1beta1.CertificateSigningRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certificates_CertificateSigningRequestSpec_To_v1beta1_CertificateSigningRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certificates_CertificateSigningRequestStatus_To_v1beta1_CertificateSigningRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certificates_CertificateSigningRequest_To_v1beta1_CertificateSigningRequest is an autogenerated conversion function.
func Convert_certificates_CertificateSigningRequest_To_v1beta1_CertificateSigningRequest(in *certificates.CertificateSigningRequest, out *certificatesv1beta1.CertificateSigningRequest, s conversion.Scope) error {
	return autoConvert_certificates_CertificateSigningRequest_To_v1beta1_CertificateSigningRequest(in, out, s)
}

func autoConvert_v1beta1_CertificateSigningRequestCondition_To_certificates_CertificateSigningRequestCondition(in *certificatesv1beta1.CertificateSigningRequestCondition, out *certificates.CertificateSigningRequestCondition, s conversion.Scope) error {
	out.Type = certificates.RequestConditionType(in.Type)
	out.Status = core.ConditionStatus(in.Status)
	out.Reason = in.Reason
	out.Message = in.Message
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	return nil
}

// Convert_v1beta1_CertificateSigningRequestCondition_To_certificates_CertificateSigningRequestCondition is an autogenerated conversion function.
func Convert_v1beta1_CertificateSigningRequestCondition_To_certificates_CertificateSigningRequestCondition(in *certificatesv1beta1.CertificateSigningRequestCondition, out *certificates.CertificateSigningRequestCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_CertificateSigningRequestCondition_To_certificates_CertificateSigningRequestCondition(in, out, s)
}

func autoConvert_certificates_CertificateSigningRequestCondition_To_v1beta1_CertificateSigningRequestCondition(in *certificates.CertificateSigningRequestCondition, out *certificatesv1beta1.CertificateSigningRequestCondition, s conversion.Scope) error {
	out.Type = certificatesv1beta1.RequestConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Reason = in.Reason
	out.Message = in.Message
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	return nil
}

// Convert_certificates_CertificateSigningRequestCondition_To_v1beta1_CertificateSigningRequestCondition is an autogenerated conversion function.
func Convert_certificates_CertificateSigningRequestCondition_To_v1beta1_CertificateSigningRequestCondition(in *certificates.CertificateSigningRequestCondition, out *certificatesv1beta1.CertificateSigningRequestCondition, s conversion.Scope) error {
	return autoConvert_certificates_CertificateSigningRequestCondition_To_v1beta1_CertificateSigningRequestCondition(in, out, s)
}

func autoConvert_v1beta1_CertificateSigningRequestList_To_certificates_CertificateSigningRequestList(in *certificatesv1beta1.CertificateSigningRequestList, out *certificates.CertificateSigningRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certificates.CertificateSigningRequest, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_CertificateSigningRequest_To_certificates_CertificateSigningRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_CertificateSigningRequestList_To_certificates_CertificateSigningRequestList is an autogenerated conversion function.
func Convert_v1beta1_CertificateSigningRequestList_To_certificates_CertificateSigningRequestList(in *certificatesv1beta1.CertificateSigningRequestList, out *certificates.CertificateSigningRequestList, s conversion.Scope) error {
	return autoConvert_v1beta1_CertificateSigningRequestList_To_certificates_CertificateSigningRequestList(in, out, s)
}

func autoConvert_certificates_CertificateSigningRequestList_To_v1beta1_CertificateSigningRequestList(in *certificates.CertificateSigningRequestList, out *certificatesv1beta1.CertificateSigningRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certificatesv1beta1.CertificateSigningRequest, len(*in))
		for i := range *in {
			if err := Convert_certificates_CertificateSigningRequest_To_v1beta1_CertificateSigningRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certificates_CertificateSigningRequestList_To_v1beta1_CertificateSigningRequestList is an autogenerated conversion function.
func Convert_certificates_CertificateSigningRequestList_To_v1beta1_CertificateSigningRequestList(in *certificates.CertificateSigningRequestList, out *certificatesv1beta1.CertificateSigningRequestList, s conversion.Scope) error {
	return autoConvert_certificates_CertificateSigningRequestList_To_v1beta1_CertificateSigningRequestList(in, out, s)
}

func autoConvert_v1beta1_CertificateSigningRequestSpec_To_certificates_CertificateSigningRequestSpec(in *certificatesv1beta1.CertificateSigningRequestSpec, out *certificates.CertificateSigningRequestSpec, s conversion.Scope) error {
	out.Request = *(*[]byte)(unsafe.Pointer(&in.Request))
	if err := metav1.Convert_Pointer_string_To_string(&in.SignerName, &out.SignerName, s); err != nil {
		return err
	}
	out.ExpirationSeconds = (*int32)(unsafe.Pointer(in.ExpirationSeconds))
	out.Usages = *(*[]certificates.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.Username = in.Username
	out.UID = in.UID
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Extra = *(*map[string]certificates.ExtraValue)(unsafe.Pointer(&in.Extra))
	return nil
}

// Convert_v1beta1_CertificateSigningRequestSpec_To_certificates_CertificateSigningRequestSpec is an autogenerated conversion function.
func Convert_v1beta1_CertificateSigningRequestSpec_To_certificates_CertificateSigningRequestSpec(in *certificatesv1beta1.CertificateSigningRequestSpec, out *certificates.CertificateSigningRequestSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_CertificateSigningRequestSpec_To_certificates_CertificateSigningRequestSpec(in, out, s)
}

func autoConvert_certificates_CertificateSigningRequestSpec_To_v1beta1_CertificateSigningRequestSpec(in *certificates.CertificateSigningRequestSpec, out *certificatesv1beta1.CertificateSigningRequestSpec, s conversion.Scope) error {
	out.Request = *(*[]byte)(unsafe.Pointer(&in.Request))
	if err := metav1.Convert_string_To_Pointer_string(&in.SignerName, &out.SignerName, s); err != nil {
		return err
	}
	out.ExpirationSeconds = (*int32)(unsafe.Pointer(in.ExpirationSeconds))
	out.Usages = *(*[]certificatesv1beta1.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.Username = in.Username
	out.UID = in.UID
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Extra = *(*map[string]certificatesv1beta1.ExtraValue)(unsafe.Pointer(&in.Extra))
	return nil
}

// Convert_certificates_CertificateSigningRequestSpec_To_v1beta1_CertificateSigningRequestSpec is an autogenerated conversion function.
func Convert_certificates_CertificateSigningRequestSpec_To_v1beta1_CertificateSigningRequestSpec(in *certificates.CertificateSigningRequestSpec, out *certificatesv1beta1.CertificateSigningRequestSpec, s conversion.Scope) error {
	return autoConvert_certificates_CertificateSigningRequestSpec_To_v1beta1_CertificateSigningRequestSpec(in, out, s)
}

func autoConvert_v1beta1_CertificateSigningRequestStatus_To_certificates_CertificateSigningRequestStatus(in *certificatesv1beta1.CertificateSigningRequestStatus, out *certificates.CertificateSigningRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certificates.CertificateSigningRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	return nil
}

// Convert_v1beta1_CertificateSigningRequestStatus_To_certificates_CertificateSigningRequestStatus is an autogenerated conversion function.
func Convert_v1beta1_CertificateSigningRequestStatus_To_certificates_CertificateSigningRequestStatus(in *certificatesv1beta1.CertificateSigningRequestStatus, out *certificates.CertificateSigningRequestStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_CertificateSigningRequestStatus_To_certificates_CertificateSigningRequestStatus(in, out, s)
}

func autoConvert_certificates_CertificateSigningRequestStatus_To_v1beta1_CertificateSigningRequestStatus(in *certificates.CertificateSigningRequestStatus, out *certificatesv1beta1.CertificateSigningRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certificatesv1beta1.CertificateSigningRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	return nil
}

// Convert_certificates_CertificateSigningRequestStatus_To_v1beta1_CertificateSigningRequestStatus is an autogenerated conversion function.
func Convert_certificates_CertificateSigningRequestStatus_To_v1beta1_CertificateSigningRequestStatus(in *certificates.CertificateSigningRequestStatus, out *certificatesv1beta1.CertificateSigningRequestStatus, s conversion.Scope) error {
	return autoConvert_certificates_CertificateSigningRequestStatus_To_v1beta1_CertificateSigningRequestStatus(in, out, s)
}

func autoConvert_v1beta1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(in *certificatesv1beta1.ClusterTrustBundle, out *certificates.ClusterTrustBundle, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ClusterTrustBundle_To_certificates_ClusterTrustBundle is an autogenerated conversion function.
func Convert_v1beta1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(in *certificatesv1beta1.ClusterTrustBundle, out *certificates.ClusterTrustBundle, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(in, out, s)
}

func autoConvert_certificates_ClusterTrustBundle_To_v1beta1_ClusterTrustBundle(in *certificates.ClusterTrustBundle, out *certificatesv1beta1.ClusterTrustBundle, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certificates_ClusterTrustBundleSpec_To_v1beta1_ClusterTrustBundleSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_certificates_ClusterTrustBundle_To_v1beta1_ClusterTrustBundle is an autogenerated conversion function.
func Convert_certificates_ClusterTrustBundle_To_v1beta1_ClusterTrustBundle(in *certificates.ClusterTrustBundle, out *certificatesv1beta1.ClusterTrustBundle, s conversion.Scope) error {
	return autoConvert_certificates_ClusterTrustBundle_To_v1beta1_ClusterTrustBundle(in, out, s)
}

func autoConvert_v1beta1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(in *certificatesv1beta1.ClusterTrustBundleList, out *certificates.ClusterTrustBundleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificates.ClusterTrustBundle)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList is an autogenerated conversion function.
func Convert_v1beta1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(in *certificatesv1beta1.ClusterTrustBundleList, out *certificates.ClusterTrustBundleList, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(in, out, s)
}

func autoConvert_certificates_ClusterTrustBundleList_To_v1beta1_ClusterTrustBundleList(in *certificates.ClusterTrustBundleList, out *certificatesv1beta1.ClusterTrustBundleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificatesv1beta1.ClusterTrustBundle)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_certificates_ClusterTrustBundleList_To_v1beta1_ClusterTrustBundleList is an autogenerated conversion function.
func Convert_certificates_ClusterTrustBundleList_To_v1beta1_ClusterTrustBundleList(in *certificates.ClusterTrustBundleList, out *certificatesv1beta1.ClusterTrustBundleList, s conversion.Scope) error {
	return autoConvert_certificates_ClusterTrustBundleList_To_v1beta1_ClusterTrustBundleList(in, out, s)
}

func autoConvert_v1beta1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(in *certificatesv1beta1.ClusterTrustBundleSpec, out *certificates.ClusterTrustBundleSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.TrustBundle = in.TrustBundle
	return nil
}

// Convert_v1beta1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec is an autogenerated conversion function.
func Convert_v1beta1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(in *certificatesv1beta1.ClusterTrustBundleSpec, out *certificates.ClusterTrustBundleSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(in, out, s)
}

func autoConvert_certificates_ClusterTrustBundleSpec_To_v1beta1_ClusterTrustBundleSpec(in *certificates.ClusterTrustBundleSpec, out *certificatesv1beta1.ClusterTrustBundleSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.TrustBundle = in.TrustBundle
	return nil
}

// Convert_certificates_ClusterTrustBundleSpec_To_v1beta1_ClusterTrustBundleSpec is an autogenerated conversion function.
func Convert_certificates_ClusterTrustBundleSpec_To_v1beta1_ClusterTrustBundleSpec(in *certificates.ClusterTrustBundleSpec, out *certificatesv1beta1.ClusterTrustBundleSpec, s conversion.Scope) error {
	return autoConvert_certificates_ClusterTrustBundleSpec_To_v1beta1_ClusterTrustBundleSpec(in, out, s)
}

func autoConvert_v1beta1_PodCertificateRequest_To_certificates_PodCertificateRequest(in *certificatesv1beta1.PodCertificateRequest, out *certificates.PodCertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_PodCertificateRequest_To_certificates_PodCertificateRequest is an autogenerated conversion function.
func Convert_v1beta1_PodCertificateRequest_To_certificates_PodCertificateRequest(in *certificatesv1beta1.PodCertificateRequest, out *certificates.PodCertificateRequest, s conversion.Scope) error {
	return autoConvert_v1beta1_PodCertificateRequest_To_certificates_PodCertificateRequest(in, out, s)
}

func autoConvert_certificates_PodCertificateRequest_To_v1beta1_PodCertificateRequest(in *certificates.PodCertificateRequest, out *certificatesv1beta1.PodCertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certificates_PodCertificateRequestSpec_To_v1beta1_PodCertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certificates_PodCertificateRequestStatus_To_v1beta1_PodCertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certificates_PodCertificateRequest_To_v1beta1_PodCertificateRequest is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequest_To_v1beta1_PodCertificateRequest(in *certificates.PodCertificateRequest, out *certificatesv1beta1.PodCertificateRequest, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequest_To_v1beta1_PodCertificateRequest(in, out, s)
}

func autoConvert_v1beta1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(in *certificatesv1beta1.PodCertificateRequestList, out *certificates.PodCertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificates.PodCertificateRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_PodCertificateRequestList_To_certificates_PodCertificateRequestList is an autogenerated conversion function.
func Convert_v1beta1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(in *certificatesv1beta1.PodCertificateRequestList, out *certificates.PodCertificateRequestList, s conversion.Scope) error {
	return autoConvert_v1beta1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(in, out, s)
}

func autoConvert_certificates_PodCertificateRequestList_To_v1beta1_PodCertificateRequestList(in *certificates.PodCertificateRequestList, out *certificatesv1beta1.PodCertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificatesv1beta1.PodCertificateRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_certificates_PodCertificateRequestList_To_v1beta1_PodCertificateRequestList is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequestList_To_v1beta1_PodCertificateRequestList(in *certificates.PodCertificateRequestList, out *certificatesv1beta1.PodCertificateRequestList, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequestList_To_v1beta1_PodCertificateRequestList(in, out, s)
}

func autoConvert_v1beta1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(in *certificatesv1beta1.PodCertificateRequestSpec, out *certificates.PodCertificateRequestSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.PodName = in.PodName
	out.PodUID = types.UID(in.PodUID)
	out.ServiceAccountName = in.ServiceAccountName
	out.ServiceAccountUID = types.UID(in.ServiceAccountUID)
	out.NodeName = types.NodeName(in.NodeName)
	out.NodeUID = types.UID(in.NodeUID)
	out.MaxExpirationSeconds = (*int32)(unsafe.Pointer(in.MaxExpirationSeconds))
	out.PKIXPublicKey = *(*[]byte)(unsafe.Pointer(&in.PKIXPublicKey))
	out.ProofOfPossession = *(*[]byte)(unsafe.Pointer(&in.ProofOfPossession))
	out.UnverifiedUserAnnotations = *(*map[string]string)(unsafe.Pointer(&in.UnverifiedUserAnnotations))
	return nil
}

// Convert_v1beta1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec is an autogenerated conversion function.
func Convert_v1beta1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(in *certificatesv1beta1.PodCertificateRequestSpec, out *certificates.PodCertificateRequestSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(in, out, s)
}

func autoConvert_certificates_PodCertificateRequestSpec_To_v1beta1_PodCertificateRequestSpec(in *certificates.PodCertificateRequestSpec, out *certificatesv1beta1.PodCertificateRequestSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.PodName = in.PodName
	out.PodUID = types.UID(in.PodUID)
	out.ServiceAccountName = in.ServiceAccountName
	out.ServiceAccountUID = types.UID(in.ServiceAccountUID)
	out.NodeName = types.NodeName(in.NodeName)
	out.NodeUID = types.UID(in.NodeUID)
	out.MaxExpirationSeconds = (*int32)(unsafe.Pointer(in.MaxExpirationSeconds))
	out.PKIXPublicKey = *(*[]byte)(unsafe.Pointer(&in.PKIXPublicKey))
	out.ProofOfPossession = *(*[]byte)(unsafe.Pointer(&in.ProofOfPossession))
	out.UnverifiedUserAnnotations = *(*map[string]string)(unsafe.Pointer(&in.UnverifiedUserAnnotations))
	return nil
}

// Convert_certificates_PodCertificateRequestSpec_To_v1beta1_PodCertificateRequestSpec is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequestSpec_To_v1beta1_PodCertificateRequestSpec(in *certificates.PodCertificateRequestSpec, out *certificatesv1beta1.PodCertificateRequestSpec, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequestSpec_To_v1beta1_PodCertificateRequestSpec(in, out, s)
}

func autoConvert_v1beta1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(in *certificatesv1beta1.PodCertificateRequestStatus, out *certificates.PodCertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]metav1.Condition)(unsafe.Pointer(&in.Conditions))
	out.CertificateChain = in.CertificateChain
	out.NotBefore = (*metav1.Time)(unsafe.Pointer(in.NotBefore))
	out.BeginRefreshAt = (*metav1.Time)(unsafe.Pointer(in.BeginRefreshAt))
	out.NotAfter = (*metav1.Time)(unsafe.Pointer(in.NotAfter))
	return nil
}

// Convert_v1beta1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus is an autogenerated conversion function.
func Convert_v1beta1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(in *certificatesv1beta1.PodCertificateRequestStatus, out *certificates.PodCertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(in, out, s)
}

func autoConvert_certificates_PodCertificateRequestStatus_To_v1beta1_PodCertificateRequestStatus(in *certificates.PodCertificateRequestStatus, out *certificatesv1beta1.PodCertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]metav1.Condition)(unsafe.Pointer(&in.Conditions))
	out.CertificateChain = in.CertificateChain
	out.NotBefore = (*metav1.Time)(unsafe.Pointer(in.NotBefore))
	out.BeginRefreshAt = (*metav1.Time)(unsafe.Pointer(in.BeginRefreshAt))
	out.NotAfter = (*metav1.Time)(unsafe.Pointer(in.NotAfter))
	return nil
}

// Convert_certificates_PodCertificateRequestStatus_To_v1beta1_PodCertificateRequestStatus is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequestStatus_To_v1beta1_PodCertificateRequestStatus(in *certificates.PodCertificateRequestStatus, out *certificatesv1beta1.PodCertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequestStatus_To_v1beta1_PodCertificateRequestStatus(in, out, s)
}
