/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	"io/fs"

	mock "github.com/stretchr/testify/mock"
)

// NewMockDirEntry creates a new instance of MockDirEntry. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockDirEntry(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockDirEntry {
	mock := &MockDirEntry{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockDirEntry is an autogenerated mock type for the DirEntry type
type MockDirEntry struct {
	mock.Mock
}

type MockDirEntry_Expecter struct {
	mock *mock.Mock
}

func (_m *MockDirEntry) EXPECT() *MockDirEntry_Expecter {
	return &MockDirEntry_Expecter{mock: &_m.Mock}
}

// Info provides a mock function for the type MockDirEntry
func (_mock *MockDirEntry) Info() (fs.FileInfo, error) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Info")
	}

	var r0 fs.FileInfo
	var r1 error
	if returnFunc, ok := ret.Get(0).(func() (fs.FileInfo, error)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() fs.FileInfo); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(fs.FileInfo)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() error); ok {
		r1 = returnFunc()
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockDirEntry_Info_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Info'
type MockDirEntry_Info_Call struct {
	*mock.Call
}

// Info is a helper method to define mock.On call
func (_e *MockDirEntry_Expecter) Info() *MockDirEntry_Info_Call {
	return &MockDirEntry_Info_Call{Call: _e.mock.On("Info")}
}

func (_c *MockDirEntry_Info_Call) Run(run func()) *MockDirEntry_Info_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockDirEntry_Info_Call) Return(fileInfo fs.FileInfo, err error) *MockDirEntry_Info_Call {
	_c.Call.Return(fileInfo, err)
	return _c
}

func (_c *MockDirEntry_Info_Call) RunAndReturn(run func() (fs.FileInfo, error)) *MockDirEntry_Info_Call {
	_c.Call.Return(run)
	return _c
}

// IsDir provides a mock function for the type MockDirEntry
func (_mock *MockDirEntry) IsDir() bool {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsDir")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func() bool); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockDirEntry_IsDir_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDir'
type MockDirEntry_IsDir_Call struct {
	*mock.Call
}

// IsDir is a helper method to define mock.On call
func (_e *MockDirEntry_Expecter) IsDir() *MockDirEntry_IsDir_Call {
	return &MockDirEntry_IsDir_Call{Call: _e.mock.On("IsDir")}
}

func (_c *MockDirEntry_IsDir_Call) Run(run func()) *MockDirEntry_IsDir_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockDirEntry_IsDir_Call) Return(b bool) *MockDirEntry_IsDir_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockDirEntry_IsDir_Call) RunAndReturn(run func() bool) *MockDirEntry_IsDir_Call {
	_c.Call.Return(run)
	return _c
}

// Name provides a mock function for the type MockDirEntry
func (_mock *MockDirEntry) Name() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Name")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// MockDirEntry_Name_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Name'
type MockDirEntry_Name_Call struct {
	*mock.Call
}

// Name is a helper method to define mock.On call
func (_e *MockDirEntry_Expecter) Name() *MockDirEntry_Name_Call {
	return &MockDirEntry_Name_Call{Call: _e.mock.On("Name")}
}

func (_c *MockDirEntry_Name_Call) Run(run func()) *MockDirEntry_Name_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockDirEntry_Name_Call) Return(s string) *MockDirEntry_Name_Call {
	_c.Call.Return(s)
	return _c
}

func (_c *MockDirEntry_Name_Call) RunAndReturn(run func() string) *MockDirEntry_Name_Call {
	_c.Call.Return(run)
	return _c
}

// Type provides a mock function for the type MockDirEntry
func (_mock *MockDirEntry) Type() fs.FileMode {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Type")
	}

	var r0 fs.FileMode
	if returnFunc, ok := ret.Get(0).(func() fs.FileMode); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(fs.FileMode)
	}
	return r0
}

// MockDirEntry_Type_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Type'
type MockDirEntry_Type_Call struct {
	*mock.Call
}

// Type is a helper method to define mock.On call
func (_e *MockDirEntry_Expecter) Type() *MockDirEntry_Type_Call {
	return &MockDirEntry_Type_Call{Call: _e.mock.On("Type")}
}

func (_c *MockDirEntry_Type_Call) Run(run func()) *MockDirEntry_Type_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockDirEntry_Type_Call) Return(fileMode fs.FileMode) *MockDirEntry_Type_Call {
	_c.Call.Return(fileMode)
	return _c
}

func (_c *MockDirEntry_Type_Call) RunAndReturn(run func() fs.FileMode) *MockDirEntry_Type_Call {
	_c.Call.Return(run)
	return _c
}
