// Code generated by github.com/99designs/gqlgen, DO NOT EDIT.

package model

import (
	"bytes"
	"fmt"
	"io"
	"strconv"
	"time"

	"github.com/kubetail-org/kubetail/modules/shared/logs"
	"k8s.io/apimachinery/pkg/watch"
)

type HealthCheckResponse struct {
	Status    HealthCheckStatus `json:"status"`
	Message   *string           `json:"message,omitempty"`
	Timestamp time.Time         `json:"timestamp"`
}

type KubeConfigWatchEvent struct {
	Type   watch.EventType `json:"type"`
	Object *KubeConfig     `json:"object,omitempty"`
}

type LogRecordsQueryResponse struct {
	Records    []*logs.LogRecord `json:"records"`
	NextCursor *string           `json:"nextCursor,omitempty"`
}

type LogSourceFilter struct {
	Region    []string `json:"region,omitempty"`
	Zone      []string `json:"zone,omitempty"`
	Os        []string `json:"os,omitempty"`
	Arch      []string `json:"arch,omitempty"`
	Node      []string `json:"node,omitempty"`
	Container []string `json:"container,omitempty"`
}

type LogSourceWatchEvent struct {
	Type   watch.EventType `json:"type"`
	Object *logs.LogSource `json:"object,omitempty"`
}

type Mutation struct {
}

type PageInfo struct {
	// When paginating forwards, the cursor to continue.
	EndCursor *string `json:"endCursor,omitempty"`
	// When paginating forwards, are there more items?
	HasNextPage bool `json:"hasNextPage"`
	// When paginating backwards, are there more items?
	HasPreviousPage bool `json:"hasPreviousPage"`
	// When paginating backwards, the cursor to continue.
	StartCursor *string `json:"startCursor,omitempty"`
}

type Subscription struct {
}

type VersionStatus struct {
	CurrentVersion  string `json:"currentVersion"`
	LatestVersion   string `json:"latestVersion"`
	UpdateAvailable bool   `json:"updateAvailable"`
}

type HealthCheckStatus string

const (
	HealthCheckStatusSuccess  HealthCheckStatus = "SUCCESS"
	HealthCheckStatusFailure  HealthCheckStatus = "FAILURE"
	HealthCheckStatusPending  HealthCheckStatus = "PENDING"
	HealthCheckStatusUnknown  HealthCheckStatus = "UNKNOWN"
	HealthCheckStatusNotfound HealthCheckStatus = "NOTFOUND"
)

var AllHealthCheckStatus = []HealthCheckStatus{
	HealthCheckStatusSuccess,
	HealthCheckStatusFailure,
	HealthCheckStatusPending,
	HealthCheckStatusUnknown,
	HealthCheckStatusNotfound,
}

func (e HealthCheckStatus) IsValid() bool {
	switch e {
	case HealthCheckStatusSuccess, HealthCheckStatusFailure, HealthCheckStatusPending, HealthCheckStatusUnknown, HealthCheckStatusNotfound:
		return true
	}
	return false
}

func (e HealthCheckStatus) String() string {
	return string(e)
}

func (e *HealthCheckStatus) UnmarshalGQL(v any) error {
	str, ok := v.(string)
	if !ok {
		return fmt.Errorf("enums must be strings")
	}

	*e = HealthCheckStatus(str)
	if !e.IsValid() {
		return fmt.Errorf("%s is not a valid HealthCheckStatus", str)
	}
	return nil
}

func (e HealthCheckStatus) MarshalGQL(w io.Writer) {
	fmt.Fprint(w, strconv.Quote(e.String()))
}

func (e *HealthCheckStatus) UnmarshalJSON(b []byte) error {
	s, err := strconv.Unquote(string(b))
	if err != nil {
		return err
	}
	return e.UnmarshalGQL(s)
}

func (e HealthCheckStatus) MarshalJSON() ([]byte, error) {
	var buf bytes.Buffer
	e.MarshalGQL(&buf)
	return buf.Bytes(), nil
}

type LogRecordsQueryMode string

const (
	LogRecordsQueryModeHead LogRecordsQueryMode = "HEAD"
	LogRecordsQueryModeTail LogRecordsQueryMode = "TAIL"
)

var AllLogRecordsQueryMode = []LogRecordsQueryMode{
	LogRecordsQueryModeHead,
	LogRecordsQueryModeTail,
}

func (e LogRecordsQueryMode) IsValid() bool {
	switch e {
	case LogRecordsQueryModeHead, LogRecordsQueryModeTail:
		return true
	}
	return false
}

func (e LogRecordsQueryMode) String() string {
	return string(e)
}

func (e *LogRecordsQueryMode) UnmarshalGQL(v any) error {
	str, ok := v.(string)
	if !ok {
		return fmt.Errorf("enums must be strings")
	}

	*e = LogRecordsQueryMode(str)
	if !e.IsValid() {
		return fmt.Errorf("%s is not a valid LogRecordsQueryMode", str)
	}
	return nil
}

func (e LogRecordsQueryMode) MarshalGQL(w io.Writer) {
	fmt.Fprint(w, strconv.Quote(e.String()))
}

func (e *LogRecordsQueryMode) UnmarshalJSON(b []byte) error {
	s, err := strconv.Unquote(string(b))
	if err != nil {
		return err
	}
	return e.UnmarshalGQL(s)
}

func (e LogRecordsQueryMode) MarshalJSON() ([]byte, error) {
	var buf bytes.Buffer
	e.MarshalGQL(&buf)
	return buf.Bytes(), nil
}
