// Code generated by pluginator on HashTransformer; DO NOT EDIT.
package builtins

import (
	"fmt"

	"sigs.k8s.io/kustomize/api/ifc"
	"sigs.k8s.io/kustomize/api/resmap"
)

type HashTransformerPlugin struct {
	hasher ifc.KustHasher
}

func (p *HashTransformerPlugin) Config(
	h *resmap.PluginHelpers, _ []byte) (err error) {
	p.hasher = h.ResmapFactory().RF().Hasher()
	return nil
}

// Transform appends hash to generated resources.
func (p *HashTransformerPlugin) Transform(m resmap.ResMap) error {
	for _, res := range m.Resources() {
		if res.NeedHashSuffix() {
			h, err := res.Hash(p.hasher)
			if err != nil {
				return err
			}
			res.StorePreviousId()
			res.SetName(fmt.Sprintf("%s-%s", res.GetName(), h))
		}
	}
	return nil
}

func NewHashTransformerPlugin() resmap.TransformerPlugin {
	return &HashTransformerPlugin{}
}
