// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	appsv1 "github.com/openshift/api/apps/v1"
	applyconfigurationsappsv1 "github.com/openshift/client-go/apps/applyconfigurations/apps/v1"
	scheme "github.com/openshift/client-go/apps/clientset/versioned/scheme"
	v1beta1 "k8s.io/api/extensions/v1beta1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// DeploymentConfigsGetter has a method to return a DeploymentConfigInterface.
// A group's client should implement this interface.
type DeploymentConfigsGetter interface {
	DeploymentConfigs(namespace string) DeploymentConfigInterface
}

// DeploymentConfigInterface has methods to work with DeploymentConfig resources.
type DeploymentConfigInterface interface {
	Create(ctx context.Context, deploymentConfig *appsv1.DeploymentConfig, opts metav1.CreateOptions) (*appsv1.DeploymentConfig, error)
	Update(ctx context.Context, deploymentConfig *appsv1.DeploymentConfig, opts metav1.UpdateOptions) (*appsv1.DeploymentConfig, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, deploymentConfig *appsv1.DeploymentConfig, opts metav1.UpdateOptions) (*appsv1.DeploymentConfig, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*appsv1.DeploymentConfig, error)
	List(ctx context.Context, opts metav1.ListOptions) (*appsv1.DeploymentConfigList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *appsv1.DeploymentConfig, err error)
	Apply(ctx context.Context, deploymentConfig *applyconfigurationsappsv1.DeploymentConfigApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1.DeploymentConfig, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, deploymentConfig *applyconfigurationsappsv1.DeploymentConfigApplyConfiguration, opts metav1.ApplyOptions) (result *appsv1.DeploymentConfig, err error)
	Instantiate(ctx context.Context, deploymentConfigName string, deploymentRequest *appsv1.DeploymentRequest, opts metav1.CreateOptions) (*appsv1.DeploymentConfig, error)
	Rollback(ctx context.Context, deploymentConfigName string, deploymentConfigRollback *appsv1.DeploymentConfigRollback, opts metav1.CreateOptions) (*appsv1.DeploymentConfig, error)
	GetScale(ctx context.Context, deploymentConfigName string, options metav1.GetOptions) (*v1beta1.Scale, error)
	UpdateScale(ctx context.Context, deploymentConfigName string, scale *v1beta1.Scale, opts metav1.UpdateOptions) (*v1beta1.Scale, error)

	DeploymentConfigExpansion
}

// deploymentConfigs implements DeploymentConfigInterface
type deploymentConfigs struct {
	*gentype.ClientWithListAndApply[*appsv1.DeploymentConfig, *appsv1.DeploymentConfigList, *applyconfigurationsappsv1.DeploymentConfigApplyConfiguration]
}

// newDeploymentConfigs returns a DeploymentConfigs
func newDeploymentConfigs(c *AppsV1Client, namespace string) *deploymentConfigs {
	return &deploymentConfigs{
		gentype.NewClientWithListAndApply[*appsv1.DeploymentConfig, *appsv1.DeploymentConfigList, *applyconfigurationsappsv1.DeploymentConfigApplyConfiguration](
			"deploymentconfigs",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *appsv1.DeploymentConfig { return &appsv1.DeploymentConfig{} },
			func() *appsv1.DeploymentConfigList { return &appsv1.DeploymentConfigList{} },
		),
	}
}

// Instantiate takes the representation of a deploymentRequest and creates it.  Returns the server's representation of the deploymentConfig, and an error, if there is any.
func (c *deploymentConfigs) Instantiate(ctx context.Context, deploymentConfigName string, deploymentRequest *appsv1.DeploymentRequest, opts metav1.CreateOptions) (result *appsv1.DeploymentConfig, err error) {
	result = &appsv1.DeploymentConfig{}
	err = c.GetClient().Post().
		Namespace(c.GetNamespace()).
		Resource("deploymentconfigs").
		Name(deploymentConfigName).
		SubResource("instantiate").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(deploymentRequest).
		Do(ctx).
		Into(result)
	return
}

// Rollback takes the representation of a deploymentConfigRollback and creates it.  Returns the server's representation of the deploymentConfig, and an error, if there is any.
func (c *deploymentConfigs) Rollback(ctx context.Context, deploymentConfigName string, deploymentConfigRollback *appsv1.DeploymentConfigRollback, opts metav1.CreateOptions) (result *appsv1.DeploymentConfig, err error) {
	result = &appsv1.DeploymentConfig{}
	err = c.GetClient().Post().
		Namespace(c.GetNamespace()).
		Resource("deploymentconfigs").
		Name(deploymentConfigName).
		SubResource("rollback").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(deploymentConfigRollback).
		Do(ctx).
		Into(result)
	return
}

// GetScale takes name of the deploymentConfig, and returns the corresponding v1beta1.Scale object, and an error if there is any.
func (c *deploymentConfigs) GetScale(ctx context.Context, deploymentConfigName string, options metav1.GetOptions) (result *v1beta1.Scale, err error) {
	result = &v1beta1.Scale{}
	err = c.GetClient().Get().
		Namespace(c.GetNamespace()).
		Resource("deploymentconfigs").
		Name(deploymentConfigName).
		SubResource("scale").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// UpdateScale takes the top resource name and the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *deploymentConfigs) UpdateScale(ctx context.Context, deploymentConfigName string, scale *v1beta1.Scale, opts metav1.UpdateOptions) (result *v1beta1.Scale, err error) {
	result = &v1beta1.Scale{}
	err = c.GetClient().Put().
		Namespace(c.GetNamespace()).
		Resource("deploymentconfigs").
		Name(deploymentConfigName).
		SubResource("scale").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scale).
		Do(ctx).
		Into(result)
	return
}
