# Cline-Specific Guidelines

## VS Code Integration

- Leverage VS Code's built-in features for file navigation and editing
- Use the integrated terminal for command execution
- Respect workspace settings and configurations

## File Operations

- Use VS Code's file explorer for navigation
- Prefer relative paths for portability
- Respect .gitignore patterns

## Error Reporting in VS Code

- Format errors with file paths as clickable links (e.g., `pkg/controller/run/parse_line.go:123`)
- Use VS Code's Problems panel format when appropriate
- Provide clear, actionable error messages in the output

## VS Code Terminal Usage

- Execute validation and test commands in the integrated terminal
- Show command output directly in the terminal
- Use VS Code's task runner integration when available

## Cline Chat Interface

- Use markdown formatting for better readability
- Keep responses concise and focused
- Provide file paths that VS Code can navigate to
