"""Generated message classes for storage version v2.

Lets you store and retrieve potentially-large, immutable data objects.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'storage'


class Action(_messages.Message):
  r"""An action to take on an object.

  Fields:
    storageClass: Optional. Target storage class. Required iff the type of the
      action is SetStorageClass.
    type: Optional. Type of the action. Currently, only `Delete`,
      `SetStorageClass`, and `AbortIncompleteMultipartUpload` are supported.
  """

  storageClass = _messages.StringField(1)
  type = _messages.StringField(2)


class Autoclass(_messages.Message):
  r"""Configuration for a bucket's Autoclass feature.

  Fields:
    enabled: Optional. Enables Autoclass.
    terminalStorageClass: An object in an Autoclass bucket eventually cools
      down to the terminal storage class if there is no access to the object.
      The only valid values are NEARLINE and ARCHIVE.
    terminalStorageClassUpdateTime: Output only. Latest instant at which the
      autoclass terminal storage class was updated.
    toggleTime: Output only. Latest instant at which the `enabled` field was
      set to true after being disabled/unconfigured or set to false after
      being enabled. If Autoclass is enabled when the bucket is created, the
      value of the `toggle_time` field is set to the bucket `create_time`.
  """

  enabled = _messages.BooleanField(1)
  terminalStorageClass = _messages.StringField(2)
  terminalStorageClassUpdateTime = _messages.StringField(3)
  toggleTime = _messages.StringField(4)


class BandwidthQuotaNearLimit(_messages.Message):
  r"""Represents a finding about bandwidth consumption approaching quota
  limits within a project. This corresponds to the
  `BANDWIDTH_QUOTA_NEAR_LIMIT` finding type.

  Fields:
    percentageIncrease: Output only. The percentage increase in bandwidth
      consumption for the project.
    topBuckets: Output only. A list of top buckets driving the increase in
      bandwidth consumption.
    topLocations: Output only. A list of top locations driving the increase in
      bandwidth consumption.
    totalBandwidthConsumptionBytes: Output only. The total bandwidth
      consumption in bytes.
  """

  percentageIncrease = _messages.FloatField(1)
  topBuckets = _messages.MessageField('IntelligenceFindingBandwidthQuotaNearLimitBucketContribution', 2, repeated=True)
  topLocations = _messages.MessageField('LocationalContribution', 3, repeated=True)
  totalBandwidthConsumptionBytes = _messages.IntegerField(4)


class Billing(_messages.Message):
  r"""Billing properties of a bucket.

  Fields:
    requesterPays: Optional. When set to true, Requester Pays is enabled for
      this bucket.
  """

  requesterPays = _messages.BooleanField(1)


class Bucket(_messages.Message):
  r"""A bucket.

  Messages:
    LabelsValue: Optional. User-provided labels, in key/value pairs.

  Fields:
    acl: Optional. Access controls on the bucket. If
      `iam_config.uniform_bucket_level_access` is enabled on this bucket,
      requests to set, read, or modify acl is an error.
    autoclass: Optional. The bucket's Autoclass configuration. If there is no
      configuration, the Autoclass feature is disabled and has no effect on
      the bucket.
    billing: Optional. The bucket's billing configuration.
    bucketId: Output only. The user-chosen part of the bucket name. The
      `{bucket}` portion of the `name` field. For globally unique buckets,
      this is equal to the `bucket name` of other Cloud Storage APIs. Example:
      `pub`.
    cors: Optional. The bucket's [CORS](https://www.w3.org/TR/cors/)
      configuration.
    createTime: Output only. The creation time of the bucket.
    customPlacementConfig: Optional. Configuration that, if present, specifies
      the data placement for a [configurable dual-
      region](https://cloud.google.com/storage/docs/locations#location-dr).
    defaultEventBasedHold: Optional. The default value for event-based hold on
      newly created objects in this bucket. Event-based hold is a way to
      retain objects indefinitely until an event occurs, signified by the
      hold's release. After being released, such objects are subject to
      bucket-level retention (if any). One sample use case of this flag is for
      banks to hold loan documents for at least 3 years after loan is paid in
      full. Here, bucket-level retention is 3 years and the event is loan
      being paid in full. In this example, these objects are held intact for
      any number of years until the event has occurred (event-based hold on
      the object is released) and then 3 more years after that. That means
      retention duration of the objects begins from the moment event-based
      hold transitioned from true to false. Objects under event-based hold
      cannot be deleted, overwritten or archived until the hold is removed.
    defaultObjectAcl: Optional. Default access controls to apply to new
      objects when no ACL is provided. If
      `iam_config.uniform_bucket_level_access` is enabled on this bucket,
      requests to set, read, or modify acl is an error.
    encryption: Optional. Encryption config for a bucket.
    etag: The etag of the bucket. If included in the metadata of an
      `UpdateBucketRequest`, the operation is only performed if the `etag`
      matches that of the bucket.
    generation: Output only. The generation of the bucket.
    hardDeleteTime: Output only. The hard delete time of the bucket.
    hierarchicalNamespace: Optional. The bucket's hierarchical namespace
      configuration. If there is no configuration, the hierarchical namespace
      feature is disabled and has no effect on the bucket.
    iamConfig: Optional. The bucket's IAM configuration.
    ipFilter: Optional. The bucket's IP filter configuration.
    labels: Optional. User-provided labels, in key/value pairs.
    lifecycle: Optional. The bucket's lifecycle configuration. See [Lifecycle
      Management](https://developers.google.com/storage/docs/lifecycle) for
      more information.
    location: Immutable. The location of the bucket. Object data for objects
      in the bucket resides in physical storage within this region. Defaults
      to `US`. Attempting to update this field after the bucket is created
      results in an error.
    locationType: Output only. The location type of the bucket (region, dual-
      region, multi-region, etc).
    logging: Optional. The bucket's logging config, which defines the
      destination bucket and name prefix (if any) for the current bucket's
      logs.
    metageneration: Output only. The metadata generation of this bucket.
    name: Identifier. The name of the bucket. Format:
      `projects/{project}/buckets/{bucket}`
    objectRetention: Optional. The bucket's object retention configuration.
      Must be enabled before objects in the bucket might have retention
      configured.
    owner: Output only. The owner of the bucket. This is always the project
      team's owner group.
    project: Immutable. The project which owns this bucket, in the format of
      `projects/{projectIdentifier}`. `{projectIdentifier}` can be the project
      ID or project number. Output values are always in the project number
      format.
    retentionPolicy: Optional. The bucket's retention policy. The retention
      policy enforces a minimum retention time for all objects contained in
      the bucket, based on their creation time. Any attempt to overwrite or
      delete objects younger than the retention period results in a
      `PERMISSION_DENIED` error. An unlocked retention policy can be modified
      or removed from the bucket via a storage.buckets.update operation. A
      locked retention policy cannot be removed or shortened in duration for
      the lifetime of the bucket. Attempting to remove or decrease period of a
      locked retention policy results in a `PERMISSION_DENIED` error.
    rpo: Optional. The recovery point objective for cross-region replication
      of the bucket. Applicable only for dual- and multi-region buckets.
      `DEFAULT` uses default replication. `ASYNC_TURBO` enables turbo
      replication, valid for dual-region buckets only. If rpo is not specified
      when the bucket is created, it defaults to `DEFAULT`. For more
      information, see [Turbo
      replication](https://cloud.google.com/storage/docs/availability-
      durability#turbo-replication).
    satisfiesPzi: Optional. Reserved for future use.
    satisfiesPzs: Optional. Reserved for future use.
    softDeletePolicy: Optional. The bucket's soft delete policy. The soft
      delete policy prevents soft-deleted objects from being permanently
      deleted.
    softDeleteTime: Output only. The soft delete time of the bucket.
    storageClass: Optional. The bucket's default storage class, used whenever
      no storageClass is specified for a newly-created object. This defines
      how objects in the bucket are stored and determines the SLA and the cost
      of storage. If this value is not specified when the bucket is created,
      it defaults to `STANDARD`. For more information, see [Storage
      classes](https://developers.google.com/storage/docs/storage-classes).
    updateTime: Output only. The modification time of the bucket.
    versioning: Optional. The bucket's versioning configuration.
    website: Optional. The bucket's website config, controlling how the
      service behaves when accessing bucket contents as a web site. See the
      [Static website examples](https://cloud.google.com/storage/docs/static-
      website) for more information.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-provided labels, in key/value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  acl = _messages.MessageField('BucketAccessControl', 1, repeated=True)
  autoclass = _messages.MessageField('Autoclass', 2)
  billing = _messages.MessageField('Billing', 3)
  bucketId = _messages.StringField(4)
  cors = _messages.MessageField('Cors', 5, repeated=True)
  createTime = _messages.StringField(6)
  customPlacementConfig = _messages.MessageField('GoogleStorageV2CustomPlacementConfig', 7)
  defaultEventBasedHold = _messages.BooleanField(8)
  defaultObjectAcl = _messages.MessageField('ObjectAccessControl', 9, repeated=True)
  encryption = _messages.MessageField('Encryption', 10)
  etag = _messages.StringField(11)
  generation = _messages.IntegerField(12)
  hardDeleteTime = _messages.StringField(13)
  hierarchicalNamespace = _messages.MessageField('GoogleStorageV2HierarchicalNamespace', 14)
  iamConfig = _messages.MessageField('IamConfig', 15)
  ipFilter = _messages.MessageField('IpFilter', 16)
  labels = _messages.MessageField('LabelsValue', 17)
  lifecycle = _messages.MessageField('Lifecycle', 18)
  location = _messages.StringField(19)
  locationType = _messages.StringField(20)
  logging = _messages.MessageField('Logging', 21)
  metageneration = _messages.IntegerField(22)
  name = _messages.StringField(23)
  objectRetention = _messages.MessageField('ObjectRetention', 24)
  owner = _messages.MessageField('Owner', 25)
  project = _messages.StringField(26)
  retentionPolicy = _messages.MessageField('RetentionPolicy', 27)
  rpo = _messages.StringField(28)
  satisfiesPzi = _messages.BooleanField(29)
  satisfiesPzs = _messages.BooleanField(30)
  softDeletePolicy = _messages.MessageField('SoftDeletePolicy', 31)
  softDeleteTime = _messages.StringField(32)
  storageClass = _messages.StringField(33)
  updateTime = _messages.StringField(34)
  versioning = _messages.MessageField('Versioning', 35)
  website = _messages.MessageField('Website', 36)


class BucketAccessControl(_messages.Message):
  r"""An access-control entry.

  Fields:
    domain: Optional. The domain associated with the entity, if any.
    email: Optional. The email address associated with the entity, if any.
    entity: Optional. The entity holding the permission, in one of the
      following forms: * `user-{userid}` * `user-{email}` * `group-{groupid}`
      * `group-{email}` * `domain-{domain}` * `project-{team}-{projectnumber}`
      * `project-{team}-{projectid}` * `allUsers` * `allAuthenticatedUsers`
      Examples: * The user `liz@example.com` would be `user-liz@example.com`.
      * The group `example@googlegroups.com` would be `group-
      example@googlegroups.com` * All members of the Google Apps for Business
      domain `example.com` would be `domain-example.com` For project entities,
      `project-{team}-{projectnumber}` format is returned on response.
    entityAlt: Output only. The alternative entity format, if exists. For
      project entities, `project-{team}-{projectid}` format is returned in the
      response.
    entityId: Optional. The ID for the entity, if any.
    etag: Optional. The `etag` of the `BucketAccessControl`. If included in
      the metadata of an update or delete request message, the operation
      operation is only performed if the etag matches that of the bucket's
      `BucketAccessControl`.
    id: Optional. The ID of the access-control entry.
    projectTeam: Optional. The project team associated with the entity, if
      any.
    role: Optional. The access permission for the entity.
  """

  domain = _messages.StringField(1)
  email = _messages.StringField(2)
  entity = _messages.StringField(3)
  entityAlt = _messages.StringField(4)
  entityId = _messages.StringField(5)
  etag = _messages.StringField(6)
  id = _messages.StringField(7)
  projectTeam = _messages.MessageField('ProjectTeam', 8)
  role = _messages.StringField(9)


class CloudStorageBucket(_messages.Message):
  r"""Defines the bucket by its name or a regex pattern to match the buckets.

  Fields:
    bucketId: Cloud Storage bucket name. For example, `sample_bucket` is the
      name for bucket `gs://sample_bucket`.
    bucketIdRegex: A regex pattern for matching bucket names. Regex should
      follow the syntax specified in
      [google/re2](https://github.com/google/re2). For example, `^sample_.*`
      matches all buckets of the form `gs://sample_bucket-1`,
      `gs://sample_bucket-2`, `gs://sample_bucket-n` but not
      `gs://test_sample_bucket`.
  """

  bucketId = _messages.StringField(1)
  bucketIdRegex = _messages.StringField(2)


class CloudStorageBuckets(_messages.Message):
  r"""Collection of buckets.

  Fields:
    bucketIdRegexes: Optional. A regex pattern for matching bucket names.
      Regex should follow the syntax specified in
      [google/re2](https://github.com/google/re2). For example, `^sample_.*`
      matches all buckets of the form `gs://sample_bucket-1`,
      `gs://sample_bucket-2`, `gs://sample_bucket-n` but not
      `gs://test_sample_bucket`. If you want to match a single bucket, say
      `gs://sample_bucket`, use `sample_bucket`.
  """

  bucketIdRegexes = _messages.StringField(1, repeated=True)


class CloudStorageLocations(_messages.Message):
  r"""Collection of bucket locations.

  Fields:
    locations: Optional. Bucket locations. Location can be any of the Cloud
      Storage regions specified in lower case format. For example, `us-east1`,
      `us-west1`.
  """

  locations = _messages.StringField(1, repeated=True)


class ColdlineAndArchivalStorageOperationsSpike(_messages.Message):
  r"""Represents a finding about a spike in Class A/B operations on Coldline
  or Archive Cloud Storage objects. This corresponds to the
  `COLD_AND_ARCHIVAL_STORAGE_OPERATIONS_SPIKE` finding type.

  Fields:
    percentageIncrease: Output only. The percentage increase in operations
      across the project.
    topBuckets: Output only. A list of the top buckets driving the increase in
      operations.
    totalOperationsCount: Output only. The total count of operations across
      the project.
  """

  percentageIncrease = _messages.FloatField(1)
  topBuckets = _messages.MessageField('IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContribution', 2, repeated=True)
  totalOperationsCount = _messages.IntegerField(3)


class CommonLongRunningOperationMetadata(_messages.Message):
  r"""The message contains metadata that is common to all Storage Control
  long-running operations, present in its `google.longrunning.Operation`
  messages, and accessible via `metadata.common_metadata`.

  Fields:
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    progressPercent: Output only. The estimated progress of the operation in
      percentage [0, 100]. The value -1 means the progress is unknown.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation.
    type: Output only. The type of operation invoked.
    updateTime: Output only. The time the operation was last modified.
  """

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  progressPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  requestedCancellation = _messages.BooleanField(4)
  type = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class Condition(_messages.Message):
  r"""A condition of an object which triggers some action.

  Fields:
    ageDays: Age of an object (in days). This condition is satisfied when an
      object reaches the specified age. A value of 0 indicates that all
      objects immediately match this condition.
    createdBefore: Optional. This condition is satisfied when an object is
      created before midnight of the specified date in UTC.
    customTimeBefore: Optional. An object matches this condition if the custom
      timestamp set on the object is before the specified date in UTC.
    daysSinceCustomTime: Number of days that have elapsed since the custom
      timestamp set on an object. The value of the field must be a nonnegative
      integer.
    daysSinceNoncurrentTime: This condition is relevant only for versioned
      objects. An object version satisfies this condition only if these many
      days have been passed since it became noncurrent. The value of the field
      must be a nonnegative integer. If it's zero, the object version becomes
      eligible for Lifecycle action as soon as it becomes noncurrent.
    isLive: Relevant only for versioned objects. If the value is `true`, this
      condition matches live objects; if the value is `false`, it matches
      archived objects.
    matchesPattern: A regular expression that satisfies the RE2 syntax. This
      condition is satisfied when the name of the object matches the RE2
      pattern. Note: This feature is currently in the "Early Access" launch
      stage and is only available to an allowlisted set of users; that means
      that this feature might be changed in backward-incompatible ways and
      that it is not guaranteed to be released. An empty pattern matches
      nothing.
    matchesPrefix: Optional. List of object name prefixes. If any prefix
      exactly matches the beginning of the object name, the condition
      evaluates to true.
    matchesStorageClass: Optional. Objects having any of the storage classes
      specified by this condition are matched. Values include
      `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
      `DURABLE_REDUCED_AVAILABILITY`.
    matchesSuffix: Optional. List of object name suffixes. If any suffix
      exactly matches the end of the object name, the condition evaluates to
      true.
    noncurrentTimeBefore: Optional. This condition is relevant only for
      versioned objects. An object version satisfies this condition only if it
      became noncurrent before the specified date in UTC.
    numNewerVersions: Relevant only for versioned objects. If the value is N,
      this condition is satisfied when there are at least N versions
      (including the live version) newer than this version of the object.
  """

  ageDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  createdBefore = _messages.MessageField('Date', 2)
  customTimeBefore = _messages.MessageField('Date', 3)
  daysSinceCustomTime = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  daysSinceNoncurrentTime = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  isLive = _messages.BooleanField(6)
  matchesPattern = _messages.StringField(7)
  matchesPrefix = _messages.StringField(8, repeated=True)
  matchesStorageClass = _messages.StringField(9, repeated=True)
  matchesSuffix = _messages.StringField(10, repeated=True)
  noncurrentTimeBefore = _messages.MessageField('Date', 11)
  numNewerVersions = _messages.IntegerField(12, variant=_messages.Variant.INT32)


class Cors(_messages.Message):
  r"""Cross-Origin Response sharing (CORS) properties for a bucket. For more
  on Cloud Storage and CORS, see https://cloud.google.com/storage/docs/cross-
  origin. For more on CORS in general, see
  https://tools.ietf.org/html/rfc6454.

  Fields:
    maxAgeSeconds: Optional. The value, in seconds, to return in the [Access-
      Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-
      age-response-header) used in preflight responses.
    method: Optional. The list of HTTP methods on which to include CORS
      response headers, (`GET`, `OPTIONS`, `POST`, etc) Note: `*` is permitted
      in the list of methods, and means "any method".
    origin: Optional. The list of origins eligible to receive CORS response
      headers. For more information about origins, see [RFC
      6454](https://tools.ietf.org/html/rfc6454). Note: `*` is permitted in
      the list of origins, and means `any origin`.
    responseHeader: Optional. The list of HTTP headers other than the [simple
      response headers](https://www.w3.org/TR/cors/#simple-response-headers)
      to give permission for the user-agent to share across domains.
  """

  maxAgeSeconds = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  method = _messages.StringField(2, repeated=True)
  origin = _messages.StringField(3, repeated=True)
  responseHeader = _messages.StringField(4, repeated=True)


class CrossRegionEgressSpike(_messages.Message):
  r"""Represents a finding about a spike in cross-region egress from Cloud
  Storage. This corresponds to the `CROSS_REGION_EGRESS_SPIKE` finding type.

  Fields:
    percentageIncrease: Output only. The percentage increase in cross-region
      egress across the project.
    topBuckets: Output only. A list of top buckets driving the increase in
      cross-region egress.
    totalEgressBytes: Output only. The total cross-region egress volume in
      bytes across the project.
  """

  percentageIncrease = _messages.FloatField(1)
  topBuckets = _messages.MessageField('IntelligenceFindingCrossRegionEgressSpikeBucketContribution', 2, repeated=True)
  totalEgressBytes = _messages.IntegerField(3)


class CustomPlacementConfig(_messages.Message):
  r"""Configuration for Custom Dual Regions. It should specify precisely two
  eligible regions within the same Multiregion. More information on regions
  may be found [here](https://cloud.google.com/storage/docs/locations).

  Fields:
    dataLocations: List of locations to use for data placement.
  """

  dataLocations = _messages.StringField(1, repeated=True)


class CustomerManagedEncryptionEnforcementConfig(_messages.Message):
  r"""Customer Managed Encryption (CMEK) enforcement config of a bucket.

  Fields:
    effectiveTime: Time from which the config was effective. This is service-
      provided.
    restrictionMode: Restriction mode for customer-managed encryption for new
      objects within the bucket. Valid values are: `NotRestricted` and
      `FullyRestricted`. If `NotRestricted` or unset, creation of new objects
      with customer-managed encryption is allowed. If `FullyRestricted`, new
      objects can't be created using customer-managed encryption.
  """

  effectiveTime = _messages.StringField(1)
  restrictionMode = _messages.StringField(2)


class CustomerSuppliedEncryptionEnforcementConfig(_messages.Message):
  r"""Customer Supplied Encryption (CSEK) enforcement config of a bucket.

  Fields:
    effectiveTime: Time from which the config was effective. This is service-
      provided.
    restrictionMode: Restriction mode for customer-supplied encryption for new
      objects within the bucket. Valid values are: `NotRestricted` and
      `FullyRestricted`. If `NotRestricted` or unset, creation of new objects
      with customer-supplied encryption is allowed. If `FullyRestricted`, new
      objects can't be created using customer-supplied encryption.
  """

  effectiveTime = _messages.StringField(1)
  restrictionMode = _messages.StringField(2)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values. * A month and day, with a zero year (for example, an
  anniversary). * A year on its own, with a zero month and a zero day. * A
  year and month, with a zero day (for example, a credit card expiration
  date). Related types: * google.type.TimeOfDay * google.type.DateTime *
  google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class EffectiveIntelligenceConfig(_messages.Message):
  r"""The effective `IntelligenceConfig` for the resource.

  Enums:
    EffectiveEditionValueValuesEnum: Output only. The `IntelligenceConfig`
      edition that is applicable for the resource.

  Fields:
    effectiveEdition: Output only. The `IntelligenceConfig` edition that is
      applicable for the resource.
    intelligenceConfig: Output only. The `IntelligenceConfig` resource that is
      applied for the target resource. Format: `{organizations|folders|project
      s}/{id}/locations/{location}/intelligenceConfig`
  """

  class EffectiveEditionValueValuesEnum(_messages.Enum):
    r"""Output only. The `IntelligenceConfig` edition that is applicable for
    the resource.

    Values:
      EFFECTIVE_EDITION_UNSPECIFIED: This is an unknown edition of the
        resource.
      NONE: No edition.
      STANDARD: The `IntelligenceConfig` resource is of STANDARD edition.
    """
    EFFECTIVE_EDITION_UNSPECIFIED = 0
    NONE = 1
    STANDARD = 2

  effectiveEdition = _messages.EnumField('EffectiveEditionValueValuesEnum', 1)
  intelligenceConfig = _messages.StringField(2)


class EffectiveManagementHubEdition(_messages.Message):
  r"""The `ManagementHub` edition that is effective for the resource.

  Enums:
    ManagementHubEditionValueValuesEnum: Output only. The `ManagementHub`
      edition that is applicable for the resource.

  Fields:
    managementHub: Output only. The `ManagementHub` resource that is applied
      for the target resource. Format: `{organizations|folders|projects}/{id}/
      locations/{location}/managementHub`
    managementHubEdition: Output only. The `ManagementHub` edition that is
      applicable for the resource.
  """

  class ManagementHubEditionValueValuesEnum(_messages.Enum):
    r"""Output only. The `ManagementHub` edition that is applicable for the
    resource.

    Values:
      MANAGEMENT_HUB_EDITION_UNSPECIFIED: This is an unknown edition of the
        resource.
      NONE: No edition.
      STANDARD: The `ManagementHub` resource is of standard edition.
    """
    MANAGEMENT_HUB_EDITION_UNSPECIFIED = 0
    NONE = 1
    STANDARD = 2

  managementHub = _messages.StringField(1)
  managementHubEdition = _messages.EnumField('ManagementHubEditionValueValuesEnum', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Encryption(_messages.Message):
  r"""Encryption properties of a bucket.

  Fields:
    customerManagedEncryptionEnforcementConfig: Optional. If omitted, then new
      objects with CMEK encryption-type is allowed. If set, then new objects
      created in this bucket must comply with enforcement config. Changing
      this has no effect on existing objects; it applies to new objects only.
    customerSuppliedEncryptionEnforcementConfig: Optional. If omitted, then
      new objects with CSEK encryption-type is allowed. If set, then new
      objects created in this bucket must comply with enforcement config.
      Changing this has no effect on existing objects; it applies to new
      objects only.
    defaultKmsKey: Optional. The name of the Cloud KMS key that is used to
      encrypt objects inserted into this bucket, if no encryption method is
      specified.
    googleManagedEncryptionEnforcementConfig: Optional. If omitted, then new
      objects with GMEK encryption-type is allowed. If set, then new objects
      created in this bucket must comply with enforcement config. Changing
      this has no effect on existing objects; it applies to new objects only.
  """

  customerManagedEncryptionEnforcementConfig = _messages.MessageField('CustomerManagedEncryptionEnforcementConfig', 1)
  customerSuppliedEncryptionEnforcementConfig = _messages.MessageField('CustomerSuppliedEncryptionEnforcementConfig', 2)
  defaultKmsKey = _messages.StringField(3)
  googleManagedEncryptionEnforcementConfig = _messages.MessageField('GoogleManagedEncryptionEnforcementConfig', 4)


class Filter(_messages.Message):
  r"""Filter over location and bucket using include or exclude semantics.
  Resources that match the include or exclude filter are exclusively included
  or excluded from the Storage Intelligence plan.

  Fields:
    excludedCloudStorageBuckets: Buckets to exclude.
    excludedCloudStorageLocations: Bucket locations to exclude.
    includedCloudStorageBuckets: Buckets to include.
    includedCloudStorageLocations: Bucket locations to include.
  """

  excludedCloudStorageBuckets = _messages.MessageField('CloudStorageBuckets', 1)
  excludedCloudStorageLocations = _messages.MessageField('CloudStorageLocations', 2)
  includedCloudStorageBuckets = _messages.MessageField('CloudStorageBuckets', 3)
  includedCloudStorageLocations = _messages.MessageField('CloudStorageLocations', 4)


class FindingSummary(_messages.Message):
  r"""A summary of findings generated for an organization, a folder, or a
  project.

  Enums:
    CategoryValueValuesEnum: Output only. The category of finding.
    SeverityValueValuesEnum: Severity of the finding.
    TypeValueValuesEnum: Output only. The type of the finding.

  Fields:
    category: Output only. The category of finding.
    createTime: Output only. The creation time of the earliest finding that
      this summary is based on.
    severity: Severity of the finding.
    summaryDetails: Output only. List of `SummaryDetails`.
    targetResource: Output only. The fully qualified Cloud resource name for
      which this summary was generated. eg:
      `//cloudresourcemanager.googleapis.com/projects/p1`
    type: Output only. The type of the finding.
    updateTime: Output only. The time of the most recent update among all the
      findings that this summary is based on.
  """

  class CategoryValueValuesEnum(_messages.Enum):
    r"""Output only. The category of finding.

    Values:
      FINDING_CATEGORY_UNSPECIFIED: Category is unspecified.
      FINDING_CATEGORY_DATA_MANAGEMENT: Category is 'Data Management'.
      FINDING_CATEGORY_PERFORMANCE: Category is 'Performance'.
    """
    FINDING_CATEGORY_UNSPECIFIED = 0
    FINDING_CATEGORY_DATA_MANAGEMENT = 1
    FINDING_CATEGORY_PERFORMANCE = 2

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Severity of the finding.

    Values:
      FINDING_SEVERITY_UNSPECIFIED: Severity is unspecified.
      FINDING_SEVERITY_CRITICAL: Severity is critical.
    """
    FINDING_SEVERITY_UNSPECIFIED = 0
    FINDING_SEVERITY_CRITICAL = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the finding.

    Values:
      FINDING_TYPE_UNSPECIFIED: Finding type is unspecified.
      FINDING_TYPE_COLDLINE_AND_ARCHIVAL_STORAGE_OPERATIONS_SPIKE: Finding is
        about a spike in Class A/B operations on Coldline or Archive Cloud
        Storage objects.
      FINDING_TYPE_THROTTLED_REQUEST_SPIKE: Finding is about a spike in
        throttled requests (429 errors) within a project.
      FINDING_TYPE_CROSS_REGION_EGRESS_SPIKE: Finding is about a spike in
        cross region egress in Cloud Storage.
      FINDING_TYPE_STORAGE_GROWTH_ABOVE_TREND: Finding is about growth in
        storage above the expected trend.
      FINDING_TYPE_BANDWIDTH_QUOTA_NEAR_LIMIT: Finding is about bandwidth
        consumption approaching the quota limit.
    """
    FINDING_TYPE_UNSPECIFIED = 0
    FINDING_TYPE_COLDLINE_AND_ARCHIVAL_STORAGE_OPERATIONS_SPIKE = 1
    FINDING_TYPE_THROTTLED_REQUEST_SPIKE = 2
    FINDING_TYPE_CROSS_REGION_EGRESS_SPIKE = 3
    FINDING_TYPE_STORAGE_GROWTH_ABOVE_TREND = 4
    FINDING_TYPE_BANDWIDTH_QUOTA_NEAR_LIMIT = 5

  category = _messages.EnumField('CategoryValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  severity = _messages.EnumField('SeverityValueValuesEnum', 3)
  summaryDetails = _messages.MessageField('SummaryDetails', 4, repeated=True)
  targetResource = _messages.StringField(5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class Folder(_messages.Message):
  r"""A folder resource. This resource can only exist in a hierarchical
  namespace enabled bucket.

  Fields:
    createTime: Output only. The creation time of the folder.
    metageneration: Output only. The version of the metadata for this folder.
      Used for preconditions and for detecting changes in metadata.
    name: Identifier. The name of this folder. Format:
      `projects/{project}/buckets/{bucket}/folders/{folder}`
    pendingDeleteFolderRecursiveInfo: Output only. Only present if the folder
      is part of an ongoing DeleteFolderRecursive operation. Contains
      information which can be used to query the operation status.
    pendingRenameInfo: Output only. Only present if the folder is part of an
      ongoing RenameFolder operation. Contains information which can be used
      to query the operation status. The presence of this field also indicates
      all write operations are blocked for this folder, including folder,
      managed folder, and object operations.
    updateTime: Output only. The modification time of the folder.
  """

  createTime = _messages.StringField(1)
  metageneration = _messages.IntegerField(2)
  name = _messages.StringField(3)
  pendingDeleteFolderRecursiveInfo = _messages.MessageField('PendingDeleteFolderRecursiveInfo', 4)
  pendingRenameInfo = _messages.MessageField('PendingRenameInfo', 5)
  updateTime = _messages.StringField(6)


class GoogleManagedEncryptionEnforcementConfig(_messages.Message):
  r"""Google Managed Encryption (GMEK) enforcement config of a bucket.

  Fields:
    effectiveTime: Time from which the config was effective. This is service-
      provided.
    restrictionMode: Restriction mode for google-managed encryption for new
      objects within the bucket. Valid values are: `NotRestricted` and
      `FullyRestricted`. If `NotRestricted` or unset, creation of new objects
      with google-managed encryption is allowed. If `FullyRestricted`, new
      objects can't be created using google-managed encryption.
  """

  effectiveTime = _messages.StringField(1)
  restrictionMode = _messages.StringField(2)


class GoogleStorageV2CustomPlacementConfig(_messages.Message):
  r"""Configuration for [configurable dual-
  regions](https://cloud.google.com/storage/docs/locations#configurable). It
  should specify precisely two eligible regions within the same multi-region.
  For details, see
  [locations](https://cloud.google.com/storage/docs/locations).

  Fields:
    dataLocations: Optional. List of locations to use for data placement.
  """

  dataLocations = _messages.StringField(1, repeated=True)


class GoogleStorageV2HierarchicalNamespace(_messages.Message):
  r"""Configuration for a bucket's hierarchical namespace feature.

  Fields:
    enabled: Optional. Enables the hierarchical namespace feature.
  """

  enabled = _messages.BooleanField(1)


class HierarchicalNamespace(_messages.Message):
  r"""Configuration for a bucket's hierarchical namespace feature.

  Fields:
    enabled: Enables the hierarchical namespace feature.
  """

  enabled = _messages.BooleanField(1)


class IamConfig(_messages.Message):
  r"""Bucket restriction options.

  Fields:
    publicAccessPrevention: Optional. Whether IAM enforces public access
      prevention. Valid values are `enforced` or `inherited`.
    uniformBucketLevelAccess: Optional. Bucket restriction options currently
      enforced on the bucket.
  """

  publicAccessPrevention = _messages.StringField(1)
  uniformBucketLevelAccess = _messages.MessageField('UniformBucketLevelAccess', 2)


class IntelligenceConfig(_messages.Message):
  r"""The `IntelligenceConfig` resource associated with your organization,
  folder, or project.

  Enums:
    EditionConfigValueValuesEnum: Optional. The edition configuration of the
      `IntelligenceConfig` resource.

  Fields:
    editionConfig: Optional. The edition configuration of the
      `IntelligenceConfig` resource.
    effectiveIntelligenceConfig: Output only. The `IntelligenceConfig`
      resource that is applicable for the resource.
    filter: Optional. Filter over location and bucket.
    name: Identifier. The name of the `IntelligenceConfig` resource associated
      with your organization, folder, or project. The name format varies based
      on the GCP resource hierarchy as follows: * For project:
      `projects/{project_number}/locations/global/intelligenceConfig` * For
      organization:
      `organizations/{org_id}/locations/global/intelligenceConfig` * For
      folder: `folders/{folder_id}/locations/global/intelligenceConfig`
    stats: Output only. Stats from the evaluvation of `IntelligenceConfig`
      resource. The evaluation is triggered when `edition_config` is set to
      `EVALUATE`.
    trialConfig: The trial configuration of the `IntelligenceConfig` resource.
    updateTime: Output only. The time at which the `IntelligenceConfig`
      resource is last updated.
  """

  class EditionConfigValueValuesEnum(_messages.Enum):
    r"""Optional. The edition configuration of the `IntelligenceConfig`
    resource.

    Values:
      EDITION_CONFIG_UNSPECIFIED: This is an unknown edition of the resource.
      INHERIT: The inherited edition from the parent and filters. This is the
        default edition when there is no `IntelligenceConfig` setup for a GCP
        resource.
      DISABLED: The edition configuration is disabled for the
        `IntelligenceConfig` resource and its children. Filters are not
        applicable.
      STANDARD: The `IntelligenceConfig` resource is of STANDARD edition.
      EVALUATE: Initiates a statistical evaluation of your Cloud Storage
        resources that have `IntelligenceConfig` enabled. The evaluation
        process gives the count of objects, buckets, and projects in your
        Cloud Storage environment that would be affected by enabling
        `IntelligenceConfig`. Using the evaluation result, you can estimate
        the cost of enabling `IntelligenceConfig`. When you set the edition
        configuration as `EVALUATE`, the process analyzes your resource and
        all of its child resources without enabling `IntelligenceConfig`. This
        means that Cloud Storage does not charge you for `IntelligenceConfig`
        features during the evaluation, and you won't have access to those
        features similar to a resource in the `DISABLED` state. You can view
        the evaluation results through the `GET` method of the
        `IntelligenceConfig` resource. You can refine the evaluation by using
        filters to specify which buckets you want to include in the analysis.
      TRIAL: The `IntelligenceConfig` resource is available in `TRIAL`
        edition. During the trial period, Cloud Storage does not charge for
        Storage Intelligence usage. You can specify the buckets to include in
        the trial period by using filters. At the end of the trial period, the
        `IntelligenceConfig` resource is upgraded to `STANDARD` edition.
      ESSENTIALS: The `IntelligenceConfig` resource is of ESSENTIALS edition.
    """
    EDITION_CONFIG_UNSPECIFIED = 0
    INHERIT = 1
    DISABLED = 2
    STANDARD = 3
    EVALUATE = 4
    TRIAL = 5
    ESSENTIALS = 6

  editionConfig = _messages.EnumField('EditionConfigValueValuesEnum', 1)
  effectiveIntelligenceConfig = _messages.MessageField('EffectiveIntelligenceConfig', 2)
  filter = _messages.MessageField('Filter', 3)
  name = _messages.StringField(4)
  stats = _messages.MessageField('Stats', 5)
  trialConfig = _messages.MessageField('TrialConfig', 6)
  updateTime = _messages.StringField(7)


class IntelligenceFinding(_messages.Message):
  r"""The `IntelligenceFinding` resource that represents a security,
  performance, or cost-related finding about a project or bucket.

  Enums:
    CategoryValueValuesEnum: Output only. Category of this finding.
    SeverityValueValuesEnum: Output only. Severity of the finding.
    TypeValueValuesEnum: Output only. Type of this finding.

  Fields:
    associatedResources: Output only. Contains GCP resource names that are
      relevant to this `IntelligenceFinding`. The `target_resource` is also
      added as part of `associated_resources`. eg: -
      `storage.googleapis.com/projects/_/buckets/b1` -
      `cloudresourecemanager.googleapis.com/projects/p1`
    bandwidthQuotaNearLimit: Output only. `IntelligenceFinding` about a
      bandwidth consumption approaching the quota limit.
    category: Output only. Category of this finding.
    coldlineAndArchivalStorageOperationsSpike: Output only.
      `IntelligenceFinding` about a spike in Class A/B operations on Coldline
      or Archive Cloud Storage objects.
    createTime: Output only. The time at which the finding was created.
    crossRegionEgressSpike: Output only. `IntelligenceFinding` about a spike
      in cross-region egress.
    description: Output only. A short description about the finding.
    name: Identifier. The resource name of `IntelligenceFinding`. Format: `pro
      jects/{project}/locations/{location}/intelligenceFindings/{intelligence_
      finding}`
    observationPeriod: Output only. The time interval during which the
      underlying data was used to generate this `IntelligenceFinding`.
    severity: Output only. Severity of the finding.
    storageGrowthAboveTrend: Output only. `IntelligenceFinding` about growth
      in storage above the expected trend.
    targetResource: Output only. The fully qualified resource name of the
      resource that this `IntelligenceFinding` applies to. eg: -
      `storage.googleapis.com/projects/_/buckets/b1` -
      `cloudresourecemanager.googleapis.com/projects/p1`
    throttledRequestsSpike: Output only. `IntelligenceFinding` about a spike
      in throttled requests (429 errors) within a project.
    type: Output only. Type of this finding.
    updateTime: Output only. The time at which the finding was last updated.
  """

  class CategoryValueValuesEnum(_messages.Enum):
    r"""Output only. Category of this finding.

    Values:
      FINDING_CATEGORY_UNSPECIFIED: Category is unspecified.
      FINDING_CATEGORY_DATA_MANAGEMENT: Category is 'Data Management'.
      FINDING_CATEGORY_PERFORMANCE: Category is 'Performance'.
    """
    FINDING_CATEGORY_UNSPECIFIED = 0
    FINDING_CATEGORY_DATA_MANAGEMENT = 1
    FINDING_CATEGORY_PERFORMANCE = 2

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Output only. Severity of the finding.

    Values:
      FINDING_SEVERITY_UNSPECIFIED: Severity is unspecified.
      FINDING_SEVERITY_CRITICAL: Severity is critical.
    """
    FINDING_SEVERITY_UNSPECIFIED = 0
    FINDING_SEVERITY_CRITICAL = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of this finding.

    Values:
      FINDING_TYPE_UNSPECIFIED: Finding type is unspecified.
      FINDING_TYPE_COLDLINE_AND_ARCHIVAL_STORAGE_OPERATIONS_SPIKE: Finding is
        about a spike in Class A/B operations on Coldline or Archive Cloud
        Storage objects.
      FINDING_TYPE_THROTTLED_REQUEST_SPIKE: Finding is about a spike in
        throttled requests (429 errors) within a project.
      FINDING_TYPE_CROSS_REGION_EGRESS_SPIKE: Finding is about a spike in
        cross region egress in Cloud Storage.
      FINDING_TYPE_STORAGE_GROWTH_ABOVE_TREND: Finding is about growth in
        storage above the expected trend.
      FINDING_TYPE_BANDWIDTH_QUOTA_NEAR_LIMIT: Finding is about bandwidth
        consumption approaching the quota limit.
    """
    FINDING_TYPE_UNSPECIFIED = 0
    FINDING_TYPE_COLDLINE_AND_ARCHIVAL_STORAGE_OPERATIONS_SPIKE = 1
    FINDING_TYPE_THROTTLED_REQUEST_SPIKE = 2
    FINDING_TYPE_CROSS_REGION_EGRESS_SPIKE = 3
    FINDING_TYPE_STORAGE_GROWTH_ABOVE_TREND = 4
    FINDING_TYPE_BANDWIDTH_QUOTA_NEAR_LIMIT = 5

  associatedResources = _messages.StringField(1, repeated=True)
  bandwidthQuotaNearLimit = _messages.MessageField('BandwidthQuotaNearLimit', 2)
  category = _messages.EnumField('CategoryValueValuesEnum', 3)
  coldlineAndArchivalStorageOperationsSpike = _messages.MessageField('ColdlineAndArchivalStorageOperationsSpike', 4)
  createTime = _messages.StringField(5)
  crossRegionEgressSpike = _messages.MessageField('CrossRegionEgressSpike', 6)
  description = _messages.StringField(7)
  name = _messages.StringField(8)
  observationPeriod = _messages.MessageField('Interval', 9)
  severity = _messages.EnumField('SeverityValueValuesEnum', 10)
  storageGrowthAboveTrend = _messages.MessageField('StorageGrowthAboveTrend', 11)
  targetResource = _messages.StringField(12)
  throttledRequestsSpike = _messages.MessageField('ThrottledRequestSpike', 13)
  type = _messages.EnumField('TypeValueValuesEnum', 14)
  updateTime = _messages.StringField(15)


class IntelligenceFindingBandwidthQuotaNearLimitBucketContribution(_messages.Message):
  r"""Represents the bandwidth consumption details for a bucket.

  Fields:
    bucket: Output only. The name of the bucket.
    contribution: Output only. The details about the contribution of the
      bucket.
    error: Output only. The error related to accessing the details about the
      contribution of the bucket.
    percentageIncrease: Output only. The percentage increase in bandwidth
      consumption for the bucket.
    totalBandwidthConsumptionBytes: Output only. The total bandwidth
      consumption in bytes for the bucket.
  """

  bucket = _messages.StringField(1)
  contribution = _messages.MessageField('IntelligenceFindingBandwidthQuotaNearLimitBucketContributionContribution', 2)
  error = _messages.MessageField('Status', 3)
  percentageIncrease = _messages.FloatField(4)
  totalBandwidthConsumptionBytes = _messages.IntegerField(5)


class IntelligenceFindingBandwidthQuotaNearLimitBucketContributionContribution(_messages.Message):
  r"""Represents the contribution of the bucket towards the
  `IntelligenceFinding`.

  Fields:
    topPrefixes: Output only. A list of top object prefixes driving the
      increase in bandwidth consumption.
    topServiceAccounts: Output only. A list of top service accounts driving
      the increase in bandwidth consumption.
  """

  topPrefixes = _messages.MessageField('IntelligenceFindingBandwidthQuotaNearLimitBucketContributionContributionPrefixContribution', 1, repeated=True)
  topServiceAccounts = _messages.MessageField('IntelligenceFindingBandwidthQuotaNearLimitBucketContributionContributionServiceAccountContribution', 2, repeated=True)


class IntelligenceFindingBandwidthQuotaNearLimitBucketContributionContributionPrefixContribution(_messages.Message):
  r"""Represents the bandwidth consumption details for an object prefix.

  Fields:
    percentageIncrease: Output only. The percentage increase in bandwidth
      consumption for the object prefix.
    prefix: Output only. The object prefix. Format: `a/b/c`, `a/b/d`, etc.
    totalBandwidthConsumptionBytes: Output only. The total bandwidth
      consumption in bytes for the object prefix.
  """

  percentageIncrease = _messages.FloatField(1)
  prefix = _messages.StringField(2)
  totalBandwidthConsumptionBytes = _messages.IntegerField(3)


class IntelligenceFindingBandwidthQuotaNearLimitBucketContributionContributionServiceAccountContribution(_messages.Message):
  r"""Represents the bandwidth consumption details for a service account.

  Fields:
    percentageIncrease: Output only. The percentage increase in bandwidth
      consumption for the service account.
    serviceAccount: Output only. The identifier of the service account.
      Format: `serviceAccount:name@domain.com`, eg
      :`serviceAccount:name@project-id.iam.gserviceaccount.com`, etc.
    totalBandwidthConsumptionBytes: Output only. The total bandwidth
      consumption in bytes for the service account.
  """

  percentageIncrease = _messages.FloatField(1)
  serviceAccount = _messages.StringField(2)
  totalBandwidthConsumptionBytes = _messages.IntegerField(3)


class IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContribution(_messages.Message):
  r"""Represents the operation spike details for a bucket.

  Fields:
    bucket: Output only. The name of the bucket.
    contribution: Output only. The details about the contribution of the
      bucket.
    error: Output only. The error related to accessing the details about the
      contribution of the bucket.
    percentageIncrease: Output only. The percentage increase in operations for
      the bucket.
    totalOperationsCount: Output only. The total count of operations for the
      bucket.
  """

  bucket = _messages.StringField(1)
  contribution = _messages.MessageField('IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContributionContribution', 2)
  error = _messages.MessageField('Status', 3)
  percentageIncrease = _messages.FloatField(4)
  totalOperationsCount = _messages.IntegerField(5)


class IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContributionContribution(_messages.Message):
  r"""Represents the contribution of the bucket towards the
  `IntelligenceFinding`.

  Fields:
    topPrefixes: Output only. A list of the top object prefixes driving the
      increase in operations.
    topServiceAccounts: Output only. A list of the top service accounts
      driving the increase in operations.
  """

  topPrefixes = _messages.MessageField('IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContributionContributionPrefixContribution', 1, repeated=True)
  topServiceAccounts = _messages.MessageField('IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContributionContributionServiceAccountContribution', 2, repeated=True)


class IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContributionContributionPrefixContribution(_messages.Message):
  r"""Represents the operation spike details for an object prefix.

  Fields:
    percentageIncrease: Output only. The percentage increase in operations for
      the object prefix.
    prefix: Output only. The object prefix. Format: `a/b/c`, 'a/b/d', etc.
    totalOperationsCount: Output only. The total count of operations for the
      object prefix.
  """

  percentageIncrease = _messages.FloatField(1)
  prefix = _messages.StringField(2)
  totalOperationsCount = _messages.IntegerField(3)


class IntelligenceFindingColdlineAndArchivalStorageOperationsSpikeBucketContributionContributionServiceAccountContribution(_messages.Message):
  r"""Represents the operation spike details for a service account.

  Fields:
    percentageIncrease: Output only. The percentage increase in operations for
      the service account.
    serviceAccount: Output only. The identifier of the service account.
      Format: `serviceAccount:name@domain.com` eg: `name@project-
      id.iam.gserviceaccount.com`
    totalOperationsCount: Output only. The total count of operations for the
      service account.
  """

  percentageIncrease = _messages.FloatField(1)
  serviceAccount = _messages.StringField(2)
  totalOperationsCount = _messages.IntegerField(3)


class IntelligenceFindingCrossRegionEgressSpikeBucketContribution(_messages.Message):
  r"""Represents the cross-region egress spike details for a bucket.

  Fields:
    bucket: Output only. The name of the bucket.
    contribution: Output only. The details about the contribution of the
      bucket.
    error: Output only. The error related to accessing the details about the
      contribution of the bucket.
    percentageIncrease: Output only. The percentage increase in cross-region
      egress for the bucket.
    totalEgressBytes: Output only. The total cross-region egress volume in
      bytes for the bucket.
  """

  bucket = _messages.StringField(1)
  contribution = _messages.MessageField('IntelligenceFindingCrossRegionEgressSpikeBucketContributionContribution', 2)
  error = _messages.MessageField('Status', 3)
  percentageIncrease = _messages.FloatField(4)
  totalEgressBytes = _messages.IntegerField(5)


class IntelligenceFindingCrossRegionEgressSpikeBucketContributionContribution(_messages.Message):
  r"""Represents the contribution of the bucket towards the
  `IntelligenceFinding`.

  Fields:
    topPrefixes: Output only. A list of the top object prefixes driving the
      increase in cross-region egress.
    topServiceAccounts: Output only. A list of the top service accounts
      driving the increase in cross-region egress.
  """

  topPrefixes = _messages.MessageField('IntelligenceFindingCrossRegionEgressSpikeBucketContributionContributionPrefixContribution', 1, repeated=True)
  topServiceAccounts = _messages.MessageField('IntelligenceFindingCrossRegionEgressSpikeBucketContributionContributionServiceAccountContribution', 2, repeated=True)


class IntelligenceFindingCrossRegionEgressSpikeBucketContributionContributionPrefixContribution(_messages.Message):
  r"""Represents the cross-region egress spike details for an object prefix.

  Fields:
    percentageIncrease: Output only. The percentage increase in cross-region
      egress for the object prefix.
    prefix: Output only. The object prefix. Format: `a/b/c`, 'a/b/d', etc.
    totalEgressBytes: Output only. The total cross-region egress volume in
      bytes from the object prefix.
  """

  percentageIncrease = _messages.FloatField(1)
  prefix = _messages.StringField(2)
  totalEgressBytes = _messages.IntegerField(3)


class IntelligenceFindingCrossRegionEgressSpikeBucketContributionContributionServiceAccountContribution(_messages.Message):
  r"""Represents the cross-region egress spike details for the service
  account.

  Fields:
    percentageIncrease: Output only. The percentage increase in cross-region
      egress for the service account.
    serviceAccount: Output only. The identifier of the service account.
      Format: `serviceAccount:name@domain.com` eg: `name@project-
      id.iam.gserviceaccount.com`
    totalEgressBytes: Output only. The total cross-region egress volume in
      bytes for the service account.
  """

  percentageIncrease = _messages.FloatField(1)
  serviceAccount = _messages.StringField(2)
  totalEgressBytes = _messages.IntegerField(3)


class IntelligenceFindingRevision(_messages.Message):
  r"""An `IntelligenceFindingRevision` represents a specific revision of an
  `IntelligenceFinding` resource.

  Fields:
    createTime: Output only. The timestamp when the revision was created.
    name: Output only. The resource name of `IntelligenceFindingRevision`.
      Format: `projects/{project}/locations/{location}/intelligenceFindings/{i
      ntelligence_finding}/revisions/{revision}`
    snapshot: Output only. The snapshot of the `IntelligenceFinding` at the
      time the revision was created. This field contains the full finding
      details as they existed for the revision.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  snapshot = _messages.MessageField('IntelligenceFinding', 3)


class IntelligenceFindingStorageGrowthAboveTrendBucketContribution(_messages.Message):
  r"""Represents the storage growth details for a bucket.

  Fields:
    bucket: Output only. The name of the bucket.
    contribution: Output only. The details about the contribution of the
      bucket.
    error: Output only. The error related to accessing the details about the
      contribution of the bucket.
    percentageIncrease: Output only. The percentage increase in storage growth
      for the bucket.
    totalStorageGrowthBytes: Output only. The total storage growth in bytes
      for the bucket.
  """

  bucket = _messages.StringField(1)
  contribution = _messages.MessageField('IntelligenceFindingStorageGrowthAboveTrendBucketContributionContribution', 2)
  error = _messages.MessageField('Status', 3)
  percentageIncrease = _messages.FloatField(4)
  totalStorageGrowthBytes = _messages.IntegerField(5)


class IntelligenceFindingStorageGrowthAboveTrendBucketContributionContribution(_messages.Message):
  r"""Represents the contribution of the bucket towards the
  `IntelligenceFinding`.

  Fields:
    topPrefixes: Output only. A list of top object prefixes driving the
      increase in storage growth.
    topServiceAccounts: Output only. A list of the top service accounts
      driving the increase in storage growth.
  """

  topPrefixes = _messages.MessageField('IntelligenceFindingStorageGrowthAboveTrendBucketContributionContributionPrefixContribution', 1, repeated=True)
  topServiceAccounts = _messages.MessageField('IntelligenceFindingStorageGrowthAboveTrendBucketContributionContributionServiceAccountContribution', 2, repeated=True)


class IntelligenceFindingStorageGrowthAboveTrendBucketContributionContributionPrefixContribution(_messages.Message):
  r"""Represents the storage growth details for an object prefix.

  Fields:
    percentageIncrease: Output only. The percentage increase in storage growth
      for the object prefix.
    prefix: Output only. The object prefix. Format: `a/b/c`, 'a/b/d', etc.
    totalStorageGrowthBytes: Output only. The total storage growth in bytes
      for the object prefix.
  """

  percentageIncrease = _messages.FloatField(1)
  prefix = _messages.StringField(2)
  totalStorageGrowthBytes = _messages.IntegerField(3)


class IntelligenceFindingStorageGrowthAboveTrendBucketContributionContributionServiceAccountContribution(_messages.Message):
  r"""Represents the storage growth details for a service account.

  Fields:
    percentageIncrease: Output only. The percentage increase in storage growth
      for the service account.
    serviceAccount: Output only. The identifier of the service account.
      Format: `serviceAccount:name@domain.com` eg: `name@project-
      id.iam.gserviceaccount.com`
    totalStorageGrowthBytes: Output only. The total storage growth in bytes
      for the service account.
  """

  percentageIncrease = _messages.FloatField(1)
  serviceAccount = _messages.StringField(2)
  totalStorageGrowthBytes = _messages.IntegerField(3)


class IntelligenceFindingThrottledRequestSpikeBucketContribution(_messages.Message):
  r"""Represents the throttled requests details for a bucket.

  Fields:
    bucket: Output only. The name of the bucket.
    contribution: Output only. The details about the contribution of the
      bucket.
    error: Output only. The error related to accessing the details about the
      contribution of the bucket.
    percentageIncrease: Output only. The percentage increase in throttled
      requests for the bucket.
    throttledRequests: Output only. The count of throttled requests for the
      bucket.
  """

  bucket = _messages.StringField(1)
  contribution = _messages.MessageField('IntelligenceFindingThrottledRequestSpikeBucketContributionContribution', 2)
  error = _messages.MessageField('Status', 3)
  percentageIncrease = _messages.FloatField(4)
  throttledRequests = _messages.IntegerField(5)


class IntelligenceFindingThrottledRequestSpikeBucketContributionContribution(_messages.Message):
  r"""Represents the contribution of the bucket towards the
  `IntelligenceFinding`.

  Fields:
    topPrefixes: Output only. A list of top object prefixes driving the
      increase in throttled requests.
    topServiceAccounts: Output only. A list of the top service accounts
      driving the increase in throttled requests.
  """

  topPrefixes = _messages.MessageField('IntelligenceFindingThrottledRequestSpikeBucketContributionContributionPrefixContribution', 1, repeated=True)
  topServiceAccounts = _messages.MessageField('IntelligenceFindingThrottledRequestSpikeBucketContributionContributionServiceAccountContribution', 2, repeated=True)


class IntelligenceFindingThrottledRequestSpikeBucketContributionContributionPrefixContribution(_messages.Message):
  r"""Represents throttled requests details for an object prefix.

  Fields:
    percentageIncrease: The percentage increase in throttled requests for the
      object prefix.
    prefix: Output only. The object prefix. Format: `a/b/c`, 'a/b/d', etc.
    throttledRequests: Output only. The count of throttled requests for the
      object prefix.
  """

  percentageIncrease = _messages.FloatField(1)
  prefix = _messages.StringField(2)
  throttledRequests = _messages.IntegerField(3)


class IntelligenceFindingThrottledRequestSpikeBucketContributionContributionServiceAccountContribution(_messages.Message):
  r"""Represents the throttled requests details for a service account.

  Fields:
    percentageIncrease: Output only. The percentage increase in throttled
      requests for the service account.
    serviceAccount: Output only. The identifier of the service account.
      Format: `serviceAccount:name@domain.com` eg: `name@project-
      id.iam.gserviceaccount.com`
    throttledRequests: Output only. The count of throttled requests for the
      service account.
  """

  percentageIncrease = _messages.FloatField(1)
  serviceAccount = _messages.StringField(2)
  throttledRequests = _messages.IntegerField(3)


class Interval(_messages.Message):
  r"""Represents a time interval, encoded as a Timestamp start (inclusive) and
  a Timestamp end (exclusive). The start must be less than or equal to the
  end. When the start equals the end, the interval is empty (matches no time).
  When both start and end are unspecified, the interval matches any time.

  Fields:
    endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    startTime: Optional. Inclusive start of the interval. If specified, a
      Timestamp matching this interval will have to be the same or after the
      start.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class IpFilter(_messages.Message):
  r"""The [bucket IP filtering](https://cloud.google.com/storage/docs/ip-
  filtering-overview) configuration. Specifies the network sources that can
  access the bucket, as well as its underlying objects.

  Fields:
    allowAllServiceAgentAccess: Whether or not to allow all P4SA access to the
      bucket. When set to true, IP filter config validation doesn't apply.
    allowCrossOrgVpcs: Optional. Whether or not to allow VPCs from orgs
      different than the bucket's parent org to access the bucket. When set to
      true, validations on the existence of the VPCs won't be performed. If
      set to false, each VPC network source is checked to belong to the same
      org as the bucket as well as validated for existence.
    mode: The state of the IP filter configuration. Valid values are `Enabled`
      and `Disabled`. When set to `Enabled`, IP filtering rules are applied to
      a bucket and all incoming requests to the bucket are evaluated against
      these rules. When set to `Disabled`, IP filtering rules are not applied
      to a bucket.
    publicNetworkSource: Public IPs allowed to operate or access the bucket.
    vpcNetworkSources: Optional. The list of network sources that are allowed
      to access operations on the bucket or the underlying objects.
  """

  allowAllServiceAgentAccess = _messages.BooleanField(1)
  allowCrossOrgVpcs = _messages.BooleanField(2)
  mode = _messages.StringField(3)
  publicNetworkSource = _messages.MessageField('PublicNetworkSource', 4)
  vpcNetworkSources = _messages.MessageField('VpcNetworkSource', 5, repeated=True)


class Lifecycle(_messages.Message):
  r"""Lifecycle properties of a bucket. For more information, see [Object
  Lifecycle Management](https://cloud.google.com/storage/docs/lifecycle).

  Fields:
    rule: Optional. A lifecycle management rule, which is made of an action to
      take and the condition under which the action is taken.
  """

  rule = _messages.MessageField('Rule', 1, repeated=True)


class ListFoldersResponse(_messages.Message):
  r"""Response message for ListFolders.

  Fields:
    folders: The list of child folders
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  folders = _messages.MessageField('Folder', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListIntelligenceFindingRevisionsResponse(_messages.Message):
  r"""Response message to list `IntelligenceFindingRevision` resources
  associated with a project.

  Fields:
    intelligenceFindingRevisions: The `IntelligenceFindingRevision` resources
      from the specified project.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page.
  """

  intelligenceFindingRevisions = _messages.MessageField('IntelligenceFindingRevision', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListIntelligenceFindingsResponse(_messages.Message):
  r"""Response message to list the `IntelligenceFinding` resources associated
  with a project.

  Fields:
    intelligenceFindings: The `IntelligenceFinding` resources from the
      specified project.
    nextPageToken: A token to retrieve the next page of results. Pass this
      value in the `page_token` field in the subsequent call.
  """

  intelligenceFindings = _messages.MessageField('IntelligenceFinding', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class LocationalContribution(_messages.Message):
  r"""Represents the bandwidth consumption details for a specific location.

  Fields:
    location: Output only. The location where the bandwidth consumption spike
      occurred. Format: `us-central1`, `us`, `global`, etc.
    percentageIncrease: Output only. The percentage increase in bandwidth
      consumption for the location.
    totalBandwidthConsumptionBytes: Output only. The total bandwidth
      consumption in bytes for the location.
  """

  location = _messages.StringField(1)
  percentageIncrease = _messages.FloatField(2)
  totalBandwidthConsumptionBytes = _messages.IntegerField(3)


class Logging(_messages.Message):
  r"""Logging-related properties of a bucket.

  Fields:
    logBucket: Optional. The destination bucket where the current bucket's
      logs should be placed, using path format (like
      `projects/123456/buckets/foo`).
    logObjectPrefix: Optional. A prefix for log object names.
  """

  logBucket = _messages.StringField(1)
  logObjectPrefix = _messages.StringField(2)


class ManagementHub(_messages.Message):
  r"""The `ManagementHub` resource associated with your organization, folder,
  or project.

  Enums:
    EditionConfigValueValuesEnum: Optional. The edition configuration of the
      `ManagementHub` resource.

  Fields:
    editionConfig: Optional. The edition configuration of the `ManagementHub`
      resource.
    effectiveManagementHubEdition: Output only. The effective `ManagementHub`
      resource edition that is applicable for the resource.
    filter: Optional. Filter over location and bucket.
    managementHubStats: Output only. The evaluation results you get when you
      trigger the statistics of the `ManagementHub` resource. The evaluation
      is triggered when you set the `edition_configuration` field to
      `EVALUATE`.
    name: Identifier. The name of the `ManagementHub` resource associated with
      your organization, folder, or project. The name format varies based on
      the scope as follows: * For project:
      `projects/{project_number}/locations/global/managementHub` * For
      organization: `organizations/{org_id}/locations/global/managementHub` *
      For folder: `folders/{folder_id}/locations/global/managementHub`
    trialConfig: Output only. The trial configuration of the `ManagementHub`
      resource.
    updateTime: Output only. The time at which the `ManagementHub` resource is
      last updated.
  """

  class EditionConfigValueValuesEnum(_messages.Enum):
    r"""Optional. The edition configuration of the `ManagementHub` resource.

    Values:
      EDITION_CONFIG_UNSPECIFIED: This is an unknown edition of the resource.
      INHERIT: The inherited edition from the parent and filters. This is the
        default edition when there is no `ManagementHub` setup for a GCP
        resource.
      DISABLED: The edition configuration is disabled for the `ManagementHub`
        resource and its children. Filters are not applicable.
      STANDARD: The `ManagementHub` resource is of standard edition.
      EVALUATE: Initiates a statistical evaluation of your Cloud Storage
        resources that have `ManagementHub` enabled. The evaluation process
        gives the count of objects, buckets, and projects in your Cloud
        Storage environment that would be affected by enabling
        `ManagementHub`. Using the evaluation result, you can estimate the
        cost of enabling `ManagementHub`. When you set the edition
        configuration as `EVALUATE`, the process analyzes your resource and
        all of its child resources without enabling `ManagementHub`. This
        means that Cloud Storage does not charge you for `ManagementHub`
        features during the evaluation, and you won't have access to those
        features similar to a resource in the `DISABLED` state. You can view
        the evaluation results through the `GET` method of the `ManagementHub`
        resource. You can refine the evaluation by using filters to specify
        which buckets you want to include in the analysis. Filters are
        applicable.
      TRIAL: The `ManagementHub` resource is available in `TRIAL` edition.
        During the trial period, Cloud Storage does not charge for Storage
        Management Hub usage. You can specify the buckets to include in the
        trial period by using filters. At the end of the trial period, the
        `ManagementHub` resource is upgraded to `STANDARD` edition.
    """
    EDITION_CONFIG_UNSPECIFIED = 0
    INHERIT = 1
    DISABLED = 2
    STANDARD = 3
    EVALUATE = 4
    TRIAL = 5

  editionConfig = _messages.EnumField('EditionConfigValueValuesEnum', 1)
  effectiveManagementHubEdition = _messages.MessageField('EffectiveManagementHubEdition', 2)
  filter = _messages.MessageField('ManagementHubFilter', 3)
  managementHubStats = _messages.MessageField('ManagementHubStats', 4)
  name = _messages.StringField(5)
  trialConfig = _messages.MessageField('ManagementHubTrialConfig', 6)
  updateTime = _messages.StringField(7)


class ManagementHubFilter(_messages.Message):
  r"""Filter over location and bucket using include or exclude semantics.
  Resources that match the include or exclude filter are exclusively included
  or excluded from the Management Hub plan.

  Fields:
    excludedCloudStorageBuckets: Buckets to include or exclude.
    excludedCloudStorageLocations: Bucket locations to exclude.
    includedCloudStorageBuckets: Buckets to include or exclude.
    includedCloudStorageLocations: Bucket locations to include.
  """

  excludedCloudStorageBuckets = _messages.MessageField('ManagementHubFilterCloudStorageBuckets', 1)
  excludedCloudStorageLocations = _messages.MessageField('ManagementHubFilterCloudStorageLocations', 2)
  includedCloudStorageBuckets = _messages.MessageField('ManagementHubFilterCloudStorageBuckets', 3)
  includedCloudStorageLocations = _messages.MessageField('ManagementHubFilterCloudStorageLocations', 4)


class ManagementHubFilterCloudStorageBuckets(_messages.Message):
  r"""Collection of buckets.

  Fields:
    cloudStorageBuckets: Optional. Buckets to include or exclude.
  """

  cloudStorageBuckets = _messages.MessageField('CloudStorageBucket', 1, repeated=True)


class ManagementHubFilterCloudStorageLocations(_messages.Message):
  r"""Collection of bucket locations.

  Fields:
    locations: Optional. Bucket locations. Location can be any of the Cloud
      Storage regions specified in lower case format. For example, `us-east1`,
      `us-west1`.
  """

  locations = _messages.StringField(1, repeated=True)


class ManagementHubStats(_messages.Message):
  r"""The statistics of `ManagementHub`.

  Enums:
    ProcessingStateValueValuesEnum: Output only. The processing state of
      management hub stats.

  Fields:
    bucketCount: Output only. The number of buckets within the `ManagementHub`
      scope.
    objectCount: Output only. The number of objects within the `ManagementHub`
      scope.
    processingState: Output only. The processing state of management hub
      stats.
    projectCount: Output only. The number of projects within the
      `ManagementHub` scope.
    snapshotTime: Output only. The snapshot time of the reported stats.
  """

  class ProcessingStateValueValuesEnum(_messages.Enum):
    r"""Output only. The processing state of management hub stats.

    Values:
      PROCESSING_STATE_UNSPECIFIED: Unspecified processing state.
      IN_PROGRESS: Processing is in progress.
      COMPLETED: Processing is completed.
      FAILED: Processing failed.
    """
    PROCESSING_STATE_UNSPECIFIED = 0
    IN_PROGRESS = 1
    COMPLETED = 2
    FAILED = 3

  bucketCount = _messages.IntegerField(1)
  objectCount = _messages.IntegerField(2)
  processingState = _messages.EnumField('ProcessingStateValueValuesEnum', 3)
  projectCount = _messages.IntegerField(4)
  snapshotTime = _messages.StringField(5)


class ManagementHubTrialConfig(_messages.Message):
  r"""The trial configuration of the `ManagementHub` resource.

  Fields:
    expireTime: Output only. The time at which the trial expires.
  """

  expireTime = _messages.StringField(1)


class ObjectAccessControl(_messages.Message):
  r"""An access-control entry.

  Fields:
    domain: Optional. The domain associated with the entity, if any.
    email: Optional. The email address associated with the entity, if any.
    entity: Optional. The entity holding the permission, in one of the
      following forms: * `user-{userid}` * `user-{email}` * `group-{groupid}`
      * `group-{email}` * `domain-{domain}` * `project-{team}-{projectnumber}`
      * `project-{team}-{projectid}` * `allUsers` * `allAuthenticatedUsers`
      Examples: * The user `liz@example.com` would be `user-liz@example.com`.
      * The group `example@googlegroups.com` would be `group-
      example@googlegroups.com`. * All members of the Google Apps for Business
      domain `example.com` would be `domain-example.com`. For project
      entities, `project-{team}-{projectnumber}` format is returned in the
      response.
    entityAlt: Output only. The alternative entity format, if exists. For
      project entities, `project-{team}-{projectid}` format is returned in the
      response.
    entityId: Optional. The ID for the entity, if any.
    etag: Optional. The etag of the ObjectAccessControl. If included in the
      metadata of an update or delete request message, the operation is only
      performed if the etag matches that of the live object's
      ObjectAccessControl.
    id: Optional. The ID of the access-control entry.
    projectTeam: Optional. The project team associated with the entity, if
      any.
    role: Optional. The access permission for the entity. One of the following
      values: * `READER` * `WRITER` * `OWNER`
  """

  domain = _messages.StringField(1)
  email = _messages.StringField(2)
  entity = _messages.StringField(3)
  entityAlt = _messages.StringField(4)
  entityId = _messages.StringField(5)
  etag = _messages.StringField(6)
  id = _messages.StringField(7)
  projectTeam = _messages.MessageField('ProjectTeam', 8)
  role = _messages.StringField(9)


class ObjectRetention(_messages.Message):
  r"""Object Retention related properties of a bucket.

  Fields:
    enabled: Optional. Output only. If true, object retention is enabled for
      the bucket.
  """

  enabled = _messages.BooleanField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Owner(_messages.Message):
  r"""The owner of a specific resource.

  Fields:
    entity: Optional. The entity, in the form `user-`*userId*.
    entityId: Optional. The ID for the entity.
  """

  entity = _messages.StringField(1)
  entityId = _messages.StringField(2)


class PendingDeleteFolderRecursiveInfo(_messages.Message):
  r"""Contains information about a pending recursive delete operation.

  Fields:
    operation: Output only. The name of the recursive delete operation.
  """

  operation = _messages.StringField(1)


class PendingRenameInfo(_messages.Message):
  r"""Contains information about a pending rename operation.

  Fields:
    operation: Output only. The name of the rename operation.
  """

  operation = _messages.StringField(1)


class ProjectTeam(_messages.Message):
  r"""Represents the Viewers, Editors, or Owners of a given project.

  Fields:
    projectNumber: Optional. The project number.
    team: Optional. The team.
  """

  projectNumber = _messages.StringField(1)
  team = _messages.StringField(2)


class PublicNetworkSource(_messages.Message):
  r"""The public network IP address ranges that can access the bucket and its
  data.

  Fields:
    allowedIpCidrRanges: Optional. The list of IPv4 and IPv6 cidr blocks that
      are allowed to operate or access the bucket and its underlying objects.
  """

  allowedIpCidrRanges = _messages.StringField(1, repeated=True)


class RenameFolderMetadata(_messages.Message):
  r"""Message returned in the metadata field of the Operation resource for
  RenameFolder operations.

  Fields:
    commonMetadata: Generic metadata for the long running operation.
    destinationFolderId: The path of the destination folder.
    sourceFolderId: The path of the source folder.
  """

  commonMetadata = _messages.MessageField('CommonLongRunningOperationMetadata', 1)
  destinationFolderId = _messages.StringField(2)
  sourceFolderId = _messages.StringField(3)


class RenameFolderRequest(_messages.Message):
  r"""Request message for RenameFolder. This operation is only applicable to a
  hierarchical namespace enabled bucket.

  Fields:
    destinationFolderId: Required. The destination folder ID, e.g. `foo/bar/`.
    ifMetagenerationMatch: Makes the operation only succeed conditional on
      whether the source folder's current metageneration matches the given
      value.
    ifMetagenerationNotMatch: Makes the operation only succeed conditional on
      whether the source folder's current metageneration does not match the
      given value.
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted. This request
      is only idempotent if a `request_id` is provided.
  """

  destinationFolderId = _messages.StringField(1)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)
  requestId = _messages.StringField(4)


class RetentionPolicy(_messages.Message):
  r"""Retention policy properties of a bucket.

  Fields:
    effectiveTime: Optional. Server-determined value that indicates the time
      from which policy was enforced and effective.
    isLocked: Optional. Once locked, an object retention policy cannot be
      modified.
    retentionDuration: Optional. The duration that objects need to be
      retained. Retention duration must be greater than zero and less than 100
      years. Note that enforcement of retention periods less than a day is not
      guaranteed. Such periods should only be used for testing purposes. Any
      `nanos` value specified is rounded down to the nearest second.
  """

  effectiveTime = _messages.StringField(1)
  isLocked = _messages.BooleanField(2)
  retentionDuration = _messages.StringField(3)


class Rule(_messages.Message):
  r"""A lifecycle Rule, combining an action to take on an object and a
  condition which triggers that action.

  Fields:
    action: Optional. The action to take.
    condition: Optional. The condition under which the action is taken.
  """

  action = _messages.MessageField('Action', 1)
  condition = _messages.MessageField('Condition', 2)


class SoftDeletePolicy(_messages.Message):
  r"""Soft delete policy properties of a bucket.

  Fields:
    effectiveTime: Time from which the policy was effective. This is service-
      provided.
    retentionDuration: The period of time that soft-deleted objects in the
      bucket must be retained and cannot be permanently deleted. The duration
      must be greater than or equal to 7 days and less than 1 year.
  """

  effectiveTime = _messages.StringField(1)
  retentionDuration = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Stats(_messages.Message):
  r"""The statistics of `IntelligenceConfig`.

  Enums:
    ProcessingStateValueValuesEnum: Output only. The processing state of
      stats.

  Fields:
    bucketCount: Output only. The number of buckets within the
      `IntelligenceConfig` scope.
    objectCount: Output only. The number of objects within the
      `IntelligenceConfig` scope.
    processingState: Output only. The processing state of stats.
    projectCount: Output only. The number of projects within the
      `IntelligenceConfig` scope.
    snapshotTime: Output only. The snapshot time of the reported stats.
  """

  class ProcessingStateValueValuesEnum(_messages.Enum):
    r"""Output only. The processing state of stats.

    Values:
      PROCESSING_STATE_UNSPECIFIED: Unspecified processing state.
      IN_PROGRESS: Processing is in progress.
      COMPLETED: Processing is completed.
      FAILED: Processing failed.
    """
    PROCESSING_STATE_UNSPECIFIED = 0
    IN_PROGRESS = 1
    COMPLETED = 2
    FAILED = 3

  bucketCount = _messages.IntegerField(1)
  objectCount = _messages.IntegerField(2)
  processingState = _messages.EnumField('ProcessingStateValueValuesEnum', 3)
  projectCount = _messages.IntegerField(4)
  snapshotTime = _messages.StringField(5)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageFoldersLocationsGetIntelligenceConfigRequest(_messages.Message):
  r"""A StorageFoldersLocationsGetIntelligenceConfigRequest object.

  Fields:
    name: Required. The name of the `IntelligenceConfig` resource associated
      with your folder. Format:
      `folders/{id}/locations/global/intelligenceConfig`
  """

  name = _messages.StringField(1, required=True)


class StorageFoldersLocationsGetManagementHubRequest(_messages.Message):
  r"""A StorageFoldersLocationsGetManagementHubRequest object.

  Fields:
    name: Required. The name of the `ManagementHub` resource associated with
      your folder. Format: `folders/{id}/locations/global/managementHub`
  """

  name = _messages.StringField(1, required=True)


class StorageFoldersLocationsIntelligenceFindingsSummarizeRequest(_messages.Message):
  r"""A StorageFoldersLocationsIntelligenceFindingsSummarizeRequest object.

  Enums:
    ResourceScopeValueValuesEnum: Optional. Determines the granularity of the
      findings when the `parent` is an organization or folder. - `PARENT` (or
      not set): A single summary is returned for each insight type, aggregated
      across the entire `parent` scope. - `PROJECT`: A separate summary is
      returned for each insight type for every project within the `parent`
      scope. The only supported values are `PARENT` and `PROJECT`. If no value
      is specified, the API behaviour defaults to the `PARENT`.

  Fields:
    filter: Optional. The filter expression, following AIP-160. Supports
      filtering by FindingType.
    pageSize: Optional. The maximum number of findings to return. The maximum
      value is `100`; values above `100` will be coerced to `100`. The default
      value is `100`.
    pageToken: Optional. A page token, received from a previous
      `SummarizeIntelligenceFindings` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `SummarizeIntelligenceFindings` must match the call that provided the
      page token.
    parent: Required. The scope to summarize the findings for. Format: -
      `organizations/{organization}/locations/{location}` -
      `folders/{folder}/locations/{location}` -
      `projects/{project}/locations/{location}`
    resourceScope: Optional. Determines the granularity of the findings when
      the `parent` is an organization or folder. - `PARENT` (or not set): A
      single summary is returned for each insight type, aggregated across the
      entire `parent` scope. - `PROJECT`: A separate summary is returned for
      each insight type for every project within the `parent` scope. The only
      supported values are `PARENT` and `PROJECT`. If no value is specified,
      the API behaviour defaults to the `PARENT`.
  """

  class ResourceScopeValueValuesEnum(_messages.Enum):
    r"""Optional. Determines the granularity of the findings when the `parent`
    is an organization or folder. - `PARENT` (or not set): A single summary is
    returned for each insight type, aggregated across the entire `parent`
    scope. - `PROJECT`: A separate summary is returned for each insight type
    for every project within the `parent` scope. The only supported values are
    `PARENT` and `PROJECT`. If no value is specified, the API behaviour
    defaults to the `PARENT`.

    Values:
      RESOURCE_SCOPE_UNSPECIFIED: The default behavior. Falls back to PARENT
        behaviour
      PARENT: Summaries are aggregated at the level of the `parent` resource.
      PROJECT: Summaries are broken down by each project within the `parent`
        scope.
    """
    RESOURCE_SCOPE_UNSPECIFIED = 0
    PARENT = 1
    PROJECT = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  resourceScope = _messages.EnumField('ResourceScopeValueValuesEnum', 5)


class StorageFoldersLocationsUpdateIntelligenceConfigRequest(_messages.Message):
  r"""A StorageFoldersLocationsUpdateIntelligenceConfigRequest object.

  Fields:
    intelligenceConfig: A IntelligenceConfig resource to be passed as the
      request body.
    name: Identifier. The name of the `IntelligenceConfig` resource associated
      with your organization, folder, or project. The name format varies based
      on the GCP resource hierarchy as follows: * For project:
      `projects/{project_number}/locations/global/intelligenceConfig` * For
      organization:
      `organizations/{org_id}/locations/global/intelligenceConfig` * For
      folder: `folders/{folder_id}/locations/global/intelligenceConfig`
    requestId: Optional. The ID that uniquely identifies the request,
      preventing duplicate processing.
    updateMask: Required. The `update_mask` that specifies the fields within
      the `IntelligenceConfig` resource that should be modified by this
      update. Only the listed fields are updated.
  """

  intelligenceConfig = _messages.MessageField('IntelligenceConfig', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageFoldersLocationsUpdateManagementHubRequest(_messages.Message):
  r"""A StorageFoldersLocationsUpdateManagementHubRequest object.

  Fields:
    managementHub: A ManagementHub resource to be passed as the request body.
    name: Identifier. The name of the `ManagementHub` resource associated with
      your organization, folder, or project. The name format varies based on
      the scope as follows: * For project:
      `projects/{project_number}/locations/global/managementHub` * For
      organization: `organizations/{org_id}/locations/global/managementHub` *
      For folder: `folders/{folder_id}/locations/global/managementHub`
    requestId: Optional. The ID that uniquely identifies the request,
      preventing duplicate processing.
    updateMask: Required. The `update_mask` that specifies the fields within
      the `ManagementHub` resource that should be modified by this update.
      Only the listed fields are updated.
  """

  managementHub = _messages.MessageField('ManagementHub', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageGrowthAboveTrend(_messages.Message):
  r"""Represents a finding about a storage growth above the expected trend.
  This corresponds to the `STORAGE_GROWTH_ABOVE_TREND` finding type.

  Fields:
    percentageIncrease: Output only. The percentage increase in storage
      growth.
    topBuckets: Output only. A list of top buckets driving the increase in
      storage growth.
    totalStorageGrowthBytes: Output only. The total storage growth in bytes.
  """

  percentageIncrease = _messages.FloatField(1)
  topBuckets = _messages.MessageField('IntelligenceFindingStorageGrowthAboveTrendBucketContribution', 2, repeated=True)
  totalStorageGrowthBytes = _messages.IntegerField(3)


class StorageLayout(_messages.Message):
  r"""The storage layout configuration of a bucket.

  Fields:
    customPlacementConfig: Output only. The data placement configuration for
      custom dual region. If there is no configuration, this is not a custom
      dual region bucket.
    hierarchicalNamespace: Output only. The bucket's hierarchical namespace
      configuration. If there is no configuration, the hierarchical namespace
      is disabled.
    location: Output only. The location of the bucket.
    locationType: Output only. The location type of the bucket (region, dual-
      region, multi-region, etc).
    name: Output only. The name of the StorageLayout resource. Format:
      `projects/{project}/buckets/{bucket}/storageLayout`
  """

  customPlacementConfig = _messages.MessageField('CustomPlacementConfig', 1)
  hierarchicalNamespace = _messages.MessageField('HierarchicalNamespace', 2)
  location = _messages.StringField(3)
  locationType = _messages.StringField(4)
  name = _messages.StringField(5)


class StorageOrganizationsLocationsGetIntelligenceConfigRequest(_messages.Message):
  r"""A StorageOrganizationsLocationsGetIntelligenceConfigRequest object.

  Fields:
    name: Required. The name of the `IntelligenceConfig` resource associated
      with your organization. Format:
      `organizations/{org_id}/locations/global/intelligenceConfig`
  """

  name = _messages.StringField(1, required=True)


class StorageOrganizationsLocationsGetManagementHubRequest(_messages.Message):
  r"""A StorageOrganizationsLocationsGetManagementHubRequest object.

  Fields:
    name: Required. The name of the `ManagementHub` resource associated with
      your organization. Format:
      `organizations/{org_id}/locations/global/managementHub`
  """

  name = _messages.StringField(1, required=True)


class StorageOrganizationsLocationsIntelligenceFindingsSummarizeRequest(_messages.Message):
  r"""A StorageOrganizationsLocationsIntelligenceFindingsSummarizeRequest
  object.

  Enums:
    ResourceScopeValueValuesEnum: Optional. Determines the granularity of the
      findings when the `parent` is an organization or folder. - `PARENT` (or
      not set): A single summary is returned for each insight type, aggregated
      across the entire `parent` scope. - `PROJECT`: A separate summary is
      returned for each insight type for every project within the `parent`
      scope. The only supported values are `PARENT` and `PROJECT`. If no value
      is specified, the API behaviour defaults to the `PARENT`.

  Fields:
    filter: Optional. The filter expression, following AIP-160. Supports
      filtering by FindingType.
    pageSize: Optional. The maximum number of findings to return. The maximum
      value is `100`; values above `100` will be coerced to `100`. The default
      value is `100`.
    pageToken: Optional. A page token, received from a previous
      `SummarizeIntelligenceFindings` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `SummarizeIntelligenceFindings` must match the call that provided the
      page token.
    parent: Required. The scope to summarize the findings for. Format: -
      `organizations/{organization}/locations/{location}` -
      `folders/{folder}/locations/{location}` -
      `projects/{project}/locations/{location}`
    resourceScope: Optional. Determines the granularity of the findings when
      the `parent` is an organization or folder. - `PARENT` (or not set): A
      single summary is returned for each insight type, aggregated across the
      entire `parent` scope. - `PROJECT`: A separate summary is returned for
      each insight type for every project within the `parent` scope. The only
      supported values are `PARENT` and `PROJECT`. If no value is specified,
      the API behaviour defaults to the `PARENT`.
  """

  class ResourceScopeValueValuesEnum(_messages.Enum):
    r"""Optional. Determines the granularity of the findings when the `parent`
    is an organization or folder. - `PARENT` (or not set): A single summary is
    returned for each insight type, aggregated across the entire `parent`
    scope. - `PROJECT`: A separate summary is returned for each insight type
    for every project within the `parent` scope. The only supported values are
    `PARENT` and `PROJECT`. If no value is specified, the API behaviour
    defaults to the `PARENT`.

    Values:
      RESOURCE_SCOPE_UNSPECIFIED: The default behavior. Falls back to PARENT
        behaviour
      PARENT: Summaries are aggregated at the level of the `parent` resource.
      PROJECT: Summaries are broken down by each project within the `parent`
        scope.
    """
    RESOURCE_SCOPE_UNSPECIFIED = 0
    PARENT = 1
    PROJECT = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  resourceScope = _messages.EnumField('ResourceScopeValueValuesEnum', 5)


class StorageOrganizationsLocationsUpdateIntelligenceConfigRequest(_messages.Message):
  r"""A StorageOrganizationsLocationsUpdateIntelligenceConfigRequest object.

  Fields:
    intelligenceConfig: A IntelligenceConfig resource to be passed as the
      request body.
    name: Identifier. The name of the `IntelligenceConfig` resource associated
      with your organization, folder, or project. The name format varies based
      on the GCP resource hierarchy as follows: * For project:
      `projects/{project_number}/locations/global/intelligenceConfig` * For
      organization:
      `organizations/{org_id}/locations/global/intelligenceConfig` * For
      folder: `folders/{folder_id}/locations/global/intelligenceConfig`
    requestId: Optional. The ID that uniquely identifies the request,
      preventing duplicate processing.
    updateMask: Required. The `update_mask` that specifies the fields within
      the `IntelligenceConfig` resource that should be modified by this
      update. Only the listed fields are updated.
  """

  intelligenceConfig = _messages.MessageField('IntelligenceConfig', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageOrganizationsLocationsUpdateManagementHubRequest(_messages.Message):
  r"""A StorageOrganizationsLocationsUpdateManagementHubRequest object.

  Fields:
    managementHub: A ManagementHub resource to be passed as the request body.
    name: Identifier. The name of the `ManagementHub` resource associated with
      your organization, folder, or project. The name format varies based on
      the scope as follows: * For project:
      `projects/{project_number}/locations/global/managementHub` * For
      organization: `organizations/{org_id}/locations/global/managementHub` *
      For folder: `folders/{folder_id}/locations/global/managementHub`
    requestId: Optional. The ID that uniquely identifies the request,
      preventing duplicate processing.
    updateMask: Required. The `update_mask` that specifies the fields within
      the `ManagementHub` resource that should be modified by this update.
      Only the listed fields are updated.
  """

  managementHub = _messages.MessageField('ManagementHub', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageProjectsBucketsFoldersCreateRequest(_messages.Message):
  r"""A StorageProjectsBucketsFoldersCreateRequest object.

  Fields:
    folder: A Folder resource to be passed as the request body.
    folderId: Required. The full name of a folder, including all its parent
      folders. Folders use single '/' characters as a delimiter. The folder_id
      must end with a slash. For example, the folder_id of
      "books/biographies/" would create a new "biographies/" folder under the
      "books/" folder.
    parent: Required. Name of the bucket in which the folder will reside. The
      bucket must be a hierarchical namespace enabled bucket.
    recursive: Optional. If true, parent folder doesn't have to be present and
      all missing ancestor folders will be created atomically.
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted.
  """

  folder = _messages.MessageField('Folder', 1)
  folderId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  recursive = _messages.BooleanField(4)
  requestId = _messages.StringField(5)


class StorageProjectsBucketsFoldersDeleteRecursiveRequest(_messages.Message):
  r"""A StorageProjectsBucketsFoldersDeleteRecursiveRequest object.

  Fields:
    ifMetagenerationMatch: Optional. Makes the operation only succeed
      conditional on whether the root folder's current metageneration matches
      the given value.
    ifMetagenerationNotMatch: Optional. Makes the operation only succeed
      conditional on whether the root folder's current metageneration does not
      match the given value.
    name: Required. Name of the folder being deleted, however all of its
      contents will be deleted too. Format:
      `projects/{project}/buckets/{bucket}/folders/{folder}`
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted.
  """

  ifMetagenerationMatch = _messages.IntegerField(1)
  ifMetagenerationNotMatch = _messages.IntegerField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class StorageProjectsBucketsFoldersDeleteRequest(_messages.Message):
  r"""A StorageProjectsBucketsFoldersDeleteRequest object.

  Fields:
    ifMetagenerationMatch: Makes the operation only succeed conditional on
      whether the root folder's current metageneration matches the given
      value.
    ifMetagenerationNotMatch: Makes the operation only succeed conditional on
      whether the root folder's current metageneration does not match the
      given value.
    name: Required. Name of the root folder being deleted, however all of its
      contents will be deleted too. Format:
      `projects/{project}/buckets/{bucket}/folders/{folder}`
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted.
  """

  ifMetagenerationMatch = _messages.IntegerField(1)
  ifMetagenerationNotMatch = _messages.IntegerField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class StorageProjectsBucketsFoldersGetRequest(_messages.Message):
  r"""A StorageProjectsBucketsFoldersGetRequest object.

  Fields:
    ifMetagenerationMatch: Makes the operation only succeed conditional on
      whether the folder's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation only succeed conditional on
      whether the folder's current metageneration does not match the given
      value.
    name: Required. Name of the folder. Format:
      `projects/{project}/buckets/{bucket}/folders/{folder}`
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted.
  """

  ifMetagenerationMatch = _messages.IntegerField(1)
  ifMetagenerationNotMatch = _messages.IntegerField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class StorageProjectsBucketsFoldersListRequest(_messages.Message):
  r"""A StorageProjectsBucketsFoldersListRequest object.

  Fields:
    delimiter: Optional. If set, returns results in a directory-like mode. The
      results will only include folders that either exactly match the above
      prefix, or are one level below the prefix. The only supported value is
      '/'.
    lexicographicEnd: Optional. Filter results to folders whose names are
      lexicographically before lexicographic_end. If lexicographic_start is
      also set, the folders listed have names between lexicographic_start
      (inclusive) and lexicographic_end (exclusive).
    lexicographicStart: Optional. Filter results to folders whose names are
      lexicographically equal to or after lexicographic_start. If
      lexicographic_end is also set, the folders listed have names between
      lexicographic_start (inclusive) and lexicographic_end (exclusive).
    pageSize: Optional. Maximum number of folders to return in a single
      response. The service will use this parameter or 1,000 items, whichever
      is smaller.
    pageToken: Optional. A previously-returned page token representing part of
      the larger set of results to view.
    parent: Required. Name of the bucket in which to look for folders. The
      bucket must be a hierarchical namespace enabled bucket.
    prefix: Optional. Filter results to folders whose names begin with this
      prefix. If set, the value must either be an empty string or end with a
      '/'.
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted.
  """

  delimiter = _messages.StringField(1)
  lexicographicEnd = _messages.StringField(2)
  lexicographicStart = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)
  prefix = _messages.StringField(7)
  requestId = _messages.StringField(8)


class StorageProjectsBucketsFoldersRenameRequest(_messages.Message):
  r"""A StorageProjectsBucketsFoldersRenameRequest object.

  Fields:
    name: Required. Name of the source folder being renamed. Format:
      `projects/{project}/buckets/{bucket}/folders/{folder}`
    renameFolderRequest: A RenameFolderRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  renameFolderRequest = _messages.MessageField('RenameFolderRequest', 2)


class StorageProjectsBucketsGetStorageLayoutRequest(_messages.Message):
  r"""A StorageProjectsBucketsGetStorageLayoutRequest object.

  Fields:
    name: Required. The name of the StorageLayout resource. Format:
      `projects/{project}/buckets/{bucket}/storageLayout`
    prefix: An optional prefix used for permission check. It is useful when
      the caller only has limited permissions under a specific prefix.
    requestId: Optional. A unique identifier for this request. UUID is the
      recommended format, but other formats are still accepted.
  """

  name = _messages.StringField(1, required=True)
  prefix = _messages.StringField(2)
  requestId = _messages.StringField(3)


class StorageProjectsLocationsGetIntelligenceConfigRequest(_messages.Message):
  r"""A StorageProjectsLocationsGetIntelligenceConfigRequest object.

  Fields:
    name: Required. The name of the `IntelligenceConfig` resource associated
      with your project. Format:
      `projects/{id}/locations/global/intelligenceConfig`
  """

  name = _messages.StringField(1, required=True)


class StorageProjectsLocationsGetManagementHubRequest(_messages.Message):
  r"""A StorageProjectsLocationsGetManagementHubRequest object.

  Fields:
    name: Required. The name of the `ManagementHub` resource associated with
      your project. Format: `projects/{id}/locations/global/managementHub`
  """

  name = _messages.StringField(1, required=True)


class StorageProjectsLocationsIntelligenceFindingsGetRequest(_messages.Message):
  r"""A StorageProjectsLocationsIntelligenceFindingsGetRequest object.

  Fields:
    name: Required. The name of the `IntelligenceFinding` resource. Format: `p
      rojects/{project}/locations/{location}/intelligenceFindings/{intelligenc
      e_finding}`
  """

  name = _messages.StringField(1, required=True)


class StorageProjectsLocationsIntelligenceFindingsListRequest(_messages.Message):
  r"""A StorageProjectsLocationsIntelligenceFindingsListRequest object.

  Fields:
    filter: Optional. The filter expression to be applied. Supports filtering
      by `type` and `associated_resources`.
    pageSize: Optional. The maximum number of `IntelligenceFinding` resources
      to return. The maximum value is `100`; values above `100` will be
      coerced to `100`. The default value is `100`.
    pageToken: Optional. A page token, received from a previous
      `ListIntelligenceFindings` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListIntelligenceFindings` must match the call that provided the page
      token.
    parent: Required. The parent of the `IntelligenceFinding` resource.
      Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class StorageProjectsLocationsIntelligenceFindingsRevisionsGetRequest(_messages.Message):
  r"""A StorageProjectsLocationsIntelligenceFindingsRevisionsGetRequest
  object.

  Fields:
    name: Required. The name of the `IntelligenceFindingRevision` resource. ##
      Format: `projects/{project}/locations/{location}/intelligenceFindings/{i
      ntelligence_finding}/revisions/{revision}`
  """

  name = _messages.StringField(1, required=True)


class StorageProjectsLocationsIntelligenceFindingsRevisionsListRequest(_messages.Message):
  r"""A StorageProjectsLocationsIntelligenceFindingsRevisionsListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of `IntelligenceFindingRevision`
      resources to return. The maximum value is `100`; values above `100` will
      be coerced to `100`. The default value is `100`.
    pageToken: Optional. A page token, received from a previous
      `ListIntelligenceFindingRevisions` call. Provide this to retrieve the
      subsequent page.
    parent: Required. The parent of the `IntelligenceFindingRevision`
      resource. ## Format: `projects/{project}/locations/{location}/intelligen
      ceFindings/{intelligence_finding}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class StorageProjectsLocationsIntelligenceFindingsSummarizeRequest(_messages.Message):
  r"""A StorageProjectsLocationsIntelligenceFindingsSummarizeRequest object.

  Enums:
    ResourceScopeValueValuesEnum: Optional. Determines the granularity of the
      findings when the `parent` is an organization or folder. - `PARENT` (or
      not set): A single summary is returned for each insight type, aggregated
      across the entire `parent` scope. - `PROJECT`: A separate summary is
      returned for each insight type for every project within the `parent`
      scope. The only supported values are `PARENT` and `PROJECT`. If no value
      is specified, the API behaviour defaults to the `PARENT`.

  Fields:
    filter: Optional. The filter expression, following AIP-160. Supports
      filtering by FindingType.
    pageSize: Optional. The maximum number of findings to return. The maximum
      value is `100`; values above `100` will be coerced to `100`. The default
      value is `100`.
    pageToken: Optional. A page token, received from a previous
      `SummarizeIntelligenceFindings` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters provided to
      `SummarizeIntelligenceFindings` must match the call that provided the
      page token.
    parent: Required. The scope to summarize the findings for. Format: -
      `organizations/{organization}/locations/{location}` -
      `folders/{folder}/locations/{location}` -
      `projects/{project}/locations/{location}`
    resourceScope: Optional. Determines the granularity of the findings when
      the `parent` is an organization or folder. - `PARENT` (or not set): A
      single summary is returned for each insight type, aggregated across the
      entire `parent` scope. - `PROJECT`: A separate summary is returned for
      each insight type for every project within the `parent` scope. The only
      supported values are `PARENT` and `PROJECT`. If no value is specified,
      the API behaviour defaults to the `PARENT`.
  """

  class ResourceScopeValueValuesEnum(_messages.Enum):
    r"""Optional. Determines the granularity of the findings when the `parent`
    is an organization or folder. - `PARENT` (or not set): A single summary is
    returned for each insight type, aggregated across the entire `parent`
    scope. - `PROJECT`: A separate summary is returned for each insight type
    for every project within the `parent` scope. The only supported values are
    `PARENT` and `PROJECT`. If no value is specified, the API behaviour
    defaults to the `PARENT`.

    Values:
      RESOURCE_SCOPE_UNSPECIFIED: The default behavior. Falls back to PARENT
        behaviour
      PARENT: Summaries are aggregated at the level of the `parent` resource.
      PROJECT: Summaries are broken down by each project within the `parent`
        scope.
    """
    RESOURCE_SCOPE_UNSPECIFIED = 0
    PARENT = 1
    PROJECT = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  resourceScope = _messages.EnumField('ResourceScopeValueValuesEnum', 5)


class StorageProjectsLocationsUpdateIntelligenceConfigRequest(_messages.Message):
  r"""A StorageProjectsLocationsUpdateIntelligenceConfigRequest object.

  Fields:
    intelligenceConfig: A IntelligenceConfig resource to be passed as the
      request body.
    name: Identifier. The name of the `IntelligenceConfig` resource associated
      with your organization, folder, or project. The name format varies based
      on the GCP resource hierarchy as follows: * For project:
      `projects/{project_number}/locations/global/intelligenceConfig` * For
      organization:
      `organizations/{org_id}/locations/global/intelligenceConfig` * For
      folder: `folders/{folder_id}/locations/global/intelligenceConfig`
    requestId: Optional. The ID that uniquely identifies the request,
      preventing duplicate processing.
    updateMask: Required. The `update_mask` that specifies the fields within
      the `IntelligenceConfig` resource that should be modified by this
      update. Only the listed fields are updated.
  """

  intelligenceConfig = _messages.MessageField('IntelligenceConfig', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageProjectsLocationsUpdateManagementHubRequest(_messages.Message):
  r"""A StorageProjectsLocationsUpdateManagementHubRequest object.

  Fields:
    managementHub: A ManagementHub resource to be passed as the request body.
    name: Identifier. The name of the `ManagementHub` resource associated with
      your organization, folder, or project. The name format varies based on
      the scope as follows: * For project:
      `projects/{project_number}/locations/global/managementHub` * For
      organization: `organizations/{org_id}/locations/global/managementHub` *
      For folder: `folders/{folder_id}/locations/global/managementHub`
    requestId: Optional. The ID that uniquely identifies the request,
      preventing duplicate processing.
    updateMask: Required. The `update_mask` that specifies the fields within
      the `ManagementHub` resource that should be modified by this update.
      Only the listed fields are updated.
  """

  managementHub = _messages.MessageField('ManagementHub', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class SummarizeIntelligenceFindingsResponse(_messages.Message):
  r"""Response message to summarize the intelligence findings for a specified
  scope(org, folder or project).

  Fields:
    findingSummaries: The list of `FindingSummary` summaries.
    nextPageToken: A token to retrieve the next page of results. Pass this
      value in the `page_token` field in the subsequent call to
      `SummarizeIntelligenceFindings` to retrieve the next page of results.
  """

  findingSummaries = _messages.MessageField('FindingSummary', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SummaryDetails(_messages.Message):
  r"""Details about the `FindingSummary` resource.

  Enums:
    ResourceTypeValueValuesEnum: Output only. The type of Cloud resource this
      summary detail applies to.

  Fields:
    count: The count of impacted resources.
    description: Output only. A short description about the FindingSummary
    percentage: The percentage of impacted resources.
    resourceType: Output only. The type of Cloud resource this summary detail
      applies to.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of Cloud resource this summary detail applies
    to.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: Resource type is unspecified.
      PROJECT: Resource type is project.
      BUCKET: Resource type is bucket.
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    PROJECT = 1
    BUCKET = 2

  count = _messages.IntegerField(1)
  description = _messages.StringField(2)
  percentage = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 4)


class ThrottledRequestSpike(_messages.Message):
  r"""Represents a finding about a spike in throttled requests (429 errors)
  within a project. This corresponds to the `THROTTLED_REQUEST_SPIKE` finding
  type.

  Fields:
    percentageIncrease: Output only. The percentage increase in throttled
      requests across the project.
    throttledRequests: Output only. The count of throttled requests across the
      project.
    topBuckets: Output only. A list of top buckets driving the increase in
      throttled requests.
  """

  percentageIncrease = _messages.FloatField(1)
  throttledRequests = _messages.IntegerField(2)
  topBuckets = _messages.MessageField('IntelligenceFindingThrottledRequestSpikeBucketContribution', 3, repeated=True)


class TrialConfig(_messages.Message):
  r"""The trial configuration of the `IntelligenceConfig` resource.

  Fields:
    expireTime: Output only. The time at which the trial expires.
  """

  expireTime = _messages.StringField(1)


class UniformBucketLevelAccess(_messages.Message):
  r"""Settings for Uniform Bucket level access. See
  https://cloud.google.com/storage/docs/uniform-bucket-level-access.

  Fields:
    enabled: Optional. If set, access checks only use bucket-level IAM
      policies or above.
    lockTime: Optional. The deadline time for changing
      `iam_config.uniform_bucket_level_access.enabled` from `true` to `false`.
      Mutable until the specified deadline is reached, but not afterward.
  """

  enabled = _messages.BooleanField(1)
  lockTime = _messages.StringField(2)


class Versioning(_messages.Message):
  r"""Properties of a bucket related to versioning. For more information about
  Cloud Storage versioning, see [Object
  versioning](https://cloud.google.com/storage/docs/object-versioning).

  Fields:
    enabled: Optional. While set to true, versioning is fully enabled for this
      bucket.
  """

  enabled = _messages.BooleanField(1)


class VpcNetworkSource(_messages.Message):
  r"""The list of VPC networks that can access the bucket.

  Fields:
    allowedIpCidrRanges: Optional. The list of public or private IPv4 and IPv6
      CIDR ranges that can access the bucket. In the CIDR IP address block,
      the specified IP address must be properly truncated, meaning all the
      host bits must be zero or else the input is considered malformed. For
      example, `192.0.2.0/24` is accepted but `192.0.2.1/24` is not.
      Similarly, for IPv6, `2001:db8::/32` is accepted whereas
      `2001:db8::1/32` is not.
    network: Name of the network. Format:
      `projects/PROJECT_ID/global/networks/NETWORK_NAME`
  """

  allowedIpCidrRanges = _messages.StringField(1, repeated=True)
  network = _messages.StringField(2)


class Website(_messages.Message):
  r"""Properties of a bucket related to accessing the contents as a static
  website. For details, see [hosting a static website using Cloud
  Storage](https://cloud.google.com/storage/docs/hosting-static-website).

  Fields:
    mainPageSuffix: Optional. If the requested object path is missing, the
      service ensures the path has a trailing '/', append this suffix, and
      attempt to retrieve the resulting object. This allows the creation of
      `index.html` objects to represent directory pages.
    notFoundPage: Optional. If the requested object path is missing, and any
      `mainPageSuffix` object is missing, if applicable, the service returns
      the named object from this bucket as the content for a [404 Not
      Found](https://tools.ietf.org/html/rfc7231#section-6.5.4) result.
  """

  mainPageSuffix = _messages.StringField(1)
  notFoundPage = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
