/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.NodeAtState;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.type.ModelType;

class RuleBindings {
    private final NodeAtStateIndex rulesBySubject;
    private final NodeAtStateIndex rulesByInput;
    private final PathPredicateIndex untypedPathReferences = new PathPredicateIndex();
    private final PathPredicateIndex typedPathReferences = new PathPredicateIndex();
    private final TypePredicateIndex scopeReferences = new TypePredicateIndex();

    public RuleBindings() {
        this.rulesBySubject = new NodeAtStateIndex("rulesBySubject");
        this.rulesByInput = new NodeAtStateIndex("rulesByInput");
    }

    public void nodeCreated(ModelNodeInternal node) {
        this.untypedPathReferences.addNode(node);
    }

    public void nodeDiscovered(ModelNodeInternal node) {
        this.typedPathReferences.addNode(node);
        this.scopeReferences.addNodeToScope(node.getPath(), node);
        this.scopeReferences.addNodeToScope(node.getPath().getParent(), node);
    }

    private void bound(Reference reference, ModelNodeInternal node) {
        ModelBinding binding = reference.binding;
        binding.onBind(node);
        reference.index.put(new NodeAtState(node.getPath(), binding.predicate.getState()), reference.owner);
    }

    public void remove(ModelNodeInternal node) {
        this.untypedPathReferences.removeNode(node);
        this.typedPathReferences.removeNode(node);
        this.scopeReferences.removeNodeFromScope(node.getPath(), node);
        this.scopeReferences.removeNodeFromScope(node.getPath().getParent(), node);
        this.rulesBySubject.nodeRemoved(node);
        this.rulesByInput.nodeRemoved(node);
    }

    public void add(RuleBinder ruleBinder) {
        this.addRule(ruleBinder, this.rulesBySubject, ruleBinder.getSubjectBinding());
        for (ModelBinding binding : ruleBinder.getInputBindings()) {
            this.addRule(ruleBinder, this.rulesByInput, binding);
        }
    }

    private void addRule(RuleBinder rule, NodeAtStateIndex index, ModelBinding binding) {
        Reference reference = new Reference(rule, index, binding);
        BindingPredicate predicate = binding.getPredicate();
        if (predicate.getPath() != null) {
            if (predicate.getScope() != null) {
                throw new UnsupportedOperationException("Currently not implemented");
            }
            if (reference.binding.canBindInState(ModelNode.State.Registered)) {
                this.untypedPathReferences.addReference(reference);
            } else {
                this.typedPathReferences.addReference(reference);
            }
        } else if (predicate.getScope() != null) {
            this.scopeReferences.addReference(reference);
        } else {
            throw new UnsupportedOperationException("Currently not implemented");
        }
    }

    private static void unbind(RuleBinder rule, ModelNodeInternal node) {
        rule.getSubjectBinding().onUnbind(node);
        for (ModelBinding binding : rule.getInputBindings()) {
            binding.onUnbind(node);
        }
    }

    public Collection<RuleBinder> getRulesWithSubject(NodeAtState target) {
        return this.rulesBySubject.get(target);
    }

    public Collection<RuleBinder> getRulesWithInput(NodeAtState input) {
        return this.rulesByInput.get(input);
    }

    private static class Reference {
        final ModelBinding binding;
        final NodeAtStateIndex index;
        final RuleBinder owner;

        public Reference(RuleBinder owner, NodeAtStateIndex index, ModelBinding binding) {
            this.owner = owner;
            this.index = index;
            this.binding = binding;
        }

        public String toString() {
            return this.binding + " in " + this.index.name;
        }
    }

    private class PathPredicateIndex {
        final Map<ModelPath, PredicateMatches> predicates = new LinkedHashMap<ModelPath, PredicateMatches>();

        private PathPredicateIndex() {
        }

        public void addNode(ModelNodeInternal node) {
            this.predicatesForPath(node.getPath()).match(node);
        }

        public void addReference(Reference reference) {
            ModelPath path = reference.binding.getPredicate().getPath();
            this.predicatesForPath(path).add(reference);
        }

        private PredicateMatches predicatesForPath(ModelPath path) {
            PredicateMatches predicatesForReference = this.predicates.get(path);
            if (predicatesForReference == null) {
                predicatesForReference = new PredicateMatches();
                this.predicates.put(path, predicatesForReference);
            }
            return predicatesForReference;
        }

        public void removeNode(ModelNodeInternal node) {
            this.predicatesForPath(node.getPath()).remove();
        }
    }

    private class TypePredicateIndex {
        final Map<ModelPath, ScopeIndex> scopes = new LinkedHashMap<ModelPath, ScopeIndex>();

        private TypePredicateIndex() {
        }

        public void addNodeToScope(ModelPath path, ModelNodeInternal node) {
            this.scopeForPath(path).addNode(node);
        }

        public void removeNodeFromScope(ModelPath path, ModelNodeInternal node) {
            this.scopeForPath(path).removeNode(node);
        }

        public void addReference(Reference reference) {
            ModelPath path = reference.binding.getPredicate().getScope();
            this.scopeForPath(path).addReference(reference);
        }

        private ScopeIndex scopeForPath(ModelPath path) {
            ScopeIndex scope = this.scopes.get(path);
            if (scope == null) {
                scope = new ScopeIndex();
                this.scopes.put(path, scope);
            }
            return scope;
        }
    }

    private static class NodeAtStateIndex {
        private final EnumMap<ModelNode.State, Map<String, List<RuleBinder>>> boundAtState = Maps.newEnumMap(ModelNode.State.class);
        private final String name;

        private NodeAtStateIndex(String name) {
            this.name = name;
        }

        private Map<String, List<RuleBinder>> getByState(ModelNode.State state) {
            Map<String, List<RuleBinder>> map = this.boundAtState.get((Object)state);
            if (map == null) {
                map = new HashMap<String, List<RuleBinder>>(64);
                this.boundAtState.put(state, map);
            }
            return map;
        }

        public void nodeRemoved(ModelNodeInternal node) {
            for (ModelNode.State state : ModelNode.State.values()) {
                Map<String, List<RuleBinder>> byState = this.getByState(state);
                List<RuleBinder> remove = byState.remove(node.getPath().toString());
                if (remove == null) continue;
                for (RuleBinder rule : remove) {
                    RuleBindings.unbind(rule, node);
                }
            }
        }

        public void put(NodeAtState nodeAtState, RuleBinder binder) {
            String path;
            Map<String, List<RuleBinder>> byState = this.getByState(nodeAtState.state);
            List<RuleBinder> byPath = this.getByPath(byState, path = nodeAtState.path.toString());
            if (!byPath.contains(binder)) {
                byPath.add(binder);
            }
        }

        private List<RuleBinder> getByPath(Map<String, List<RuleBinder>> byState, String path) {
            List<RuleBinder> ruleBinders = byState.get(path);
            if (ruleBinders == null) {
                ruleBinders = new ArrayList<RuleBinder>();
                byState.put(path, ruleBinders);
            }
            return ruleBinders;
        }

        public Collection<RuleBinder> get(NodeAtState nodeAtState) {
            return this.getByPath(this.getByState(nodeAtState.state), nodeAtState.path.toString());
        }

        public String toString() {
            return this.name;
        }
    }

    private class ScopeIndex {
        final Map<ModelType<?>, PredicateMatches> types = new LinkedHashMap();
        final List<ModelNodeInternal> nodes = new ArrayList<ModelNodeInternal>();

        private ScopeIndex() {
        }

        public void addNode(ModelNodeInternal node) {
            this.nodes.add(node);
            for (Map.Entry<ModelType<?>, PredicateMatches> entry : this.types.entrySet()) {
                if (!node.canBeViewedAs(entry.getKey())) continue;
                entry.getValue().match(node);
            }
        }

        public void removeNode(ModelNodeInternal node) {
            this.nodes.remove(node);
            for (PredicateMatches matches : this.types.values()) {
                if (matches.match != node) continue;
                matches.remove();
            }
        }

        public void addReference(Reference reference) {
            boolean newType;
            ModelType<?> type = reference.binding.getPredicate().getType();
            PredicateMatches predicateMatches = this.types.get(type);
            boolean bl = newType = predicateMatches == null;
            if (predicateMatches == null) {
                predicateMatches = new PredicateMatches();
                this.types.put(type, predicateMatches);
            }
            predicateMatches.add(reference);
            if (newType) {
                for (ModelNodeInternal node : this.nodes) {
                    if (!node.canBeViewedAs(type)) continue;
                    predicateMatches.match(node);
                }
            }
        }
    }

    private class PredicateMatches {
        final List<Reference> references = new ArrayList<Reference>();
        ModelNodeInternal match;

        private PredicateMatches() {
        }

        void match(ModelNodeInternal node) {
            for (Reference reference : this.references) {
                RuleBindings.this.bound(reference, node);
            }
            this.match = node;
        }

        void add(Reference reference) {
            this.references.add(reference);
            if (this.match != null) {
                RuleBindings.this.bound(reference, this.match);
            }
        }

        public void remove() {
            this.match = null;
        }
    }
}

