/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsyncClient;
import feign.Client;
import feign.Experimental;
import feign.Request;
import feign.Response;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@Experimental
public class DefaultAsyncClient<C>
implements AsyncClient<C> {
    private final Client client;
    private final ExecutorService executorService;

    public DefaultAsyncClient(Client client, ExecutorService executorService) {
        this.client = client;
        this.executorService = executorService;
    }

    @Override
    public CompletableFuture<Response> execute(Request request, Request.Options options, Optional<C> requestContext) {
        CompletableFuture<Response> result = new CompletableFuture<Response>();
        Future<?> future = this.executorService.submit(() -> {
            try {
                result.complete(this.client.execute(request, options));
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        result.whenComplete((response, throwable) -> {
            if (result.isCancelled()) {
                future.cancel(true);
            }
        });
        return result;
    }
}

