/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Body;
import feign.DeclarativeContract;
import feign.HeaderMap;
import feign.Headers;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMap;
import feign.Request;
import feign.RequestLine;
import feign.Util;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultContract
extends DeclarativeContract {
    static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("^([A-Z]+)[ ]*(.*)$");

    public DefaultContract() {
        super.registerClassAnnotation(Headers.class, (E header, MethodMetadata data) -> {
            String[] headersOnType = header.value();
            Util.checkState(headersOnType.length > 0, "Headers annotation was empty on type %s.", data.configKey());
            Map<String, Collection<String>> headers = DefaultContract.toMap(headersOnType);
            headers.putAll(data.template().headers());
            data.template().headers(null);
            data.template().headers(headers);
        });
        super.registerMethodAnnotation(RequestLine.class, (E ann, MethodMetadata data) -> {
            String requestLine = ann.value();
            Util.checkState(Util.emptyToNull(requestLine) != null, "RequestLine annotation was empty on method %s.", data.configKey());
            Matcher requestLineMatcher = REQUEST_LINE_PATTERN.matcher(requestLine);
            if (!requestLineMatcher.find()) {
                throw new IllegalStateException(String.format("RequestLine annotation didn't start with an HTTP verb on method %s", data.configKey()));
            }
            data.template().method(Request.HttpMethod.valueOf(requestLineMatcher.group(1)));
            data.template().uri(requestLineMatcher.group(2));
            data.template().decodeSlash(ann.decodeSlash());
            data.template().collectionFormat(ann.collectionFormat());
        });
        super.registerMethodAnnotation(Body.class, (E ann, MethodMetadata data) -> {
            String body = ann.value();
            Util.checkState(Util.emptyToNull(body) != null, "Body annotation was empty on method %s.", data.configKey());
            if (body.indexOf(123) == -1) {
                data.template().body(body);
            } else {
                data.template().bodyTemplate(body);
            }
        });
        super.registerMethodAnnotation(Headers.class, (E header, MethodMetadata data) -> {
            String[] headersOnMethod = header.value();
            Util.checkState(headersOnMethod.length > 0, "Headers annotation was empty on method %s.", data.configKey());
            data.template().headers(DefaultContract.toMap(headersOnMethod));
        });
        super.registerParameterAnnotation(Param.class, (paramAnnotation, data, paramIndex) -> {
            String annotationName = paramAnnotation.value();
            Parameter parameter = data.method().getParameters()[paramIndex];
            String name = Util.emptyToNull(annotationName) == null && parameter.isNamePresent() ? parameter.getName() : annotationName;
            Util.checkState(Util.emptyToNull(name) != null, "Param annotation was empty on param %s.\nHint: %s", paramIndex, "Prefer using @Param(value=\"name\"), or compile your code with the -parameters flag.\nIf the value is missing, Feign attempts to retrieve the parameter name from bytecode, which only works if the class was compiled with the -parameters flag.");
            this.nameParam(data, name, paramIndex);
            Class<? extends Param.Expander> expander = paramAnnotation.expander();
            if (expander != Param.ToStringExpander.class) {
                data.indexToExpanderClass().put(paramIndex, expander);
            }
            if (!data.template().hasRequestVariable(name)) {
                data.formParams().add(name);
            }
        });
        super.registerParameterAnnotation(QueryMap.class, (queryMap, data, paramIndex) -> {
            Util.checkState(data.queryMapIndex() == null, "QueryMap annotation was present on multiple parameters.", new Object[0]);
            data.queryMapIndex(paramIndex);
            data.queryMapEncoder(queryMap.mapEncoder().instance());
        });
        super.registerParameterAnnotation(HeaderMap.class, (queryMap, data, paramIndex) -> {
            Util.checkState(data.headerMapIndex() == null, "HeaderMap annotation was present on multiple parameters.", new Object[0]);
            data.headerMapIndex(paramIndex);
        });
    }

    private static Map<String, Collection<String>> toMap(String[] input) {
        LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>(input.length);
        for (String header : input) {
            int colon = header.indexOf(58);
            String name = header.substring(0, colon);
            if (!result.containsKey(name)) {
                result.put(name, new ArrayList(1));
            }
            ((Collection)result.get(name)).add(header.substring(colon + 1).trim());
        }
        return result;
    }
}

