/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.bluesky;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.bluesky.BlueskyException;
import org.jreleaser.sdk.bluesky.BlueskySdk;
import org.jreleaser.util.StringUtils;

public class BlueskyAnnouncer
implements Announcer<org.jreleaser.model.api.announce.BlueskyAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.BlueskyAnnouncer bluesky;

    public BlueskyAnnouncer(JReleaserContext context) {
        this.context = context;
        this.bluesky = context.getModel().getAnnounce().getBluesky();
    }

    public org.jreleaser.model.api.announce.BlueskyAnnouncer getAnnouncer() {
        return this.bluesky.asImmutable();
    }

    public String getName() {
        return "bluesky";
    }

    public boolean isEnabled() {
        return this.bluesky.isEnabled();
    }

    public void announce() throws AnnounceException {
        ArrayList<String> statuses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.bluesky.getStatusTemplate())) {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context);
            Arrays.stream(this.bluesky.getResolvedStatusTemplate(this.context, props).split(System.lineSeparator())).filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty() && !this.bluesky.getStatuses().isEmpty()) {
            this.bluesky.getStatuses().stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(statuses::add);
        }
        if (statuses.isEmpty()) {
            statuses.add(this.bluesky.getStatus());
        }
        for (int i = 0; i < statuses.size(); ++i) {
            String status = this.getResolvedMessage(this.context, (String)statuses.get(i));
            this.context.getLogger().info(RB.$((String)"bluesky.skeet", (Object[])new Object[0]), new Object[]{status});
            this.context.getLogger().debug(RB.$((String)"bluesky.skeet.size", (Object[])new Object[0]), new Object[]{status.length()});
            statuses.set(i, status);
        }
        try {
            BlueskySdk sdk = BlueskySdk.builder(this.context.asImmutable()).host(this.bluesky.getHost()).handle(this.bluesky.getHandle()).password(this.bluesky.getPassword()).connectTimeout(this.bluesky.getConnectTimeout()).readTimeout(this.bluesky.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.skeet(statuses);
        }
        catch (BlueskyException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private String getResolvedMessage(JReleaserContext context, String message) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, (Map)context.getModel().getAnnounce().getBluesky().resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context));
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)message, (TemplateContext)props);
    }
}

