/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;

@SdkProtectedApi
public final class DefaultChecksumAlgorithm {
    public static final ChecksumAlgorithm CRC32C = DefaultChecksumAlgorithm.of("CRC32C");
    public static final ChecksumAlgorithm CRC32 = DefaultChecksumAlgorithm.of("CRC32");
    public static final ChecksumAlgorithm MD5 = DefaultChecksumAlgorithm.of("MD5");
    public static final ChecksumAlgorithm SHA256 = DefaultChecksumAlgorithm.of("SHA256");
    public static final ChecksumAlgorithm SHA1 = DefaultChecksumAlgorithm.of("SHA1");
    public static final ChecksumAlgorithm SHA512 = DefaultChecksumAlgorithm.of("SHA512");
    public static final ChecksumAlgorithm CRC64NVME = DefaultChecksumAlgorithm.of("CRC64NVME");
    public static final ChecksumAlgorithm XXHASH64 = DefaultChecksumAlgorithm.of("XXHASH64");
    public static final ChecksumAlgorithm XXHASH3 = DefaultChecksumAlgorithm.of("XXHASH3");
    public static final ChecksumAlgorithm XXHASH128 = DefaultChecksumAlgorithm.of("XXHASH128");

    private DefaultChecksumAlgorithm() {
    }

    private static ChecksumAlgorithm of(String name) {
        return ChecksumAlgorithmsCache.put(name);
    }

    public static ChecksumAlgorithm fromValue(String algorithm) {
        if (algorithm == null) {
            return null;
        }
        return (ChecksumAlgorithm)ChecksumAlgorithmsCache.VALUES.get(algorithm.toUpperCase(Locale.US));
    }

    private static final class ChecksumAlgorithmsCache {
        private static final ConcurrentHashMap<String, ChecksumAlgorithm> VALUES = new ConcurrentHashMap();

        private ChecksumAlgorithmsCache() {
        }

        private static ChecksumAlgorithm put(String value) {
            return VALUES.computeIfAbsent(value, v -> new ChecksumAlgorithm((String)v){
                final /* synthetic */ String val$v;
                {
                    this.val$v = string;
                }

                public String algorithmId() {
                    return this.val$v;
                }

                public String toString() {
                    return this.algorithmId();
                }
            });
        }
    }
}

