/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AppImagePackager;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.packagers.AppdataUtils;
import org.jreleaser.templates.TemplateUtils;

public class AppImagePackagerProcessor
extends AbstractRepositoryPackagerProcessor<AppImagePackager> {
    public AppImagePackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        this.setupPrepare(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    private void setupPrepare(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        try {
            props.set("appImageReleases", Releasers.releaserFor(this.context).listReleases(releaser.getOwner(), releaser.getName()).stream().filter(r -> AppdataUtils.isReleaseIncluded(((AppImagePackager)this.packager).getSkipReleases(), r.getVersion().toString())).map(r -> AppdataUtils.Release.of(r.getUrl(), r.getVersion().toString(), r.getPublishedAt())).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        props.set("appImageScreenshots", ((AppImagePackager)this.packager).getScreenshots().stream().map(Screenshot::asScreenshotTemplate).collect(Collectors.toList()));
        this.context.getLogger().debug(RB.$((String)"packager.fetch.icons", (Object[])new Object[0]));
        props.set("appImageIcons", (Object)((AppImagePackager)this.packager).getIcons());
        AppdataUtils.resolveIcons(this.context, (TemplatePackager)this.packager, distribution, props, ((AppImagePackager)this.packager).getIcons());
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.setOrEmpty("distributionJavaMainClass", distribution.getJava().getMainClass());
        props.setOrEmpty("distributionJavaMainModule", distribution.getJava().getMainModule());
        props.set("projectAuthors", (Object)this.context.getModel().getProject().getAuthors());
        props.set("appImageUrls", (Object)this.context.getModel().getProject().getLinks().asLinkTemplates(false));
        props.set("appImageComponentId", (Object)((AppImagePackager)this.getPackager()).getComponentId());
        props.set("appImageCategories", (Object)((AppImagePackager)this.getPackager()).getCategories());
        props.set("appImageCategoriesByComma", (Object)String.join((CharSequence)",", ((AppImagePackager)this.getPackager()).getCategories()));
        props.setOrEmpty("appImageDeveloperId", ((AppImagePackager)this.getPackager()).getDeveloperId());
        props.set("appImageDeveloperName", (Object)((AppImagePackager)this.getPackager()).getDeveloperName());
        props.set("appImageRequiresTerminal", (Object)((AppImagePackager)this.getPackager()).isRequiresTerminal());
        props.set("appImageRepoOwner", (Object)((AppImagePackager)this.packager).getRepository().getOwner());
        props.set("appImageRepoName", (Object)((AppImagePackager)this.packager).getRepository().getName());
        props.set("appImageRepositoryOwner", (Object)((AppImagePackager)this.packager).getRepository().getOwner());
        props.set("appImageRepositoryName", (Object)((AppImagePackager)this.packager).getRepository().getName());
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        String str = (String)props.get("distributionArtifactFile");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "${DISTRIBUTION_VERSION}");
        props.set("appImageDistributionArtifactFile", (Object)str);
        str = (String)props.get("distributionArtifactFileName");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "${DISTRIBUTION_VERSION}");
        props.set("appImageDistributionArtifactFileName", (Object)str);
        str = (String)props.get("distributionUrl");
        str = str.replace(releaser.getEffectiveTagName(this.context), "${DISTRIBUTION_TAG}").replace((CharSequence)props.get("distributionArtifactFile"), "${DISTRIBUTION_FILE}");
        props.set("appImageDistributionUrl", (Object)str);
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Optional<Stereotype> stereotype;
        BaseReleaser gitService = this.context.getModel().getRelease().getReleaser();
        if (fileName.contains("github") && !(gitService instanceof GithubReleaser)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = StringUtils.remove((String)fileName, (String)"-github");
        }
        if ((stereotype = this.resolveStereotype(fileName = TemplateUtils.trimTplExtension((String)fileName))).isPresent()) {
            if (distribution.getStereotype() == stereotype.get()) {
                fileName = fileName.substring(distribution.getStereotype().formatted().length() + 1);
            } else {
                return;
            }
        }
        Path outputFile = outputDirectory.resolve(fileName);
        if ("app.desktop".equals(fileName)) {
            outputFile = outputDirectory.resolve(distribution.getExecutable().getName() + ".desktop");
        } else if ("appdata.xml".equals(fileName)) {
            outputFile = outputDirectory.resolve(((AppImagePackager)this.getPackager()).getComponentId() + ".appdata.xml");
        }
        this.writeFile(content, outputFile);
    }

    @Override
    protected void writeFile(Distribution distribution, InputStream inputStream, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = outputDirectory.resolve(fileName);
        if (fileName.endsWith("app.png")) {
            outputFile = outputDirectory.resolve(fileName.replace("app", distribution.getExecutable().getName()));
        }
        this.writeFile(inputStream, outputFile);
    }
}

