/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.mustache;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.GuardedBinding;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.Wrapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.ExtensionManagerHolder;
import org.jreleaser.extensions.api.mustache.MustacheExtensionPoint;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;

public final class MustacheUtils {
    private MustacheUtils() {
    }

    private static Map<String, String> envVars() {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        System.getenv().forEach((k, v) -> {
            if (!k.startsWith("JRELEASER_")) {
                vars.put("Env." + k, (String)v);
            }
        });
        return vars;
    }

    public static String applyTemplate(JReleaserLogger logger, Reader reader, TemplateContext context, String templateName) {
        StringWriter input = new StringWriter();
        MyMustacheFactory mf = new MyMustacheFactory(logger);
        Mustache mustache = mf.compile(reader, templateName);
        context.setAll(MustacheUtils.envVars());
        MustacheUtils.applyFunctions(context);
        mustache.execute((Writer)input, MustacheUtils.decorate(context.asMap()));
        input.flush();
        return input.toString();
    }

    private static Map<String, Object> decorate(Map<String, Object> context) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(context.entrySet())) {
            String val;
            Object value = entry.getValue();
            if (!(value instanceof CharSequence) || !(val = String.valueOf(value)).contains("{{")) continue;
            context.put((String)entry.getKey(), s -> val);
        }
        return context;
    }

    public static String applyTemplate(JReleaserLogger logger, Reader reader, TemplateContext context) {
        return MustacheUtils.applyTemplate(logger, reader, context, UUID.randomUUID().toString()).trim();
    }

    public static String applyTemplate(JReleaserLogger logger, String template, TemplateContext context, String templateName) {
        return MustacheUtils.applyTemplate(logger, new StringReader(template), context, templateName);
    }

    public static String applyTemplate(JReleaserLogger logger, String template, TemplateContext context) {
        return MustacheUtils.applyTemplate(logger, new StringReader(template), context, UUID.randomUUID().toString()).trim();
    }

    public static void applyTemplates(JReleaserLogger logger, Map<String, Object> props, TemplateContext templates) {
        MustacheUtils.applyTemplates(logger, new TemplateContext(props), templates);
    }

    public static void applyTemplates(JReleaserLogger logger, TemplateContext props, Map<String, Object> templates) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(templates.entrySet())) {
            String val;
            Object value = entry.getValue();
            if (value instanceof CharSequence && (val = String.valueOf(value)).contains("{{") && val.contains("}}")) {
                value = MustacheUtils.applyTemplate(logger, val, props);
            }
            props.set((String)entry.getKey(), value);
        }
    }

    public static void applyTemplates(JReleaserLogger logger, TemplateContext props, TemplateContext templates) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(templates.entries())) {
            String val;
            Object value = entry.getValue();
            if (value instanceof CharSequence && (val = String.valueOf(value)).contains("{{") && val.contains("}}")) {
                value = MustacheUtils.applyTemplate(logger, val, props);
            }
            props.set((String)entry.getKey(), value);
        }
    }

    public static String passThrough(String str) {
        return StringUtils.isNotBlank((String)str) ? "!!" + str + "!!" : str;
    }

    private static void applyFunctions(TemplateContext props) {
        ExtensionManagerHolder.get().findExtensionPoints(MustacheExtensionPoint.class).forEach(ep -> ep.apply(props));
    }

    private static class MyMustacheFactory
    extends DefaultMustacheFactory {
        public MyMustacheFactory(JReleaserLogger logger) {
            this.setObjectHandler((ObjectHandler)new MyReflectionObjectHandler(logger));
        }

        public void encode(String value, Writer writer) {
            if (value.startsWith("!!") && value.endsWith("!!")) {
                try {
                    writer.write(value.substring(2, value.length() - 2));
                }
                catch (IOException e) {
                    throw new MustacheException(RB.$((String)"ERROR_mustache_write_value", (Object[])new Object[]{value}), (Throwable)e);
                }
            } else {
                super.encode(value, writer);
            }
        }
    }

    private static class MyReflectionObjectHandler
    extends ReflectionObjectHandler {
        private final JReleaserLogger logger;

        public MyReflectionObjectHandler(JReleaserLogger logger) {
            this.logger = logger;
        }

        public Binding createBinding(String name, com.github.mustachejava.TemplateContext tc, Code code) {
            return new GuardedBinding((ObjectHandler)this, name, tc, code){

                protected synchronized Wrapper getWrapper(String name, List<Object> scopes) {
                    Wrapper wrapper = super.getWrapper(name, scopes);
                    if (wrapper instanceof MissingWrapper) {
                        logger.debug(RB.$((String)"ERROR_mustache_missing_variable", (Object[])new Object[]{name}));
                    }
                    return wrapper;
                }
            };
        }
    }
}

