/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pyAGChannel.h"

#include <PRP/Avatar/plScalarChannel.h>
#include "PRP/pyCreatable.h"

PY_PLASMA_NEW(ScalarChannel, plScalarChannel)

PY_PROPERTY(float, ScalarChannel, result, getResult, setResult)

static PyGetSetDef pyScalarChannel_GetSet[] = {
    pyScalarChannel_result_getset,
    PY_GETSET_TERMINATOR
};

PY_PLASMA_TYPE(ScalarChannel, plScalarChannel, "plScalarChannel wrapper")

PY_PLASMA_TYPE_INIT(ScalarChannel)
{
    pyScalarChannel_Type.tp_new = pyScalarChannel_new;
    pyScalarChannel_Type.tp_getset = pyScalarChannel_GetSet;
    pyScalarChannel_Type.tp_base = &pyAGChannel_Type;
    if (PyType_CheckAndReady(&pyScalarChannel_Type) < 0)
        return nullptr;

    Py_INCREF(&pyScalarChannel_Type);
    return (PyObject*)&pyScalarChannel_Type;
}

PY_PLASMA_IFC_METHODS(ScalarChannel, plScalarChannel)
