/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PYCAMERAMSG_H
#define _PYCAMERAMSG_H

#include "PyPlasma.h"
#include <PRP/Message/plCameraMsg.h>

PY_WRAP_PLASMA(CameraConfig, plCameraConfig)
PY_WRAP_PLASMA(CameraMsg, plCameraMsg)

/* Helpers for Python properties */
inline PyObject* pyPlasma_convert(plCameraConfig* value) { return pyCameraConfig_FromCameraConfig(value); }
template <> inline int pyPlasma_check<plCameraConfig>(PyObject* value) { return pyCameraConfig_Check(value); }
template <> inline plCameraConfig* pyPlasma_get(PyObject* value) { return ((pyCameraConfig*)value)->fThis; }

#endif
