function( echo )
  execute_process( COMMAND ${CMAKE_COMMAND} -E echo ${ARGN})
endfunction( )

function( DebBuildDependencies VAR )
  file( GLOB_RECURSE files "${TOP_DIR}/control" "${TOP_DIR}/control.in" )
  set( keepers )
  foreach( file ${files})
    if ( NOT file MATCHES /legacy/ )
      list( APPEND keepers ${file} )
    endif( )
  endforeach( )
  set( files ${keepers} )
  # message( STATUS "files: ${files}" )
  unset(deps)
  foreach( SPEC_FILE ${files} )
    file( READ ${SPEC_FILE} dependencies )
    string( CONFIGURE "${dependencies}" dependencies @ONLY )
    # Remove any undefined substitution variables
    string( REGEX REPLACE '@[A-Za-z0-9_]*@' "" dependencies "${dependencies}" )
    string( REGEX REPLACE "\n" ";" dependencies "${dependencies}" )
    set( stage 1 )
    foreach(line ${dependencies})
      string(REGEX REPLACE "[ \t\n]+$" "" line "${line}" )
      string(REGEX REPLACE "^[ \t\n]+" "" line "${line}" )
      if ( stage EQUAL 1 )
        if( "${line}" MATCHES "^[Bb]uild-[Dd]epends:" )
          string( REGEX REPLACE "^[Bb]uild-[Dd]epends:" "" line "${line}" )
          string( REGEX REPLACE "," ";" line "${line}" )
          string( REGEX REPLACE "[ \t]+" "" line "${line}" )
          list( APPEND deps ${line} )
          set( stage 2 )
        endif ( )
      elseif( stage EQUAL 2 )
        if ( NOT "${line}" MATCHES ",[ \t]*$" )
          set( stage 1 )
        endif( )
        string( REGEX REPLACE "," ";" line "${line}" )
        string( REGEX REPLACE "[ \t]+" "" line "${line}" )
        list( APPEND deps ${line} )
      endif( )
    endforeach( )
    string( REGEX REPLACE "[(][^)]*[)]" "" deps "${deps}")
    #list( REMOVE_ITEM deps debhelper )
    # message( STATUS "DEB dependencies: ${deps}")
  endforeach( )
  list( SORT deps )
  list( REMOVE_DUPLICATES deps )
  foreach( dep ${deps} )
    string(REPLACE "|" "$|^" dep "${dep}")
    list( APPEND dep_patterns "^${dep}$")
  endforeach( )
  set( ${VAR} ${dep_patterns} PARENT_SCOPE )
endfunction( )

function( RPMBuildDependencies VAR )
  find_program( PROG_RPM rpm )
  find_program( PROG_RPMSPEC rpmspec )
  file( GLOB_RECURSE files "${TOP_DIR}/*.spec" "${TOP_DIR}/*.spec.in" )
  set( keepers )
  foreach( file ${files})
    if ( NOT file MATCHES /legacy/
        AND NOT file MATCHES "[/][.][^/]*$" )
      list( APPEND keepers ${file} )
    endif( )
  endforeach( )
  set( files ${keepers} )
  message( WARNING "files: ${files}" )
  unset(deps)
  foreach( SPEC_FILE ${files} )
    file( READ ${SPEC_FILE} dependencies )
    string( CONFIGURE "${dependencies}" dependencies @ONLY )
    # Remove any undefined substitution variables
    string( REGEX REPLACE '@[A-Za-z0-9_]*@' "" dependencies "${dependencies}" )
    message(WARNING "configured dependencies ${dependencies}")
    if ( PROG_RPMSPEC )
      get_filename_component(SPEC_FILE_EXPANDED "${SPEC_FILE}" NAME)
      set( SPEC_FILE_EXPANDED "/tmp/${SPEC_FILE_EXPANDED}" )
      file( WRITE ${SPEC_FILE_EXPANDED} "${dependencies}" )
      execute_process(
        COMMAND ${PROG_RPMSPEC}  -P "${SPEC_FILE_EXPANDED}"
        OUTPUT_VARIABLE dependencies
        ERROR_VARIABLE dependencies_error
        )
    elseif ( PROG_RPM )
      execute_process(
        COMMAND ${PROG_RPM}  --eval "${dependencies}"
        OUTPUT_VARIABLE dependencies
        ERROR_VARIABLE dependencies_error
        )
    endif( )
    message(WARNING "dependencies ${dependencies}")
    message(WARNING "dependencies_error ${dependencies_error}")
    string( REGEX REPLACE "\n" ";" dependencies "${dependencies}")
    foreach(line ${dependencies})
      if( "${line}" MATCHES "^[Bb]uild[Rr]equires:" )
        string(REGEX REPLACE "^[Bb]uild[Rr]equires:[ \t]*" "" line ${line})
        string(REGEX REPLACE ">=[ \t]*(([0-9]+)[.])*[0-9]+" "" line ${line})
        string(REGEX REPLACE "," ";" line ${line})
        foreach(pkg_ ${line})
          string(STRIP "${pkg_}" pkg_)
          list(APPEND deps ${pkg_})
        endforeach()
      endif( )
    endforeach( )
  endforeach( )
  list( SORT deps )
  list( REMOVE_DUPLICATES deps )
  set( new_deps )
  foreach( dep ${deps} )
    if ( NOT dep MATCHES "^.*{basename_}.*$" )
      list( APPEND new_deps ${dep} )
    endif( )
  endforeach( )
  message( WARNING "new_deps ${new_deps}" )
  set( ${VAR} ${new_deps} PARENT_SCOPE )
endfunction( )

set( VERBOSE True )
if( NOT PYTHON3_VERSION_NODOTS )
  if ( PYTHON3_VERSION )
    set( PYTHON3_VERSION_NODOTS ${PYTHON3_VERSION} )
    string( REPLACE "." "" PYTHON3_VERSION_NODOTS "${PYTHON3_VERSION_NODOTS}" )
    set( PYTHON3_VERSION_NODOTS "${PYTHON3_VERSION_NODOTS}" CACHE INTERNAL "" )
  endif( )
endif( )
if( NOT PYTHON2_VERSION_NODOTS )
  if ( PYTHON2_VERSION )
    set( PYTHON2_VERSION_NODOTS ${PYTHON2_VERSION} )
    string( REPLACE "." "" PYTHON2_VERSION_NODOTS "${PYTHON2_VERSION_NODOTS}" )
    set( PYTHON2_VERSION_NODOTS ${PYTHON2_VERSION_NODOTS} CACHE INTERNAL "" )
  endif( )
endif( )
if ( PACKAGER STREQUAL "rpm" )
  RPMBuildDependencies( depends )
elseif ( PACKAGER STREQUAL "deb" )
  DebBuildDependencies( depends )
else( )
  set( VERBOSE False )
endif( )
if ( VERBOSE )
  if ( DEFINED INCLUDE_PATTERN )
    if ( NOT "${INCLUDE_PATTERN}" MATCHES "^[\\^]")
      set(INCLUDE_PATTERN "^.*${INCLUDE_PATTERN}")
    endif( )
    if ( NOT "${INCLUDE_PATTERN}" MATCHES "[\\$]$")
      set(INCLUDE_PATTERN "${INCLUDE_PATTERN}.*$")
    endif( )
    foreach( dep ${depends} )
      if ( "${dep}" MATCHES "${INCLUDE_PATTERN}" )
        list(APPEND new_depends "${dep}" )
      endif( )
    endforeach( )
    set(depends ${new_depends})
  endif( )
  if ( DEFINED EXCLUDE_PATTERN )
    if ( NOT "${EXCLUDE_PATTERN}" MATCHES "^[\\^]")
      set(EXCLUDE_PATTERN "^.*${EXCLUDE_PATTERN}")
    endif( )
    if ( NOT "${EXCLUDE_PATTERN}" MATCHES "[\\$]$")
      set(EXCLUDE_PATTERN "${EXCLUDE_PATTERN}.*$")
    endif( )
    foreach( dep ${depends} )
      if ( NOT "${dep}" MATCHES "${EXCLUDE_PATTERN}" )
        list(APPEND new_depends "${dep}" )
      endif( )
    endforeach( )
    set(depends ${new_depends})
  endif( )
  foreach( dep ${depends} )
    echo( ${dep} )
  endforeach( )
endif( )
