/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class ReferenceArraySet<K>
extends AbstractReferenceSet<K>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient Object[] a;
    protected int size;

    public ReferenceArraySet(Object[] a) {
        this.a = a;
        this.size = a.length;
    }

    public ReferenceArraySet() {
        this.a = ObjectArrays.EMPTY_ARRAY;
    }

    public ReferenceArraySet(int capacity) {
        this.a = new Object[capacity];
    }

    public ReferenceArraySet(ReferenceCollection<K> c) {
        this(c.size());
        this.addAll(c);
    }

    public ReferenceArraySet(Collection<? extends K> c) {
        this(c.size());
        this.addAll(c);
    }

    public ReferenceArraySet(ReferenceSet<K> c) {
        this(c.size());
        int i = 0;
        for (Object x : c) {
            this.a[i] = x;
            ++i;
        }
        this.size = i;
    }

    public ReferenceArraySet(Set<? extends K> c) {
        this(c.size());
        int i = 0;
        for (K x : c) {
            this.a[i] = x;
            ++i;
        }
        this.size = i;
    }

    public ReferenceArraySet(Object[] a, int size) {
        this.a = a;
        this.size = size;
        if (size > a.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a.length + ")");
        }
    }

    public static <K> ReferenceArraySet<K> of() {
        return ReferenceArraySet.ofUnchecked();
    }

    public static <K> ReferenceArraySet<K> of(K e) {
        return ReferenceArraySet.ofUnchecked(e);
    }

    @SafeVarargs
    public static <K> ReferenceArraySet<K> of(K ... a) {
        if (a.length == 2) {
            if (a[0] == a[1]) {
                throw new IllegalArgumentException("Duplicate element: " + a[1]);
            }
        } else if (a.length > 2) {
            ReferenceOpenHashSet.of(a);
        }
        return ReferenceArraySet.ofUnchecked(a);
    }

    public static <K> ReferenceArraySet<K> ofUnchecked() {
        return new ReferenceArraySet<K>();
    }

    @SafeVarargs
    public static <K> ReferenceArraySet<K> ofUnchecked(K ... a) {
        return new ReferenceArraySet<K>(a);
    }

    private int findKey(Object o) {
        Object[] a = this.a;
        int i = this.size;
        while (i-- != 0) {
            if (a[i] != o) continue;
            return i;
        }
        return -1;
    }

    public ObjectIterator<K> iterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ObjectSpliterator<K> spliterator() {
        return new Spliterator(this);
    }

    public boolean contains(Object k) {
        return this.findKey(k) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(Object k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i = 0; i < tail; ++i) {
            this.a[pos + i] = this.a[pos + i + 1];
        }
        --this.size;
        this.a[this.size] = null;
        return true;
    }

    public boolean add(K k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            Object[] b = new Object[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                b[i] = this.a[i];
            }
            this.a = b;
        }
        this.a[this.size++] = k;
        return true;
    }

    public void clear() {
        Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object[] toArray() {
        int size = this.size();
        if (size == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, size, Object[].class);
    }

    public <T> T[] toArray(T[] a) {
        if (a == null) {
            a = new Object[this.size];
        } else if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public ReferenceArraySet<K> clone() {
        ReferenceArraySet c;
        try {
            c = (ReferenceArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.a = (Object[])this.a.clone();
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] a = this.a;
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new Object[this.size];
        Object[] a = this.a;
        for (int i = 0; i < this.size; ++i) {
            a[i] = s.readObject();
        }
    }
}

