/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.lucene.demo.html.HTMLParser;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class HTMLDocument {
    static char dirSep = System.getProperty("file.separator").charAt(0);

    public static String uid(File f) {
        return f.getPath().replace(dirSep, '\u0000') + "\u0000" + DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.SECOND);
    }

    public static String uid2url(String uid) {
        String url = uid.replace('\u0000', '/');
        return url.substring(0, url.lastIndexOf(47));
    }

    public static Document Document(File f) throws IOException, InterruptedException {
        Document doc = new Document();
        doc.add(new Field("path", f.getPath().replace(dirSep, '/'), Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add(new Field("modified", DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add(new Field("uid", HTMLDocument.uid(f), Field.Store.NO, Field.Index.UN_TOKENIZED));
        FileInputStream fis = new FileInputStream(f);
        HTMLParser parser = new HTMLParser(fis);
        doc.add(new Field("contents", parser.getReader()));
        doc.add(new Field("summary", parser.getSummary(), Field.Store.YES, Field.Index.NO));
        doc.add(new Field("title", parser.getTitle(), Field.Store.YES, Field.Index.TOKENIZED));
        return doc;
    }

    private HTMLDocument() {
    }
}

