/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.sasn1.Asn1OctetString;
import org.bouncycastle.sasn1.Asn1Sequence;
import org.bouncycastle.sasn1.cms.CompressedDataParser;
import org.bouncycastle.sasn1.cms.ContentInfoParser;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] byArray) throws CMSException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSCompressedDataParser(InputStream inputStream) throws CMSException {
        super(inputStream);
    }

    public CMSTypedStream getContent() throws CMSException {
        try {
            CompressedDataParser compressedDataParser = new CompressedDataParser((Asn1Sequence)((Object)this._contentInfo.getContent(16)));
            ContentInfoParser contentInfoParser = compressedDataParser.getEncapContentInfo();
            Asn1OctetString asn1OctetString = (Asn1OctetString)((Object)contentInfoParser.getContent(4));
            return new CMSTypedStream(contentInfoParser.getContentType().toString(), new InflaterInputStream(asn1OctetString.getOctetStream()));
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading compressed content.", iOException);
        }
    }
}

