// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import * as React from 'react';
/**
 * A tsx component for a set of items logically grouped together.
 */
export function GroupItem(props) {
    const { spacing, children, className, ...rest } = props;
    const numChildren = React.Children.count(children);
    return (React.createElement("div", { className: `jp-StatusBar-GroupItem ${className || ''}`, ...rest }, React.Children.map(children, (child, i) => {
        if (i === 0) {
            return React.createElement("div", { style: { marginRight: `${spacing}px` } }, child);
        }
        else if (i === numChildren - 1) {
            return React.createElement("div", { style: { marginLeft: `${spacing}px` } }, child);
        }
        else {
            return React.createElement("div", { style: { margin: `0px ${spacing}px` } }, child);
        }
    })));
}
//# sourceMappingURL=group.js.map