// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Token } from '@lumino/coreutils';
/**
 * A token for which a plugin can provide to respond to connection failures
 * to the application server.
 */
export const IConnectionLost = new Token('@jupyterlab/application:IConnectionLost', `A service for invoking the dialog shown
  when JupyterLab has lost its connection to the server. Use this if, for some reason,
  you want to bring up the "connection lost" dialog under new circumstances.`);
/**
 * The application status token.
 */
export const ILabStatus = new Token('@jupyterlab/application:ILabStatus', `A service for interacting with the application busy/dirty
  status. Use this if you want to set the application "busy" favicon, or to set
  the application "dirty" status, which asks the user for confirmation before leaving the application page.`);
/**
 * The URL Router token.
 */
export const IRouter = new Token('@jupyterlab/application:IRouter', 'The URL router used by the application. Use this to add custom URL-routing for your extension (e.g., to invoke a command if the user navigates to a sub-path).');
//# sourceMappingURL=tokens.js.map