import { Registration, ServerCapabilities, Unregistration } from 'vscode-languageserver-protocol';
/**
 * Register the capabilities with the server capabilities provider
 *
 * @param serverCapabilities - server capabilities provider.
 * @param registration -  capabilities to be registered.
 * @return - the new server capabilities provider
 */
declare function registerServerCapability(serverCapabilities: ServerCapabilities, registration: Registration): ServerCapabilities | null;
/**
 * Unregister the capabilities with the server capabilities provider
 *
 * @param serverCapabilities - server capabilities provider.
 * @param registration -  capabilities to be unregistered.
 * @return - the new server capabilities provider
 */
declare function unregisterServerCapability(serverCapabilities: ServerCapabilities, unregistration: Unregistration): ServerCapabilities;
export { registerServerCapability, unregisterServerCapability };
