import { useEffect } from 'react';
/** The `NullField` component is used to render a field in the schema is null. It also ensures that the `formData` is
 * also set to null if it has no value.
 *
 * @param props - The `FieldProps` for this template
 */
function NullField(props) {
    const { formData, onChange } = props;
    useEffect(() => {
        if (formData === undefined) {
            onChange(null);
        }
    }, [formData, onChange]);
    return null;
}
export default NullField;
//# sourceMappingURL=NullField.js.map