import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from 'react';
import { ariaDescribedByIds, examplesId, getInputProps, } from '@rjsf/utils';
/** The `BaseInputTemplate` is the template to use to render the basic `<input>` component for the `core` theme.
 * It is used as the template for rendering many of the <input> based widgets that differ by `type` and callbacks only.
 * It can be customized/overridden for other themes or individual implementations as needed.
 *
 * @param props - The `WidgetProps` for this template
 */
export default function BaseInputTemplate(props) {
    const { id, name, // remove this from ...rest
    value, readonly, disabled, autofocus, onBlur, onFocus, onChange, onChangeOverride, options, schema, uiSchema, formContext, registry, rawErrors, type, hideLabel, // remove this from ...rest
    hideError, // remove this from ...rest
    ...rest } = props;
    // Note: since React 15.2.0 we can't forward unknown element attributes, so we
    // exclude the "options" and "schema" ones here.
    if (!id) {
        console.log('No id for', props);
        throw new Error(`no id for props ${JSON.stringify(props)}`);
    }
    const inputProps = {
        ...rest,
        ...getInputProps(schema, type, options),
    };
    let inputValue;
    if (inputProps.type === 'number' || inputProps.type === 'integer') {
        inputValue = value || value === 0 ? value : '';
    }
    else {
        inputValue = value == null ? '' : value;
    }
    const _onChange = useCallback(({ target: { value } }) => onChange(value === '' ? options.emptyValue : value), [onChange, options]);
    const _onBlur = useCallback(({ target: { value } }) => onBlur(id, value), [onBlur, id]);
    const _onFocus = useCallback(({ target: { value } }) => onFocus(id, value), [onFocus, id]);
    return (_jsxs(_Fragment, { children: [_jsx("input", { id: id, name: id, className: 'form-control', readOnly: readonly, disabled: disabled, autoFocus: autofocus, value: inputValue, ...inputProps, list: schema.examples ? examplesId(id) : undefined, onChange: onChangeOverride || _onChange, onBlur: _onBlur, onFocus: _onFocus, "aria-describedby": ariaDescribedByIds(id, !!schema.examples) }), Array.isArray(schema.examples) && (_jsx("datalist", { id: examplesId(id), children: schema.examples
                    .concat(schema.default && !schema.examples.includes(schema.default) ? [schema.default] : [])
                    .map((example) => {
                    return _jsx("option", { value: example }, example);
                }) }, `datalist_${id}`))] }));
}
//# sourceMappingURL=BaseInputTemplate.js.map