import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { getTemplate, getUiOptions, } from '@rjsf/utils';
import Label from './Label';
/** The `FieldTemplate` component is the template used by `SchemaField` to render any field. It renders the field
 * content, (label, description, children, errors and help) inside of a `WrapIfAdditional` component.
 *
 * @param props - The `FieldTemplateProps` for this component
 */
export default function FieldTemplate(props) {
    const { id, label, children, errors, help, description, hidden, required, displayLabel, registry, uiSchema } = props;
    const uiOptions = getUiOptions(uiSchema);
    const WrapIfAdditionalTemplate = getTemplate('WrapIfAdditionalTemplate', registry, uiOptions);
    if (hidden) {
        return _jsx("div", { className: 'hidden', children: children });
    }
    return (_jsxs(WrapIfAdditionalTemplate, { ...props, children: [displayLabel && _jsx(Label, { label: label, required: required, id: id }), displayLabel && description ? description : null, children, errors, help] }));
}
//# sourceMappingURL=FieldTemplate.js.map