import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from 'react';
import { ariaDescribedByIds, enumOptionsIsSelected, enumOptionsValueForIndex, optionId, } from '@rjsf/utils';
/** The `RadioWidget` is a widget for rendering a radio group.
 *  It is typically used with a string property constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function RadioWidget({ options, value, required, disabled, readonly, autofocus = false, onBlur, onFocus, onChange, id, }) {
    const { enumOptions, enumDisabled, inline, emptyValue } = options;
    const handleBlur = useCallback(({ target: { value } }) => onBlur(id, enumOptionsValueForIndex(value, enumOptions, emptyValue)), [onBlur, id]);
    const handleFocus = useCallback(({ target: { value } }) => onFocus(id, enumOptionsValueForIndex(value, enumOptions, emptyValue)), [onFocus, id]);
    return (_jsx("div", { className: 'field-radio-group', id: id, children: Array.isArray(enumOptions) &&
            enumOptions.map((option, i) => {
                const checked = enumOptionsIsSelected(option.value, value);
                const itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
                const disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
                const handleChange = () => onChange(option.value);
                const radio = (_jsxs("span", { children: [_jsx("input", { type: 'radio', id: optionId(id, i), checked: checked, name: id, required: required, value: String(i), disabled: disabled || itemDisabled || readonly, autoFocus: autofocus && i === 0, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": ariaDescribedByIds(id) }), _jsx("span", { children: option.label })] }));
                return inline ? (_jsx("label", { className: `radio-inline ${disabledCls}`, children: radio }, i)) : (_jsx("div", { className: `radio ${disabledCls}`, children: _jsx("label", { children: radio }) }, i));
            }) }));
}
export default RadioWidget;
//# sourceMappingURL=RadioWidget.js.map